# stack-direction.m4 serial 11
dnl Copyright (C) 2002-2023 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl Written by Bruno Haible.

# Determine the stack direction. Define the C macro STACK_DIRECTION.
AC_DEFUN([SV_STACK_DIRECTION],
[
  AC_REQUIRE([AC_CANONICAL_HOST])
  AC_CACHE_CHECK([for stack direction], [sv_cv_stack_direction_msg], [
    case "$host_cpu" in
      dnl See the #define STACK_GROWS_DOWNWARD in gcc-3.1/gcc/config/*/*.h.
      a29k | \
      aarch64* | \
      alpha* | \
      arc | arceb | arc32 | arc64 | \
      arm* | strongarm* | xscale* | \
      avr | avr32 | \
      bfin | \
      c1 | c2 | c32 | c34 | c38 | \
      clipper | \
      cr16 | \
      cris | \
      csky | \
      d30v | \
      epiphany | \
      elxsi | \
      fr30 | \
      frv | \
      ft32 | \
      h8300 | \
      i?86 | x86_64 | \
      i860 | \
      ia64 | \
      iq2000 | \
      lm32 | \
      loongarch* | \
      m32c | \
      m32r | \
      m68* | \
      m88k | \
      mcore | \
      microblaze* | \
      mips* | \
      mmix | \
      mn10200 | \
      mn10300 | \
      moxie | \
      msp430 | \
      nds32* | \
      nios2 | nios2eb | nios2el | \
      ns32k | \
      nvptx | \
      or1k | \
      pdp11 | \
      pj* | \
      powerpc* | rs6000 | \
      pru | \
      riscv* | \
      rl78 | \
      romp | \
      rx | \
      s390* | \
      sh* | \
      sparc* | \
      tic6x | \
      tilegx | \
      tilepro | \
      v850 | \
      vax | \
      visium | \
      xtensa)
        sv_cv_stack_direction=-1 ;;
      c4x | \
      dsp16xx | \
      i960 | \
      hppa* | parisc* | \
      stormy16 | \
      we32k)
        sv_cv_stack_direction=1 ;;
      *)
        if test $cross_compiling = no; then
          cat > conftest.c <<EOF
#include <stdio.h>
int
find_stack_direction (int *addr, int depth)
{
  int dir, dummy = 0;
  if (! addr)
    addr = &dummy;
  *addr = addr < &dummy ? 1 : addr == &dummy ? 0 : -1;
  dir = depth ? find_stack_direction (addr, depth - 1) : 0;
  return dir + dummy;
}
int
main (int argc, char *argv[[]])
{
  printf ("%d\n", find_stack_direction (NULL, argc + 20));
  return 0;
}
EOF
          AC_TRY_EVAL([ac_link])
          sv_cv_stack_direction=`./conftest`
        else
          sv_cv_stack_direction=0
        fi
        ;;
    esac
    case $sv_cv_stack_direction in
      1)  sv_cv_stack_direction_msg="grows up";;
      -1) sv_cv_stack_direction_msg="grows down";;
      *)  sv_cv_stack_direction_msg="unknown";;
    esac
  ])
  AC_DEFINE_UNQUOTED([STACK_DIRECTION], [$sv_cv_stack_direction],
    [Define as the direction of stack growth for your system.
     STACK_DIRECTION > 0 => grows toward higher addresses
     STACK_DIRECTION < 0 => grows toward lower addresses
     STACK_DIRECTION = 0 => spaghetti stack.])
])
