/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.utils.ManagerUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.eclipse.wb.tests.designer.swt.model.property.ImagePropertyEditorTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class SWTResourceManagerTest
extends RcpModelTest {
    private Class<?> DisplayClass;
    private Object m_defaultDisplay;
    private Class<?> SWTManagerClass;
    private Class<?> ImageClass;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ManagerUtils.ensure_SWTResourceManager((JavaInfo)shell);
        this.DisplayClass = this.m_lastLoader.loadClass("org.eclipse.swt.widgets.Display");
        this.ImageClass = this.m_lastLoader.loadClass("org.eclipse.swt.graphics.Image");
        this.SWTManagerClass = this.m_lastLoader.loadClass("org.eclipse.wb.swt.SWTResourceManager");
        this.m_defaultDisplay = ReflectionUtils.invokeMethod(this.DisplayClass, (String)"getDefault()", (Object[])new Object[0]);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (m_testProject != null && this.SWTManagerClass != null) {
            ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"dispose()", (Object[])new Object[0]);
        }
        super.tearDown();
        this.DisplayClass = null;
        this.SWTManagerClass = null;
        this.ImageClass = null;
        this.m_defaultDisplay = null;
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_systemColor() throws Exception {
        Object expectedColor = ReflectionUtils.invokeMethod((Object)this.m_defaultDisplay, (String)"getSystemColor(int)", (Object[])new Object[]{3});
        Object actualColor = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getColor(int)", (Object[])new Object[]{3});
        SWTResourceManagerTest.assertEquals((Object)expectedColor, (Object)actualColor);
    }

    @Test
    public void test_getColor_ints() throws Exception {
        Object color = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getColor(int,int,int)", (Object[])new Object[]{1, 2, 3});
        SWTResourceManagerTest.assertNotNull((Object)color);
        SWTResourceManagerTest.assertEquals((Object)1, (Object)ReflectionUtils.invokeMethod((Object)color, (String)"getRed()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertEquals((Object)2, (Object)ReflectionUtils.invokeMethod((Object)color, (String)"getGreen()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertEquals((Object)3, (Object)ReflectionUtils.invokeMethod((Object)color, (String)"getBlue()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)color, (String)"isDisposed()", (Object[])new Object[0])));
        SWTResourceManagerTest.assertSame((Object)color, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getColor(int,int,int)", (Object[])new Object[]{1, 2, 3}));
    }

    @Test
    public void test_getColor_RGB() throws Exception {
        Class<?> RGBClass = this.m_lastLoader.loadClass("org.eclipse.swt.graphics.RGB");
        Object rgb = ReflectionUtils.getConstructorBySignature(RGBClass, (String)"<init>(int,int,int)").newInstance(1, 2, 3);
        Object color = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getColor(org.eclipse.swt.graphics.RGB)", (Object[])new Object[]{rgb});
        SWTResourceManagerTest.assertNotNull((Object)color);
        SWTResourceManagerTest.assertEquals((Object)1, (Object)ReflectionUtils.invokeMethod((Object)color, (String)"getRed()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertEquals((Object)2, (Object)ReflectionUtils.invokeMethod((Object)color, (String)"getGreen()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertEquals((Object)3, (Object)ReflectionUtils.invokeMethod((Object)color, (String)"getBlue()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)color, (String)"isDisposed()", (Object[])new Object[0])));
        SWTResourceManagerTest.assertSame((Object)color, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getColor(org.eclipse.swt.graphics.RGB)", (Object[])new Object[]{rgb}));
        SWTResourceManagerTest.assertSame((Object)color, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getColor(int,int,int)", (Object[])new Object[]{1, 2, 3}));
    }

    @Test
    public void test_disposeColors() throws Exception {
        Object color = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getColor(int,int,int)", (Object[])new Object[]{1, 2, 3});
        SWTResourceManagerTest.assertNotNull((Object)color);
        SWTResourceManagerTest.assertEquals((Object)1, (Object)ReflectionUtils.invokeMethod((Object)color, (String)"getRed()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertEquals((Object)2, (Object)ReflectionUtils.invokeMethod((Object)color, (String)"getGreen()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertEquals((Object)3, (Object)ReflectionUtils.invokeMethod((Object)color, (String)"getBlue()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)color, (String)"isDisposed()", (Object[])new Object[0])));
        Object colorMap = ReflectionUtils.getFieldObject(this.SWTManagerClass, (String)"m_colorMap");
        SWTResourceManagerTest.assertEquals((Object)1, (Object)ReflectionUtils.invokeMethod((Object)colorMap, (String)"size()", (Object[])new Object[0]));
        ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"disposeColors()", (Object[])new Object[0]);
        SWTResourceManagerTest.assertEquals((Object)0, (Object)ReflectionUtils.invokeMethod((Object)colorMap, (String)"size()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertTrue((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)color, (String)"isDisposed()", (Object[])new Object[0])));
    }

    @Test
    public void test_getImage_absolute() throws Exception {
        File imageFile = ImagePropertyEditorTest.createTempImage();
        try {
            String path = imageFile.getCanonicalPath();
            Image image = (Image)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getImage(java.lang.String)", (Object[])new Object[]{path});
            SWTResourceManagerTest.assertNotNull((Object)image);
            SWTResourceManagerTest.assertFalse((boolean)image.isDisposed());
            SWTResourceManagerTest.assertSame((Object)image, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getImage(java.lang.String)", (Object[])new Object[]{path}));
            Image directImage = new Image(null, path);
            try {
                SWTResourceManagerTest.assertEqualsImage(image, directImage);
            }
            finally {
                directImage.dispose();
            }
        }
        finally {
            imageFile.delete();
        }
    }

    @Disabled
    @Test
    public void test_getImage_classpath() throws Exception {
        Image image = (Image)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getImage(java.lang.Class,java.lang.String)", (Object[])new Object[]{this.SWTManagerClass, "/javax/swing/plaf/basic/icons/JavaCup16.png"});
        SWTResourceManagerTest.assertNotNull((Object)image);
        SWTResourceManagerTest.assertFalse((boolean)image.isDisposed());
        SWTResourceManagerTest.assertSame((Object)image, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getImage(java.lang.Class,java.lang.String)", (Object[])new Object[]{this.SWTManagerClass, "/javax/swing/plaf/basic/icons/JavaCup16.png"}));
        Image directImage = new Image(null, ((Object)((Object)this)).getClass().getResourceAsStream("/javax/swing/plaf/basic/icons/JavaCup16.png"));
        try {
            SWTResourceManagerTest.assertEqualsImage(image, directImage);
        }
        finally {
            directImage.dispose();
        }
        Image image1 = (Image)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getImage(java.lang.Class,java.lang.String)", (Object[])new Object[]{this.SWTManagerClass, "/javax/swing/plaf/basic/icons/image-failed.png"});
        SWTResourceManagerTest.assertNotNull((Object)image1);
        SWTResourceManagerTest.assertFalse((boolean)image1.isDisposed());
        SWTResourceManagerTest.assertSame((Object)image1, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getImage(java.lang.Class,java.lang.String)", (Object[])new Object[]{this.SWTManagerClass, "/javax/swing/plaf/basic/icons/image-failed.png"}));
        SWTResourceManagerTest.assertNotSame((Object)image, (Object)image1);
    }

    @Test
    public void test_getImage_getMissingImage() throws Exception {
        Image image = (Image)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getImage(java.lang.String)", (Object[])new Object[]{"xxx:xxx:xxx"});
        SWTResourceManagerTest.assertNotNull((Object)image);
        SWTResourceManagerTest.assertFalse((boolean)image.isDisposed());
        SWTResourceManagerTest.assertSame((Object)image, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getImage(java.lang.String)", (Object[])new Object[]{"xxx:xxx:xxx"}));
        Image image1 = (Image)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getImage(java.lang.Class,java.lang.String)", (Object[])new Object[]{this.SWTManagerClass, "/yyy|yyy|yyy"});
        SWTResourceManagerTest.assertNotNull((Object)image1);
        SWTResourceManagerTest.assertSame((Object)image1, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getImage(java.lang.Class,java.lang.String)", (Object[])new Object[]{this.SWTManagerClass, "/yyy|yyy|yyy"}));
        SWTResourceManagerTest.assertFalse((boolean)image1.isDisposed());
        SWTResourceManagerTest.assertNotSame((Object)image, (Object)image1);
        SWTResourceManagerTest.assertEqualsImage(image, image1);
    }

    @Test
    public void test_disposeImages() throws Exception {
        Object image = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getImage(java.lang.Class,java.lang.String)", (Object[])new Object[]{this.SWTManagerClass, "/javax/swing/plaf/basic/icons/JavaCup16.png"});
        SWTResourceManagerTest.assertNotNull((Object)image);
        SWTResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)image, (String)"isDisposed()", (Object[])new Object[0])));
        Object imageMap = ReflectionUtils.getFieldObject(this.SWTManagerClass, (String)"m_imageMap");
        SWTResourceManagerTest.assertEquals((Object)1, (Object)ReflectionUtils.invokeMethod((Object)imageMap, (String)"size()", (Object[])new Object[0]));
        ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"disposeImages()", (Object[])new Object[0]);
        SWTResourceManagerTest.assertEquals((Object)0, (Object)ReflectionUtils.invokeMethod((Object)imageMap, (String)"size()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertTrue((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)image, (String)"isDisposed()", (Object[])new Object[0])));
    }

    private static void assertEqualsImage(Image image1, Image image2) throws Exception {
        ImageData data1 = image1.getImageData();
        ImageData data2 = image2.getImageData();
        SWTResourceManagerTest.assertEquals((int)data1.width, (int)data2.width);
        SWTResourceManagerTest.assertEquals((int)data1.height, (int)data2.height);
        SWTResourceManagerTest.assertEquals((int)data1.depth, (int)data2.depth);
        SWTResourceManagerTest.assertEquals((int)data1.scanlinePad, (int)data2.scanlinePad);
        SWTResourceManagerTest.assertEquals((int)data1.bytesPerLine, (int)data2.bytesPerLine);
        SWTResourceManagerTest.assertEquals((int)data1.transparentPixel, (int)data2.transparentPixel);
        SWTResourceManagerTest.assertEquals((int)data1.maskPad, (int)data2.maskPad);
        SWTResourceManagerTest.assertEquals((int)data1.alpha, (int)data2.alpha);
        SWTResourceManagerTest.assertEquals((int)data1.x, (int)data2.x);
        SWTResourceManagerTest.assertEquals((int)data1.y, (int)data2.y);
    }

    @Test
    public void test_decorateImage_wrongCorner() throws Exception {
        try {
            ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{null, null, 0});
            SWTResourceManagerTest.fail();
        }
        catch (IllegalArgumentException e) {
            SWTResourceManagerTest.assertEquals((Object)"Wrong decorate corner", (Object)e.getMessage());
        }
        try {
            ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{null, null, 5});
            SWTResourceManagerTest.fail();
        }
        catch (IllegalArgumentException e) {
            SWTResourceManagerTest.assertEquals((Object)"Wrong decorate corner", (Object)e.getMessage());
        }
    }

    @Test
    public void test_decorateImage() throws Exception {
        int corner = ReflectionUtils.getFieldInt(this.SWTManagerClass, (String)"BOTTOM_RIGHT");
        Object[] images = this.createImages();
        Object base = images[0];
        Object decorator = images[1];
        try {
            Object image = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner});
            SWTResourceManagerTest.assertNotNull((Object)image);
            SWTResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)image, (String)"isDisposed()", (Object[])new Object[0])));
            SWTResourceManagerTest.assertSame((Object)image, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image)", (Object[])new Object[]{base, decorator}));
        }
        finally {
            ReflectionUtils.invokeMethod((Object)base, (String)"dispose()", (Object[])new Object[0]);
            ReflectionUtils.invokeMethod((Object)decorator, (String)"dispose()", (Object[])new Object[0]);
        }
    }

    @Test
    public void test_decorateImage2() throws Exception {
        int corner = ReflectionUtils.getFieldInt(this.SWTManagerClass, (String)"BOTTOM_RIGHT");
        int corner1 = ReflectionUtils.getFieldInt(this.SWTManagerClass, (String)"TOP_LEFT");
        Object[] images = this.createImages();
        Object base = images[0];
        Object decorator = images[1];
        try {
            Object image = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner});
            SWTResourceManagerTest.assertNotNull((Object)image);
            SWTResourceManagerTest.assertSame((Object)image, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner}));
            Object image1 = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner1});
            SWTResourceManagerTest.assertNotNull((Object)image1);
            SWTResourceManagerTest.assertSame((Object)image1, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner1}));
            SWTResourceManagerTest.assertNotSame((Object)image, (Object)image1);
        }
        finally {
            ReflectionUtils.invokeMethod((Object)base, (String)"dispose()", (Object[])new Object[0]);
            ReflectionUtils.invokeMethod((Object)decorator, (String)"dispose()", (Object[])new Object[0]);
        }
    }

    @Test
    public void test_decorateImage_TOP_LEFT() throws Exception {
        int corner = ReflectionUtils.getFieldInt(this.SWTManagerClass, (String)"TOP_LEFT");
        this.test_decorateImage(corner);
    }

    @Test
    public void test_decorateImage_TOP_RIGHT() throws Exception {
        int corner = ReflectionUtils.getFieldInt(this.SWTManagerClass, (String)"TOP_RIGHT");
        this.test_decorateImage(corner);
    }

    @Test
    public void test_decorateImage_BOTTOM_LEFT() throws Exception {
        int corner = ReflectionUtils.getFieldInt(this.SWTManagerClass, (String)"BOTTOM_LEFT");
        this.test_decorateImage(corner);
    }

    @Test
    public void test_decorateImage_BOTTOM_RIGHT() throws Exception {
        int corner = ReflectionUtils.getFieldInt(this.SWTManagerClass, (String)"BOTTOM_RIGHT");
        this.test_decorateImage(corner);
    }

    private void test_decorateImage(int corner) throws Exception {
        Object[] images = this.createImages();
        Object base = images[0];
        Object decorator = images[1];
        try {
            Object image = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner});
            SWTResourceManagerTest.assertNotNull((Object)image);
            SWTResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)image, (String)"isDisposed()", (Object[])new Object[0])));
            SWTResourceManagerTest.assertSame((Object)image, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner}));
            int blackPixel = SWTResourceManagerTest.getPixels(decorator)[0][0];
            int[][] result = SWTResourceManagerTest.getPixels(base);
            if (corner == 1) {
                result[0][0] = blackPixel;
            } else if (corner == 2) {
                result[2][0] = blackPixel;
            } else if (corner == 3) {
                result[0][2] = blackPixel;
            } else if (corner == 4) {
                result[2][2] = blackPixel;
            }
            SWTResourceManagerTest.assertEquals((Object)SWTResourceManagerTest.getText(result), (Object)SWTResourceManagerTest.getText(SWTResourceManagerTest.getPixels(image)));
        }
        finally {
            ReflectionUtils.invokeMethod((Object)base, (String)"dispose()", (Object[])new Object[0]);
            ReflectionUtils.invokeMethod((Object)decorator, (String)"dispose()", (Object[])new Object[0]);
        }
    }

    private Object[] createImages() throws Exception {
        Constructor constructor = ReflectionUtils.getConstructorBySignature(this.ImageClass, (String)"<init>(org.eclipse.swt.graphics.Device,int,int)");
        Object baseImage = constructor.newInstance(null, 3, 3);
        this.fillImage(baseImage, 1, 3, 3);
        Object decoratorImage = constructor.newInstance(null, 1, 1);
        this.fillImage(decoratorImage, 2, 1, 1);
        return new Object[]{baseImage, decoratorImage};
    }

    private void fillImage(Object image, int color, int width, int height) throws Exception {
        Class<?> GCClass = this.m_lastLoader.loadClass("org.eclipse.swt.graphics.GC");
        Object gc = ReflectionUtils.getConstructorBySignature(GCClass, (String)"<init>(org.eclipse.swt.graphics.Drawable)").newInstance(image);
        Object colorObject = ReflectionUtils.invokeMethod((Object)this.m_defaultDisplay, (String)"getSystemColor(int)", (Object[])new Object[]{color});
        ReflectionUtils.invokeMethod(gc, (String)"setBackground(org.eclipse.swt.graphics.Color)", (Object[])new Object[]{colorObject});
        ReflectionUtils.invokeMethod(gc, (String)"fillRectangle(int,int,int,int)", (Object[])new Object[]{0, 0, width, height});
        ReflectionUtils.invokeMethod(gc, (String)"dispose()", (Object[])new Object[0]);
    }

    private static int[][] getPixels(Object image) throws Exception {
        Object data = ReflectionUtils.invokeMethod((Object)image, (String)"getImageData()", (Object[])new Object[0]);
        Object palette = ReflectionUtils.getFieldObject((Object)data, (String)"palette");
        int width = ReflectionUtils.getFieldInt((Object)data, (String)"width");
        int height = ReflectionUtils.getFieldInt((Object)data, (String)"height");
        int[][] pixels = new int[width][height];
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                int pixel = (Integer)ReflectionUtils.invokeMethod((Object)data, (String)"getPixel(int,int)", (Object[])new Object[]{i, j});
                Object rgb = ReflectionUtils.invokeMethod((Object)palette, (String)"getRGB(int)", (Object[])new Object[]{pixel});
                pixels[i][j] = ReflectionUtils.getFieldInt((Object)rgb, (String)"red");
                ++j;
            }
            ++i;
        }
        return pixels;
    }

    private static String getText(int[][] data) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            int[] line = data[i];
            int j = 0;
            while (j < line.length) {
                buffer.append(line[j]);
                buffer.append(' ');
                ++j;
            }
            buffer.append('\n');
            ++i;
        }
        return buffer.toString();
    }

    @Test
    public void test_getFont() throws Exception {
        Object font = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getFont(java.lang.String,int,int)", (Object[])new Object[]{"Courier New", 12, 2});
        SWTResourceManagerTest.assertNotNull((Object)font);
        SWTResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)font, (String)"isDisposed()", (Object[])new Object[0])));
        SWTResourceManagerTest.checkEqulas("Courier New", 12, 2, font);
        SWTResourceManagerTest.assertSame((Object)font, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getFont(java.lang.String,int,int)", (Object[])new Object[]{"Courier New", 12, 2}));
        Object font1 = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getFont(java.lang.String,int,int)", (Object[])new Object[]{"Arial", 14, 0});
        SWTResourceManagerTest.assertNotNull((Object)font1);
        SWTResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)font1, (String)"isDisposed()", (Object[])new Object[0])));
        SWTResourceManagerTest.checkEqulas("Arial", 14, 0, font1);
        SWTResourceManagerTest.assertSame((Object)font1, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getFont(java.lang.String,int,int)", (Object[])new Object[]{"Arial", 14, 0}));
    }

    @Test
    public void test_getBoldFont() throws Exception {
        Object font = ReflectionUtils.invokeMethod((Object)this.m_defaultDisplay, (String)"getSystemFont()", (Object[])new Object[0]);
        Object boldFont = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getBoldFont(org.eclipse.swt.graphics.Font)", (Object[])new Object[]{font});
        SWTResourceManagerTest.assertNotNull((Object)boldFont);
        SWTResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)boldFont, (String)"isDisposed()", (Object[])new Object[0])));
        Object fontData = Array.get(ReflectionUtils.invokeMethod((Object)font, (String)"getFontData()", (Object[])new Object[0]), 0);
        SWTResourceManagerTest.checkEqulas((String)ReflectionUtils.invokeMethod((Object)fontData, (String)"getName()", (Object[])new Object[0]), (Integer)ReflectionUtils.invokeMethod((Object)fontData, (String)"getHeight()", (Object[])new Object[0]), 1, boldFont);
        SWTResourceManagerTest.assertSame((Object)boldFont, (Object)ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getBoldFont(org.eclipse.swt.graphics.Font)", (Object[])new Object[]{font}));
    }

    @Test
    public void test_disposeFonts() throws Exception {
        Object font = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getFont(java.lang.String,int,int)", (Object[])new Object[]{"Courier New", 12, 2});
        SWTResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)font, (String)"isDisposed()", (Object[])new Object[0])));
        Object boldFont = ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"getBoldFont(org.eclipse.swt.graphics.Font)", (Object[])new Object[]{font});
        SWTResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)boldFont, (String)"isDisposed()", (Object[])new Object[0])));
        Object fontMap = ReflectionUtils.getFieldObject(this.SWTManagerClass, (String)"m_fontMap");
        Object fontToBoldFontMap = ReflectionUtils.getFieldObject(this.SWTManagerClass, (String)"m_fontToBoldFontMap");
        SWTResourceManagerTest.assertEquals((Object)1, (Object)ReflectionUtils.invokeMethod((Object)fontMap, (String)"size()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertEquals((Object)1, (Object)ReflectionUtils.invokeMethod((Object)fontToBoldFontMap, (String)"size()", (Object[])new Object[0]));
        ReflectionUtils.invokeMethod(this.SWTManagerClass, (String)"disposeFonts()", (Object[])new Object[0]);
        SWTResourceManagerTest.assertEquals((Object)0, (Object)ReflectionUtils.invokeMethod((Object)fontMap, (String)"size()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertEquals((Object)0, (Object)ReflectionUtils.invokeMethod((Object)fontToBoldFontMap, (String)"size()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertTrue((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)font, (String)"isDisposed()", (Object[])new Object[0])));
        SWTResourceManagerTest.assertTrue((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)boldFont, (String)"isDisposed()", (Object[])new Object[0])));
    }

    private static void checkEqulas(String name, int height, int style, Object font) throws Exception {
        Object fontData = Array.get(ReflectionUtils.invokeMethod((Object)font, (String)"getFontData()", (Object[])new Object[0]), 0);
        SWTResourceManagerTest.assertEquals((Object)name, (Object)ReflectionUtils.invokeMethod((Object)fontData, (String)"getName()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertEquals((Object)height, (Object)ReflectionUtils.invokeMethod((Object)fontData, (String)"getHeight()", (Object[])new Object[0]));
        SWTResourceManagerTest.assertEquals((Object)style, (Object)ReflectionUtils.invokeMethod((Object)fontData, (String)"getStyle()", (Object[])new Object[0]));
    }
}

