/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.model.IGenericProperty;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.rcp.Activator;
import org.eclipse.wb.internal.swt.model.property.editor.image.ImageEvaluator;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.swt.model.property.ImagePropertyEditorTest;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;

public class ImagePropertyEditorTestPlugin
extends ImagePropertyEditorTest {
    @Override
    protected void configureNewProject() throws Exception {
        super.configureNewProject();
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        ImagePropertyEditorTestPlugin.setFileContentSrc("testplugin/Activator.java", ImagePropertyEditorTestPlugin.getSourceDQ("package testplugin;", "import org.eclipse.ui.plugin.AbstractUIPlugin;", "public class Activator extends AbstractUIPlugin {", "  public Activator() {", "  }", "  public static Activator getDefault() {", "    return null;", "  }", "}"));
        IFile file = ImagePropertyEditorTestPlugin.getFile("icons", "1.png");
        ImagePropertyEditorTestPlugin.setFileContent(file, org.eclipse.wb.tests.designer.tests.Activator.getFile("icons/test.png"));
        ImagePropertyEditorTestPlugin.waitForAutoBuild();
        ImagePropertyEditorTestPlugin.forgetCreatedResources();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_ThisPluginImage_OLD() throws Exception {
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.SWTResourceManager");
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.ResourceManager");
        this.assert_getText_getClipboardSource_forSource("org.eclipse.wb.swt.ResourceManager.getPluginImage(testplugin.Activator.getDefault(), \"icons/1.png\")", "Plugin: TestProject icons/1.png", "org.eclipse.wb.swt.ResourceManager.getPluginImage(\"TestProject\", \"icons/1.png\")");
    }

    @Test
    public void test_ThisPluginImage_NEW_workspace() throws Exception {
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.SWTResourceManager");
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.ResourceManager");
        this.assert_getText_getClipboardSource_forSource("org.eclipse.wb.swt.ResourceManager.getPluginImage(\"TestProject\", \"icons/1.png\")", "Plugin: TestProject icons/1.png", "org.eclipse.wb.swt.ResourceManager.getPluginImage(\"TestProject\", \"icons/1.png\")");
    }

    @Test
    public void test_PluginImage_NEW() throws Exception {
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.SWTResourceManager");
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.ResourceManager");
        this.assert_getText_getClipboardSource_forSource("org.eclipse.wb.swt.ResourceManager.getPluginImage(\"org.eclipse.jdt.ui\", \"/icons/full/elcl16/ch_cancel.png\")", "Plugin: org.eclipse.jdt.ui /icons/full/elcl16/ch_cancel.png", "org.eclipse.wb.swt.ResourceManager.getPluginImage(\"org.eclipse.jdt.ui\", \"/icons/full/elcl16/ch_cancel.png\")");
    }

    @Test
    public void test_ThisPlugin_Value() throws Exception {
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.SWTResourceManager");
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.ResourceManager");
        GenericProperty property = this.createImagePropertyForSource("org.eclipse.wb.swt.ResourceManager.getPluginImage(\"TestProject\", \"icons/1.png\")");
        ImagePropertyEditorTestPlugin.assertNotNull((Object)property);
        ImagePropertyEditorTestPlugin.assertNotNull((Object)property.getValue());
        String[] values = ImageEvaluator.getPluginImageValue((IGenericProperty)property);
        ImagePropertyEditorTestPlugin.assertNotNull((Object)values);
        ImagePropertyEditorTestPlugin.assertEquals((int)2, (int)values.length);
        ImagePropertyEditorTestPlugin.assertEquals((Object)"TestProject", (Object)values[0]);
        ImagePropertyEditorTestPlugin.assertEquals((Object)"icons/1.png", (Object)values[1]);
    }

    @Test
    public void test_Plugin_Value() throws Exception {
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.SWTResourceManager");
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.ResourceManager");
        GenericProperty property = this.createImagePropertyForSource("org.eclipse.wb.swt.ResourceManager.getPluginImage(\"org.eclipse.jdt.ui\", \"/icons/full/elcl16/ch_cancel.png\")");
        ImagePropertyEditorTestPlugin.assertNotNull((Object)property);
        ImagePropertyEditorTestPlugin.assertNotNull((Object)property.getValue());
        String[] values = ImageEvaluator.getPluginImageValue((IGenericProperty)property);
        ImagePropertyEditorTestPlugin.assertNotNull((Object)values);
        ImagePropertyEditorTestPlugin.assertEquals((int)2, (int)values.length);
        ImagePropertyEditorTestPlugin.assertEquals((Object)"org.eclipse.jdt.ui", (Object)values[0]);
        ImagePropertyEditorTestPlugin.assertEquals((Object)"/icons/full/elcl16/ch_cancel.png", (Object)values[1]);
    }
}

