/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import java.util.LinkedList;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.ColumnInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.RowInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.junit.jupiter.api.Test;

public class GridBagDimensionTest
extends AbstractGridBagLayoutTest {
    @Test
    public void test_dimensions_0() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton('button 1 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton('button 1 1');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton('button 1 2');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 2;", "      add(button, gbc);", "    }", "  }", "}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        panel.refresh();
        LinkedList columns = layout.getColumns();
        GridBagDimensionTest.assertEquals((int)2, (int)columns.size());
        ColumnInfo column = (ColumnInfo)columns.get(0);
        GridBagDimensionTest.assertEquals((int)0, (int)column.getIndex());
        GridBagDimensionTest.assertEquals((int)0, (int)column.getSize());
        GridBagDimensionTest.assertEquals((double)0.0, (double)column.getWeight(), (double)1.0E-6);
        GridBagDimensionTest.assertFalse((boolean)column.hasWeight());
        column = (ColumnInfo)columns.get(1);
        GridBagDimensionTest.assertEquals((int)1, (int)column.getIndex());
        GridBagDimensionTest.assertEquals((int)0, (int)column.getSize());
        GridBagDimensionTest.assertEquals((double)0.0, (double)column.getWeight(), (double)1.0E-6);
        GridBagDimensionTest.assertFalse((boolean)column.hasWeight());
        LinkedList rows = layout.getRows();
        GridBagDimensionTest.assertEquals((int)3, (int)rows.size());
        RowInfo row = (RowInfo)rows.get(0);
        GridBagDimensionTest.assertEquals((int)0, (int)row.getIndex());
        GridBagDimensionTest.assertEquals((int)0, (int)row.getSize());
        GridBagDimensionTest.assertEquals((double)0.0, (double)row.getWeight(), (double)1.0E-6);
        GridBagDimensionTest.assertFalse((boolean)row.hasWeight());
    }

    @Test
    public void test_dimensions_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {100, 200, 0};", "    layout.rowHeights = new int[] {50, 0};", "    layout.columnWeights = new double[] {1.0, 2.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {1.0, Double.MIN_VALUE};", "    setLayout(layout);", "  }", "}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        panel.refresh();
        LinkedList columns = layout.getColumns();
        GridBagDimensionTest.assertEquals((int)2, (int)columns.size());
        ColumnInfo column = (ColumnInfo)columns.get(0);
        GridBagDimensionTest.assertEquals((int)0, (int)column.getIndex());
        GridBagDimensionTest.assertEquals((int)100, (int)column.getSize());
        GridBagDimensionTest.assertEquals((double)1.0, (double)column.getWeight(), (double)1.0E-6);
        GridBagDimensionTest.assertTrue((boolean)column.hasWeight());
        column = (ColumnInfo)columns.get(1);
        GridBagDimensionTest.assertEquals((int)1, (int)column.getIndex());
        GridBagDimensionTest.assertEquals((int)200, (int)column.getSize());
        GridBagDimensionTest.assertEquals((double)2.0, (double)column.getWeight(), (double)1.0E-6);
        GridBagDimensionTest.assertTrue((boolean)column.hasWeight());
        LinkedList rows = layout.getRows();
        GridBagDimensionTest.assertEquals((int)1, (int)rows.size());
        RowInfo row = (RowInfo)rows.get(0);
        GridBagDimensionTest.assertEquals((int)0, (int)row.getIndex());
        GridBagDimensionTest.assertEquals((int)50, (int)row.getSize());
        GridBagDimensionTest.assertEquals((double)1.0, (double)row.getWeight(), (double)1.0E-6);
        GridBagDimensionTest.assertTrue((boolean)row.hasWeight());
    }
}

