/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.widgets.ShellInfo;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.eclipse.wb.tests.designer.tests.Activator;
import org.junit.jupiter.api.Test;

public class ActivatorImagesTest
extends RcpModelTest {
    @Override
    protected void configureNewProject() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        ActivatorImagesTest.setFileContentSrc("testplugin/Activator.java", ActivatorImagesTest.getSourceDQ("package testplugin;", "import org.eclipse.jface.resource.ImageDescriptor;", "import org.eclipse.swt.graphics.Image;", "import org.eclipse.ui.plugin.AbstractUIPlugin;", "public class Activator extends AbstractUIPlugin {", "  public Activator() {", "  }", "  public static Activator getDefault() {", "    return null;", "  }", "  public static ImageDescriptor getImageDescriptor(String path) {", "    return null;", "  }", "  public static Image getImage(String path) {", "    return null;", "  }", "}"));
        IOUtils2.ensureFolderExists((IProject)m_testProject.getProject(), (String)"icons");
        IOUtils2.ensureFolderExists((IProject)m_testProject.getProject(), (String)"images");
        ActivatorImagesTest.waitForAutoBuild();
        IFile file = ActivatorImagesTest.getFile("icons", "1.png");
        ActivatorImagesTest.setFileContent(file, Activator.getFile("icons/test.png"));
        file = ActivatorImagesTest.getFile("images", "2.png");
        ActivatorImagesTest.setFileContent(file, Activator.getFile("icons/test.png"));
        ActivatorImagesTest.forgetCreatedResources();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getImage_icons() throws Exception {
        this.test_getImage("icons/1.png");
    }

    @Test
    public void test_getImage_win_icons() throws Exception {
        this.test_getImage("icons\\\\1.png");
    }

    @Test
    public void test_getImage_icons_slash() throws Exception {
        this.test_getImage("/icons/1.png");
    }

    @Test
    public void test_getImage_win_icons_slash() throws Exception {
        this.test_getImage("\\\\icons\\\\1.png");
    }

    @Test
    public void test_getImage_images() throws Exception {
        this.test_getImage("images/2.png");
    }

    @Test
    public void test_getImage_win_images() throws Exception {
        this.test_getImage("images\\\\2.png");
    }

    @Test
    public void test_getImage_images_slash() throws Exception {
        this.test_getImage("/images/2.png");
    }

    @Test
    public void test_getImage_win_images_slash() throws Exception {
        this.test_getImage("\\\\images\\\\2.png");
    }

    private void test_getImage(String path) throws Exception {
        ShellInfo shell = (ShellInfo)this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setImage(testplugin.Activator.getImage('" + path + "'));", "  }", "}");
        shell.refresh();
        Image image = shell.getImage();
        ActivatorImagesTest.assertNotNull((Object)image);
        ActivatorImagesTest.assertFalse((boolean)image.isDisposed());
    }

    @Test
    public void test_getImage_wrongPath() throws Exception {
        ShellInfo shell = (ShellInfo)this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setImage(testplugin.Activator.getImage('icons/3.png'));", "  }", "}");
        shell.refresh();
        ActivatorImagesTest.assertNull((Object)shell.getWidget().getImage());
    }

    @Test
    public void test_getImageDescriptor_icons() throws Exception {
        this.test_getImageDescriptor("icons/1.png", true);
    }

    @Test
    public void test_getImageDescriptor_win_icons() throws Exception {
        this.test_getImageDescriptor("icons\\\\1.png", true);
    }

    @Test
    public void test_getImageDescriptor_icons_slash() throws Exception {
        this.test_getImageDescriptor("/icons/1.png", true);
    }

    @Test
    public void test_getImageDescriptor_win_icons_slash() throws Exception {
        this.test_getImageDescriptor("\\\\icons\\\\1.png", true);
    }

    @Test
    public void test_getImageDescriptor_images() throws Exception {
        this.test_getImageDescriptor("images/2.png", true);
    }

    @Test
    public void test_getImageDescriptor_win_images() throws Exception {
        this.test_getImageDescriptor("images\\\\2.png", true);
    }

    @Test
    public void test_getImageDescriptor_images_slash() throws Exception {
        this.test_getImageDescriptor("/images/2.png", true);
    }

    @Test
    public void test_getImageDescriptor_win_images_slash() throws Exception {
        this.test_getImageDescriptor("\\\\images\\\\2.png", true);
    }

    @Test
    public void test_getImageDescriptor_wrongPath() throws Exception {
        this.test_getImageDescriptor("icons/3.png", false);
    }

    private void test_getImageDescriptor(String path, boolean checkNotNull) throws Exception {
        ActivatorImagesTest.setFileContentSrc("test/MyShell.java", this.getTestSource("public class MyShell extends Shell {", "  private ImageDescriptor m_imageDescriptor;", "  public void setID(ImageDescriptor id) {", "    m_imageDescriptor = id;", "  }", "}"));
        ActivatorImagesTest.waitForAutoBuild();
        ShellInfo shell = (ShellInfo)this.parseComposite("public class Test extends MyShell {", "  public Test() {", "    setID(testplugin.Activator.getImageDescriptor('" + path + "'));", "  }", "}");
        shell.refresh();
        Shell shellObject = shell.getWidget();
        Object imageDescriptor = ReflectionUtils.getFieldObject((Object)shellObject, (String)"m_imageDescriptor");
        if (checkNotNull) {
            ActivatorImagesTest.assertNotNull((Object)imageDescriptor);
        } else {
            ActivatorImagesTest.assertNull((Object)imageDescriptor);
        }
    }
}

