/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.rcp;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyEditor;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.rcp.model.rcp.ExtensionElementProperty;
import org.eclipse.wb.internal.rcp.model.rcp.PdeUtils;
import org.eclipse.wb.tests.designer.rcp.model.rcp.AbstractPdeTest;
import org.junit.jupiter.api.Test;

public class ExtensionElementPropertyTest
extends AbstractPdeTest {
    @Test
    public void test_existingProperty() throws Exception {
        ExtensionElementPropertyTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' value='some value' class='C_1'/>", "  </extension>", "</plugin>");
        final int[] setValueCount = new int[1];
        RunnableEx setValueListener = new RunnableEx(){

            public void run() throws Exception {
                setValueCount[0] = setValueCount[0] + 1;
            }
        };
        ExtensionElementProperty property = new ExtensionElementProperty(setValueListener, StringPropertyEditor.INSTANCE, "title", m_project, "org.eclipse.ui.views", "view", "C_1", "value", ExtensionElementProperty.IDENTITY, ExtensionElementProperty.IDENTITY, Property.UNKNOWN_VALUE);
        ExtensionElementPropertyTest.assertEquals((Object)"title", (Object)property.getTitle());
        ExtensionElementPropertyTest.assertSame((Object)m_project, (Object)property.getProject());
        ExtensionElementPropertyTest.assertTrue((boolean)property.hasElement());
        PdeUtils utils = property.getUtils();
        ExtensionElementPropertyTest.assertNotNull((Object)utils);
        ExtensionElementPropertyTest.assertNotNull((Object)utils.getExtensionElementById("org.eclipse.ui.views", "view", "id_1"));
        ExtensionElementPropertyTest.assertTrue((boolean)property.isModified());
        ExtensionElementPropertyTest.assertEquals((Object)"some value", (Object)property.getValue());
        ExtensionElementPropertyTest.assertEquals((int)0, (int)setValueCount[0]);
        property.setValue((Object)"some value");
        ExtensionElementPropertyTest.assertEquals((int)0, (int)setValueCount[0]);
        property.setValue((Object)"new value");
        ExtensionElementPropertyTest.assertEquals((int)1, (int)setValueCount[0]);
        ExtensionElementPropertyTest.assertPluginXML(new String[]{"<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' value='new value' class='C_1'/>", "  </extension>", "</plugin>"});
    }

    @Test
    public void test_noValue_setNew() throws Exception {
        ExtensionElementPropertyTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' class='C_1'/>", "  </extension>", "</plugin>");
        ExtensionElementProperty<String> property = this.createPropertyWithDefaults();
        ExtensionElementPropertyTest.assertTrue((boolean)property.hasElement());
        ExtensionElementPropertyTest.assertFalse((boolean)property.isModified());
        ExtensionElementPropertyTest.assertEquals((Object)"defaultValue", (Object)property.getValue());
        property.setValue((Object)"new value");
        ExtensionElementPropertyTest.assertTrue((boolean)property.isModified());
        ExtensionElementPropertyTest.assertEquals((Object)"new value", (Object)property.getValue());
        property.setValue(Property.UNKNOWN_VALUE);
        ExtensionElementPropertyTest.assertFalse((boolean)property.isModified());
        ExtensionElementPropertyTest.assertEquals((Object)"defaultValue", (Object)property.getValue());
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)ExtensionElementPropertyTest.getPluginXML()).contains(new CharSequence[]{"id=\"id_1\""})).contains(new CharSequence[]{"class=\"C_1\""})).doesNotContain(new CharSequence[]{"value="});
    }

    @Test
    public void test_remoteAttribute_whenSetDefaultValue() throws Exception {
        ExtensionElementPropertyTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' class='C_1' value='some value'/>", "  </extension>", "</plugin>");
        ExtensionElementProperty<String> property = this.createPropertyWithDefaults();
        ExtensionElementPropertyTest.assertTrue((boolean)property.hasElement());
        ExtensionElementPropertyTest.assertTrue((boolean)property.isModified());
        ExtensionElementPropertyTest.assertEquals((Object)"some value", (Object)property.getValue());
        property.setValue((Object)"defaultValue");
        ExtensionElementPropertyTest.assertFalse((boolean)property.isModified());
        ExtensionElementPropertyTest.assertEquals((Object)"defaultValue", (Object)property.getValue());
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)ExtensionElementPropertyTest.getPluginXML()).contains(new CharSequence[]{"id=\"id_1\""})).contains(new CharSequence[]{"class=\"C_1\""})).doesNotContain(new CharSequence[]{"value="});
    }

    private ExtensionElementProperty<String> createPropertyWithDefaults() {
        return new ExtensionElementProperty(null, StringPropertyEditor.INSTANCE, "title", m_project, "org.eclipse.ui.views", "view", "C_1", "value", ExtensionElementProperty.IDENTITY, ExtensionElementProperty.IDENTITY, (Object)"defaultValue");
    }

    @Test
    public void test_booleanValue() throws Exception {
        ExtensionElementPropertyTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' class='C_1' value='false'/>", "  </extension>", "</plugin>");
        ExtensionElementProperty property = new ExtensionElementProperty(null, StringPropertyEditor.INSTANCE, "title", m_project, "org.eclipse.ui.views", "view", "C_1", "value", ExtensionElementProperty.FROM_BOOLEAN, ExtensionElementProperty.TO_BOOLEAN, (Object)Boolean.FALSE);
        ExtensionElementPropertyTest.assertTrue((boolean)property.hasElement());
        ExtensionElementPropertyTest.assertFalse((boolean)property.isModified());
        ExtensionElementPropertyTest.assertEquals((Object)Boolean.FALSE, (Object)property.getValue());
        property.setValue((Object)Boolean.TRUE);
        ExtensionElementPropertyTest.assertTrue((boolean)property.isModified());
        ExtensionElementPropertyTest.assertEquals((Object)Boolean.TRUE, (Object)property.getValue());
    }
}

