/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.util.Lists;
import org.eclipse.wb.internal.core.model.property.editor.InstanceListPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.tests.designer.core.model.property.editor.AbstractTextPropertyEditorTest;
import org.junit.jupiter.api.Test;

public class InstanceListPropertyEditorTest
extends AbstractTextPropertyEditorTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_configure_valid() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        InstanceListPropertyEditor editor = this.createEditor(InstanceListPropertyEditor.class, parameters);
        this.assertEditorConfiguration(editor, parameters);
    }

    @Test
    public void test_configure_check() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        parameters.put("titles", Lists.newArrayList((Object[])new String[]{"STR", "INT"}));
        try {
            this.createEditor(InstanceListPropertyEditor.class, parameters);
            InstanceListPropertyEditorTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_configure_parameters() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        parameters.remove("types");
        try {
            this.createEditor(InstanceListPropertyEditor.class, parameters);
            InstanceListPropertyEditorTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_getValueSource() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        InstanceListPropertyEditor editor = this.createEditor(InstanceListPropertyEditor.class, parameters);
        InstanceListPropertyEditorTest.assertEquals((Object)"new java.lang.String()", (Object)editor.getValueSource((Object)new String()));
    }

    @Test
    public void test_getClipboardSource() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        InstanceListPropertyEditor editor = this.createEditor(InstanceListPropertyEditor.class, parameters);
        InstanceListPropertyEditorTest.assert_getClipboardSource("new java.lang.Integer()", (TextDisplayPropertyEditor)editor, 3);
        InstanceListPropertyEditorTest.assert_getClipboardSource(null, (TextDisplayPropertyEditor)editor, true);
    }

    @Test
    public void test_getText() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        InstanceListPropertyEditor editor = this.createEditor(InstanceListPropertyEditor.class, parameters);
        InstanceListPropertyEditorTest.assert_getText("String", (TextDisplayPropertyEditor)editor, new String("String"));
        InstanceListPropertyEditorTest.assert_getText("null", (TextDisplayPropertyEditor)editor, null);
    }

    private Map<String, Object> getEditorParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("types", Lists.newArrayList((Object[])new String[]{"java.lang.String", "java.lang.Integer", "null"}));
        return params;
    }

    private void assertEditorConfiguration(InstanceListPropertyEditor editor, Map<String, Object> parameters) throws Exception {
        InstanceListPropertyEditorTest.assertContainsOnly(editor, "m_types", (List)parameters.get("types"));
        InstanceListPropertyEditorTest.assertEquals((int)((Object[])InstanceListPropertyEditorTest.getFieldValue(editor, "m_classes")).length, (int)3);
    }
}

