/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.geometry;

import org.eclipse.swt.graphics.Point;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.geometry.AbstractGeometryDialog;
import org.eclipse.wb.internal.swt.model.ModelMessages;

public final class PointPropertyEditor
extends TextDialogPropertyEditor {
    public static final PropertyEditor INSTANCE = new PointPropertyEditor();

    private PointPropertyEditor() {
    }

    protected String getText(Property property) throws Exception {
        Object object = property.getValue();
        if (object instanceof Point) {
            Point point = (Point)object;
            return "(%d, %d)".formatted(point.x, point.y);
        }
        return null;
    }

    protected void openDialog(Property property) throws Exception {
        Point point;
        Object object = property.getValue();
        if (object instanceof Point) {
            Point oldPoint = (Point)object;
            point = new Point(oldPoint.x, oldPoint.y);
        } else {
            point = new Point(0, 0);
        }
        PointDialog pointDialog = new PointDialog(property.getTitle(), point);
        int result = pointDialog.open();
        if (result == 9) {
            property.setValue(Property.UNKNOWN_VALUE);
        } else if (result == 0) {
            property.setValue((Object)point);
        }
    }

    private static final class PointDialog
    extends AbstractGeometryDialog {
        public PointDialog(String title, Object point) {
            super(title, point);
        }

        protected void createEditors() {
            this.createEditor(ModelMessages.PointPropertyEditor_xLabel, "x");
            this.createEditor(ModelMessages.PointPropertyEditor_yLabel, "y");
        }
    }
}

