/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms;

import org.eclipse.wb.internal.rcp.model.forms.ExpandableCompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.model.forms.AbstractFormsTest;
import org.junit.jupiter.api.Test;

public class ExpandableCompositeTest
extends AbstractFormsTest {
    @Test
    public void test_properties() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ExpandableComposite composite = new ExpandableComposite(this, SWT.BORDER, ExpandableComposite.TREE_NODE);", "  }", "}");
        shell.refresh();
        ExpandableCompositeInfo composite = (ExpandableCompositeInfo)shell.getChildrenControls().get(0);
        ExpandableCompositeTest.assertNotNull((Object)composite.getPropertyByTitle("Style"));
        ExpandableCompositeTest.assertNotNull((Object)composite.getPropertyByTitle("ExpansionStyle"));
    }

    @Test
    public void test_CREATE_setTextClient() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ExpandableComposite composite = new ExpandableComposite(this, SWT.BORDER);", "  }", "}");
        shell.refresh();
        ExpandableCompositeInfo composite = (ExpandableCompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = BTestUtils.createButton();
        composite.command_CREATE(button, "setTextClient");
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ExpandableComposite composite = new ExpandableComposite(this, SWT.BORDER);", "    {", "      Button button = new Button(composite, SWT.NONE);", "      composite.setTextClient(button);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_setClient() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ExpandableComposite composite = new ExpandableComposite(this, SWT.BORDER);", "  }", "}");
        shell.refresh();
        ExpandableCompositeInfo composite = (ExpandableCompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = BTestUtils.createButton();
        composite.command_CREATE(button, "setClient");
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ExpandableComposite composite = new ExpandableComposite(this, SWT.BORDER);", "    composite.setExpanded(true);", "    {", "      Button button = new Button(composite, SWT.NONE);", "      composite.setClient(button);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_setClient() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ExpandableComposite composite = new ExpandableComposite(this, SWT.BORDER);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ExpandableCompositeInfo composite = (ExpandableCompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        composite.command_MOVE(button, "setClient");
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ExpandableComposite composite = new ExpandableComposite(this, SWT.BORDER);", "    composite.setExpanded(true);", "    {", "      Button button = new Button(composite, SWT.NONE);", "      composite.setClient(button);", "    }", "  }", "}");
    }
}

