/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.contentassist;

import org.eclipse.json.schema.IJSONSchemaProperty;
import org.eclipse.json.schema.JSONSchemaType;
import org.eclipse.wst.json.core.document.IJSONNode;

public class ContentAssistHelper {
    public static String getRequiredName(IJSONNode parent, IJSONSchemaProperty property) {
        String defaultValue = null;
        if (property.getDefaultValue() != null) {
            defaultValue = property.getDefaultValue();
        } else if (property.getEnumList() != null && property.getEnumList().size() > 0) {
            defaultValue = (String)property.getEnumList().get(0);
        }
        return ContentAssistHelper.getRequiredName(property.getName(), property.getFirstType(), defaultValue);
    }

    public static String getRequiredName(String propertyName, JSONSchemaType type, String defaultValue) {
        StringBuilder name = new StringBuilder("\"");
        name.append(propertyName);
        name.append("\"");
        if (type != null) {
            name.append(":");
            if (defaultValue != null) {
                if (type == JSONSchemaType.String) {
                    name.append("\"");
                    name.append(defaultValue);
                    name.append("\"");
                } else {
                    name.append(defaultValue);
                }
            } else {
                switch (type) {
                    case Array: {
                        name.append("[");
                        name.append("]");
                        break;
                    }
                    case Boolean: {
                        name.append("false");
                        break;
                    }
                    case Null: {
                        name.append("null");
                        break;
                    }
                    case Object: {
                        name.append("{");
                        name.append("}");
                        break;
                    }
                    case String: {
                        name.append("\"\"");
                        break;
                    }
                }
            }
        }
        return name.toString();
    }

    public static String getRequiredName(String propertyName, JSONSchemaType type) {
        return ContentAssistHelper.getRequiredName(propertyName, type, null);
    }
}

