/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.util.regex.Pattern;
import org.json.simple.JSONValue;

public class WipExpressionBuilder {
    static final Pattern ALL_DIGITS = Pattern.compile("\\d+");

    static ValueNameBuilder createValueOfPropertyNameBuilder(final String propertyName, final PropertyNameBuilder propertyNameBuilder) {
        final QualifiedNameBuilder qualifiedNameBuilder = propertyNameBuilder == null ? null : new QualifiedNameBuilder(){

            @Override
            public boolean needsParentheses() {
                return propertyNameBuilder.needsParentheses();
            }

            @Override
            public void append(StringBuilder output) {
                propertyNameBuilder.build(propertyName, output);
            }
        };
        return new ValueNameBuilder(){

            @Override
            public String getShortName() {
                return propertyName;
            }

            @Override
            public QualifiedNameBuilder getQualifiedNameBuilder() {
                return qualifiedNameBuilder;
            }
        };
    }

    static ValueNameBuilder createRootName(final String name, final boolean needsParentheses) {
        final QualifiedNameBuilder qualifiedNameBuilder = new QualifiedNameBuilder(){

            @Override
            public void append(StringBuilder output) {
                output.append(name);
            }

            @Override
            public boolean needsParentheses() {
                return needsParentheses;
            }
        };
        return new ValueNameBuilder(){

            @Override
            public String getShortName() {
                return name;
            }

            @Override
            public QualifiedNameBuilder getQualifiedNameBuilder() {
                return qualifiedNameBuilder;
            }
        };
    }

    public static ValueNameBuilder createRootNameNoDerived(final String name) {
        return new ValueNameBuilder(){

            @Override
            public String getShortName() {
                return name;
            }

            @Override
            public QualifiedNameBuilder getQualifiedNameBuilder() {
                return null;
            }
        };
    }

    static class ObjectPropertyNameBuilder
    implements PropertyNameBuilder {
        private final QualifiedNameBuilder objectNameBuilder;

        ObjectPropertyNameBuilder(QualifiedNameBuilder objectNameBuilder) {
            this.objectNameBuilder = objectNameBuilder;
        }

        @Override
        public void build(String name, StringBuilder output) {
            this.buildParentRef(output);
            if (ALL_DIGITS.matcher(name).matches()) {
                output.append("[").append(name).append("]");
            } else {
                boolean isNameSimple;
                boolean bl = isNameSimple = name.indexOf(32) != -1;
                if (isNameSimple) {
                    output.append(".").append(name);
                } else {
                    output.append("[\"").append(JSONValue.escape((String)name)).append("\"]");
                }
            }
        }

        private void buildParentRef(StringBuilder output) {
            if (this.objectNameBuilder.needsParentheses()) {
                output.append('(');
                this.objectNameBuilder.append(output);
                output.append(')');
            } else {
                this.objectNameBuilder.append(output);
            }
        }

        @Override
        public boolean needsParentheses() {
            return false;
        }
    }

    static interface PropertyNameBuilder {
        public void build(String var1, StringBuilder var2);

        public boolean needsParentheses();
    }

    public static interface QualifiedNameBuilder {
        public void append(StringBuilder var1);

        public boolean needsParentheses();
    }

    public static interface ValueNameBuilder {
        public String getShortName();

        public QualifiedNameBuilder getQualifiedNameBuilder();
    }
}

