/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.text;

import java.io.IOException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jst.jsp.ui.internal.text.JavaCodeReader;

class JavaPairMatcher
implements ICharacterPairMatcher {
    protected char[] fPairs;
    protected IDocument fDocument;
    protected int fOffset;
    protected int fStartPos;
    protected int fEndPos;
    protected int fAnchor;
    protected JavaCodeReader fReader = new JavaCodeReader();

    public JavaPairMatcher(char[] pairs) {
        this.fPairs = pairs;
    }

    public IRegion match(IDocument document, int offset) {
        this.fOffset = offset;
        if (this.fOffset < 0) {
            return null;
        }
        this.fDocument = document;
        if (this.fDocument != null && this.matchPairsAt() && this.fStartPos != this.fEndPos) {
            return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
        }
        return null;
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void dispose() {
        this.clear();
        this.fDocument = null;
        this.fReader = null;
    }

    public void clear() {
        if (this.fReader != null) {
            try {
                this.fReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean matchPairsAt() {
        int pairIndex1 = this.fPairs.length;
        int pairIndex2 = this.fPairs.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            char prevChar = this.fDocument.getChar(Math.max(this.fOffset - 1, 0));
            int i = 0;
            while (i < this.fPairs.length) {
                if (prevChar == this.fPairs[i]) {
                    this.fStartPos = this.fOffset - 1;
                    pairIndex1 = i;
                }
                i += 2;
            }
            i = 1;
            while (i < this.fPairs.length) {
                if (prevChar == this.fPairs[i]) {
                    this.fEndPos = this.fOffset - 1;
                    pairIndex2 = i;
                }
                i += 2;
            }
            if (this.fEndPos == -1 && this.fStartPos == -1) {
                char nextChar = this.fDocument.getChar(Math.max(this.fOffset, 0));
                i = 0;
                while (i < this.fPairs.length) {
                    if (nextChar == this.fPairs[i]) {
                        this.fStartPos = this.fOffset;
                        pairIndex1 = i;
                    }
                    i += 2;
                }
                i = 1;
                while (i < this.fPairs.length) {
                    if (nextChar == this.fPairs[i]) {
                        this.fEndPos = this.fOffset;
                        pairIndex2 = i;
                    }
                    i += 2;
                }
            }
            if (this.fEndPos > -1) {
                this.fAnchor = 0;
                this.fStartPos = this.searchForOpeningPeer(this.fEndPos, this.fPairs[pairIndex2 - 1], this.fPairs[pairIndex2], this.fDocument);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
                return false;
            }
            if (this.fStartPos <= -1) return false;
            this.fAnchor = 1;
            this.fEndPos = this.searchForClosingPeer(this.fStartPos, this.fPairs[pairIndex1], this.fPairs[pairIndex1 + 1], this.fDocument);
            if (this.fEndPos > -1) {
                return true;
            }
            this.fStartPos = -1;
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        catch (IOException iOException) {}
        return false;
    }

    protected int searchForClosingPeer(int offset, int openingPeer, int closingPeer, IDocument document) throws IOException {
        this.fReader.configureForwardReader(document, offset + 1, document.getLength(), false, true);
        int stack = 1;
        int c = this.fReader.read();
        while (c != -1) {
            if (c == openingPeer && c != closingPeer) {
                ++stack;
            } else if (c == closingPeer) {
                --stack;
            }
            if (stack == 0) {
                return this.fReader.getOffset();
            }
            c = this.fReader.read();
        }
        return -1;
    }

    protected int searchForOpeningPeer(int offset, int openingPeer, int closingPeer, IDocument document) throws IOException {
        this.fReader.configureBackwardReader(document, offset, false, true);
        int stack = 1;
        int c = this.fReader.read();
        while (c != -1) {
            if (c == closingPeer && c != openingPeer) {
                ++stack;
            } else if (c == openingPeer) {
                --stack;
            }
            if (stack == 0) {
                return this.fReader.getOffset();
            }
            c = this.fReader.read();
        }
        return -1;
    }
}

