/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.common.util.tests;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.wst.jsdt.js.node.common.json.objects.PackageJson;
import org.eclipse.wst.jsdt.js.node.common.tests.utils.ResourceUtils;
import org.eclipse.wst.jsdt.js.node.common.util.JsonUtil;
import org.junit.Assert;
import org.junit.Test;

public class JsonUtilTest {
    public static final String RESOURCE_PACKAGE_JSON = "resources/package.json";
    public static final String RESOURCE_PACKAGE_JSON_TEST = "/package.json_test";
    public static final String NAME_ATTR = "name";
    public static final String EMAIL_ATTR = "email";
    public static final String FIRST_CONTRIBUTOR_NAME = "John Smith";
    public static final String FIRST_CONTRIBUTOR_EMAIL = "jsmith@gmail.com";
    public static final String SECOND_CONTRIBUTOR_NAME = "Chris Jones";
    public static final String SECOND_CONTRIBUTOR_EMAIL = "cjones@gmail.com";
    public static final String NAME_VALUE = "test name";
    public static final String AUTHOR_VALUE = "test author";
    public static final String DESCRIPTION_VALUE = "test description";
    public static final String LICENSE_VALUE = "test license";
    public static final String NAME_EXPECTED = "\"name\": \"test name\"";
    public static final String AUTHOR_EXPECTED = "\"author\": \"test author\"";
    public static final String FIRST_NAME_CONTRIBUTOR_EXPECTED = "\"name\": \"John Smith\"";
    public static final String FIRST_EMAIL_CONTRIBUTOR_EXPECTED = "\"email\": \"jsmith@gmail.com\"";
    public static final String SECOND_NAME_CONTRIBUTOR_EXPECTED = "\"name\": \"Chris Jones\"";
    public static final String SECOND_EMAIL_CONTRIBUTOR_EXPECTED = "\"email\": \"cjones@gmail.com\"";
    public static final String DESCRIPTION_EXPECTED = "\"description\": \"test description\"";
    public static final String LICENSE_EXPECTED = "\"license\": \"test license\"";
    public static final String PRIVATE_EXPECTED = "\"private\": true";

    @Test
    public void testReadJsonFromFileStringClassOfT() {
        try {
            File resourcePath = ResourceUtils.getResource(RESOURCE_PACKAGE_JSON);
            PackageJson packageJson = (PackageJson)JsonUtil.readJsonFromFile((String)resourcePath.getAbsolutePath(), PackageJson.class);
            Assert.assertTrue((String)"Package.json name attribute is wrong.", (boolean)packageJson.getName().equals(NAME_VALUE));
            Assert.assertTrue((String)"Package.json author attribute is wrong.", (boolean)packageJson.getAuthor().equals(AUTHOR_VALUE));
            Assert.assertTrue((String)"Package.json first contributor name is wrong.", (boolean)((String)((Map)packageJson.getContributors().get(0)).get(NAME_ATTR)).equals(FIRST_CONTRIBUTOR_NAME));
            Assert.assertTrue((String)"Package.json first contributor email is wrong.", (boolean)((String)((Map)packageJson.getContributors().get(0)).get(EMAIL_ATTR)).equals(FIRST_CONTRIBUTOR_EMAIL));
            Assert.assertTrue((String)"Package.json second contributor name is wrong.", (boolean)((String)((Map)packageJson.getContributors().get(1)).get(NAME_ATTR)).equals(SECOND_CONTRIBUTOR_NAME));
            Assert.assertTrue((String)"Package.json second contributor email is wrong.", (boolean)((String)((Map)packageJson.getContributors().get(1)).get(EMAIL_ATTR)).equals(SECOND_CONTRIBUTOR_EMAIL));
            Assert.assertTrue((String)"Package.json description attribute is wrong.", (boolean)packageJson.getDescription().equals(DESCRIPTION_VALUE));
            Assert.assertTrue((String)"Package.json license attribute is wrong.", (boolean)packageJson.getLicense().equals(LICENSE_VALUE));
            Assert.assertTrue((String)"Package.json private attribute is wrong.", (boolean)packageJson.getIsPrivate());
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not read file.");
        }
    }

    @Test
    public void testWriteJsonToFile() {
        File file = null;
        try {
            File resourcePath = ResourceUtils.getResource(RESOURCE_PACKAGE_JSON);
            file = new File(String.valueOf(resourcePath.getParent()) + RESOURCE_PACKAGE_JSON_TEST);
            PackageJson packageJson = (PackageJson)JsonUtil.readJsonFromFile((String)resourcePath.getAbsolutePath(), PackageJson.class);
            JsonUtil.writeJsonToFile((File)file, (Object)packageJson);
            Assert.assertTrue((String)"/package.json_testdoes not exists.", (boolean)file.exists());
            file.delete();
            Assert.assertTrue((String)"/package.json_testexists.", (!file.exists() ? 1 : 0) != 0);
            JsonUtil.writeJsonToFile((String)file.getAbsolutePath(), (Object)packageJson);
            Assert.assertTrue((String)"/package.json_testdoes not exists.", (boolean)file.exists());
            file.delete();
            Assert.assertTrue((String)"/package.json_testexists.", (!file.exists() ? 1 : 0) != 0);
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not read file.");
        }
    }

    @Test
    public void testConvertJavaObjectToJson() {
        try {
            File resourcePath = ResourceUtils.getResource(RESOURCE_PACKAGE_JSON);
            PackageJson packageJson = (PackageJson)JsonUtil.readJsonFromFile((String)resourcePath.getAbsolutePath(), PackageJson.class);
            String json = JsonUtil.convertJavaObjectToJson((Object)packageJson);
            Assert.assertTrue((String)"Package.json name attribute is wrong.", (boolean)json.contains(NAME_EXPECTED));
            Assert.assertTrue((String)"Package.json author attribute is wrong.", (boolean)json.contains(AUTHOR_EXPECTED));
            Assert.assertTrue((String)"Package.json first contributor name is wrong.", (boolean)json.contains(FIRST_NAME_CONTRIBUTOR_EXPECTED));
            Assert.assertTrue((String)"Package.json first contributor email is wrong.", (boolean)json.contains(FIRST_EMAIL_CONTRIBUTOR_EXPECTED));
            Assert.assertTrue((String)"Package.json second contributor name is wrong.", (boolean)json.contains(SECOND_NAME_CONTRIBUTOR_EXPECTED));
            Assert.assertTrue((String)"Package.json second contributor email is wrong.", (boolean)json.contains(SECOND_EMAIL_CONTRIBUTOR_EXPECTED));
            Assert.assertTrue((String)"Package.json description attribute is wrong.", (boolean)json.contains(DESCRIPTION_EXPECTED));
            Assert.assertTrue((String)"Package.json license attribute is wrong.", (boolean)json.contains(LICENSE_EXPECTED));
            Assert.assertTrue((String)"Package.json private attribute is wrong.", (boolean)json.contains(PRIVATE_EXPECTED));
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not read file.");
        }
    }

    @Test
    public void testConvertJsonToJavaObject() {
        try {
            File resourcePath = ResourceUtils.getResource(RESOURCE_PACKAGE_JSON);
            PackageJson packageJson = (PackageJson)JsonUtil.readJsonFromFile((String)resourcePath.getAbsolutePath(), PackageJson.class);
            String json = JsonUtil.convertJavaObjectToJson((Object)packageJson);
            packageJson = (PackageJson)JsonUtil.convertJsonToJavaObject((String)json, PackageJson.class);
            Assert.assertTrue((String)"Package.json name attribute is wrong.", (boolean)packageJson.getName().equals(NAME_VALUE));
            Assert.assertTrue((String)"Package.json author attribute is wrong.", (boolean)packageJson.getAuthor().equals(AUTHOR_VALUE));
            Assert.assertTrue((String)"Package.json first contributor name is wrong.", (boolean)((String)((Map)packageJson.getContributors().get(0)).get(NAME_ATTR)).equals(FIRST_CONTRIBUTOR_NAME));
            Assert.assertTrue((String)"Package.json first contributor email is wrong.", (boolean)((String)((Map)packageJson.getContributors().get(0)).get(EMAIL_ATTR)).equals(FIRST_CONTRIBUTOR_EMAIL));
            Assert.assertTrue((String)"Package.json second contributor name is wrong.", (boolean)((String)((Map)packageJson.getContributors().get(1)).get(NAME_ATTR)).equals(SECOND_CONTRIBUTOR_NAME));
            Assert.assertTrue((String)"Package.json second contributor email is wrong.", (boolean)((String)((Map)packageJson.getContributors().get(1)).get(EMAIL_ATTR)).equals(SECOND_CONTRIBUTOR_EMAIL));
            Assert.assertTrue((String)"Package.json description attribute is wrong.", (boolean)packageJson.getDescription().equals(DESCRIPTION_VALUE));
            Assert.assertTrue((String)"Package.json license attribute is wrong.", (boolean)packageJson.getLicense().equals(LICENSE_VALUE));
            Assert.assertTrue((String)"Package.json private attribute is wrong.", (boolean)packageJson.getIsPrivate());
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not read file.");
        }
    }
}

