/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.predicate.IsNotNull;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class IsIdenticalTests
extends TestCase {
    private Integer integer = 42;
    private Predicate<Integer> identityPredicate;

    public IsIdenticalTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.identityPredicate = PredicateTools.isIdentical((Object)this.integer);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testEvaluate() {
        IsIdenticalTests.assertTrue((boolean)this.identityPredicate.evaluate((Object)this.integer));
        IsIdenticalTests.assertFalse((boolean)this.identityPredicate.evaluate((Object)new Integer(42)));
        IsIdenticalTests.assertTrue((boolean)this.identityPredicate.evaluate((Object)42));
        IsIdenticalTests.assertFalse((boolean)this.identityPredicate.evaluate(null));
        IsIdenticalTests.assertFalse((boolean)this.identityPredicate.evaluate((Object)24));
    }

    public void testEquals() {
        Predicate identityPredicate2 = PredicateTools.isIdentical((Object)new Integer(42));
        IsIdenticalTests.assertEquals(this.identityPredicate, (Object)identityPredicate2);
        IsIdenticalTests.assertEquals((int)this.identityPredicate.hashCode(), (int)identityPredicate2.hashCode());
        IsIdenticalTests.assertFalse((boolean)this.identityPredicate.equals((Object)IsNotNull.instance()));
    }
}

