/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process.processes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngineHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class AppendCreate
extends ProcessRunner {
    @Override
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        ProcessArgument[][] files = args[1].getComplexArrayValue();
        int i = 0;
        while (i < files.length) {
            String fileContents;
            URL sourceURL;
            ProcessArgument[] file = files[i];
            String sourcePath = file[0].getSimpleValue();
            String targetPath = file[1].getSimpleValue();
            boolean replaceable = file[2].getSimpleValue().equals("true");
            try {
                sourceURL = TemplateEngineHelper.getTemplateResourceURLRelativeToTemplate(template, sourcePath);
                if (sourceURL == null) {
                    throw new ProcessFailureException(this.getProcessMessage(processId, 4, Messages.getString("AppendCreate.1") + sourcePath));
                }
            }
            catch (IOException e1) {
                throw new ProcessFailureException(Messages.getString("AppendCreate.2") + sourcePath);
            }
            try {
                fileContents = ProcessHelper.readFromFile(sourceURL);
            }
            catch (IOException e1) {
                throw new ProcessFailureException(Messages.getString("AppendCreate.3") + sourcePath);
            }
            if (replaceable) {
                fileContents = ProcessHelper.getValueAfterExpandingMacros(fileContents, ProcessHelper.getReplaceKeys(fileContents), template.getValueStore());
            }
            try {
                IFile iFile = projectHandle.getFile(targetPath);
                if (!iFile.getParent().exists()) {
                    ProcessHelper.mkdirs(projectHandle, projectHandle.getFolder(iFile.getParent().getProjectRelativePath()));
                }
                ByteArrayInputStream contents = new ByteArrayInputStream(fileContents.getBytes());
                if (!iFile.exists()) {
                    iFile.create((InputStream)contents, true, null);
                    iFile.refreshLocal(1, null);
                } else {
                    iFile.appendContents((InputStream)contents, true, true, null);
                }
                projectHandle.refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw new ProcessFailureException(Messages.getString("AppendCreate.4"), e);
            }
            ++i;
        }
    }
}

