/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects;

import com.google.common.base.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcessPointer;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.Ros2SerializationUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Gid;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2Object;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;

public abstract class Ros2PubSubObject
extends Ros2Object<Ros2ObjectHandle> {
    private final @NonNull Ros2ObjectHandle fRmwHandle;
    private final @NonNull String fTopicName;
    private final @NonNull Ros2ObjectHandle fNodeHandle;
    private final @NonNull Gid fGid;
    private final @NonNull HostProcessPointer fDdsHandle;

    protected Ros2PubSubObject(@NonNull Ros2ObjectHandle handle, @NonNull Ros2ObjectHandle rmwHandle, @NonNull String topicName, @NonNull Ros2ObjectHandle nodeHandle, @NonNull Gid gid, @NonNull HostProcessPointer ddsHandle) {
        super(handle);
        this.fRmwHandle = rmwHandle;
        this.fTopicName = topicName;
        this.fNodeHandle = nodeHandle;
        this.fGid = gid;
        this.fDdsHandle = ddsHandle;
    }

    public @NonNull Ros2ObjectHandle getRmwHandle() {
        return this.fRmwHandle;
    }

    public @NonNull String getTopicName() {
        return this.fTopicName;
    }

    public @NonNull Ros2ObjectHandle getNodeHandle() {
        return this.fNodeHandle;
    }

    public @NonNull Gid getGid() {
        return this.fGid;
    }

    public @NonNull HostProcessPointer getDdsHandle() {
        return this.fDdsHandle;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fRmwHandle, this.fTopicName, this.fNodeHandle, this.fGid, this.fDdsHandle, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Ros2PubSubObject o = (Ros2PubSubObject)((Object)obj);
        return o.fRmwHandle.equals((Object)this.fRmwHandle) && o.fTopicName.equals(this.fTopicName) && o.fNodeHandle.equals((Object)this.fNodeHandle) && o.fGid.equals(this.fGid) && o.fDdsHandle.equals((Object)this.fDdsHandle);
    }

    @Override
    public String toString() {
        return String.format("topicName=%s, %s, rmwHandle=[%s], nodeHandle=[%s], gid=%s, ddsHandle=[%s]", this.fTopicName, super.toString(), this.fRmwHandle.toString(), this.fNodeHandle.toString(), this.fGid.toString(), this.fDdsHandle.toString());
    }

    @Override
    protected void serializeValue(ISafeByteBufferWriter buffer) {
        super.serializeValue(buffer);
        this.fRmwHandle.serializeValue(buffer);
        buffer.putString(this.fTopicName);
        this.fNodeHandle.serializeValue(buffer);
        this.fGid.serialize(buffer);
        this.fDdsHandle.serializeValue(buffer);
    }

    @Override
    protected int getSerializedValueSize() {
        int size = 0;
        size += super.getSerializedValueSize();
        size += this.fRmwHandle.getSerializedValueSize();
        size += Ros2SerializationUtil.getStringSerializedSize(this.fTopicName);
        size += this.fNodeHandle.getSerializedValueSize();
        size += this.fGid.getSerializedValueSize();
        return size += this.fDdsHandle.getSerializedValueSize();
    }
}

