/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.SWTFontProvider;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.OS;

public final class Font
extends Resource {
    private long handle;
    int zoom;
    private boolean isDestroyed;
    private final FontData fontData;
    private final float fontHeight;

    private Font(Device device, long handle, int zoom) {
        super(device);
        this.fontData = null;
        this.handle = handle;
        this.zoom = zoom;
        this.fontHeight = device.computePoints(this.fetchLogFontData(), handle, zoom);
    }

    public Font(Device device, FontData fd) {
        super(device);
        if (fd == null) {
            SWT.error(4);
        }
        this.zoom = DPIUtil.getNativeDeviceZoom();
        this.fontData = new FontData(fd.toString());
        this.fontHeight = fd.height;
        this.init();
    }

    private Font(Device device, FontData fd, int zoom) {
        super(device);
        if (fd == null) {
            SWT.error(4);
        }
        this.zoom = zoom;
        this.fontData = new FontData(fd.toString());
        this.fontHeight = fd.height;
        this.init();
    }

    public Font(Device device, FontData[] fds) {
        super(device);
        FontData fd;
        if (fds == null) {
            SWT.error(4);
        }
        if (fds.length == 0) {
            SWT.error(5);
        }
        FontData[] fontDataArray = fds;
        int n = fds.length;
        int n2 = 0;
        while (n2 < n) {
            fd = fontDataArray[n2];
            if (fd == null) {
                SWT.error(5);
            }
            ++n2;
        }
        this.zoom = DPIUtil.getNativeDeviceZoom();
        fd = fds[0];
        this.fontData = new FontData(fd.toString());
        this.fontHeight = fd.height;
        this.init();
    }

    public Font(Device device, String name, int height, int style) {
        super(device);
        if (name == null) {
            SWT.error(4);
        }
        this.zoom = DPIUtil.getNativeDeviceZoom();
        this.fontData = new FontData(name, height, style);
        this.fontHeight = height;
        this.init();
    }

    @Override
    void destroy() {
        OS.DeleteObject(this.handle);
        this.handle = 0L;
        this.isDestroyed = true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.device == font.device && Font.win32_getHandle(this) == Font.win32_getHandle(font);
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        LOGFONT logFont = this.fetchLogFontData();
        return new FontData[]{FontData.win32_new(logFont, this.fontHeight)};
    }

    private LOGFONT fetchLogFontData() {
        LOGFONT logFont = new LOGFONT();
        OS.GetObject(Font.win32_getHandle(this), LOGFONT.sizeof, logFont);
        return logFont;
    }

    public int hashCode() {
        return (int)Font.win32_getHandle(this);
    }

    void init(FontData fd) {
        if (fd == null) {
            SWT.error(4);
        }
        LOGFONT logFont = fd.data;
        int lfHeight = logFont.lfHeight;
        logFont.lfHeight = this.device.computePixels(fd.height, this.zoom);
        this.handle = OS.CreateFontIndirect(logFont);
        logFont.lfHeight = lfHeight;
        if (this.handle == 0L) {
            SWT.error(2);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.isDestroyed;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }

    public static long win32_getHandle(Font font) {
        if (font.handle == 0L && font.fontData != null && !font.isDestroyed) {
            font.init(font.fontData);
        }
        return font.handle;
    }

    public static Font win32_new(Device device, long handle) {
        int zoom = DPIUtil.getNativeDeviceZoom();
        return Font.win32_new(device, handle, zoom);
    }

    public static Font win32_new(Device device, long handle, int zoom) {
        Font font = new Font(device, handle, zoom);
        font.ignoreNonDisposed();
        return font;
    }

    public static Font win32_new(Device device, FontData fontData, int zoom) {
        return new Font(device, fontData, zoom);
    }

    public static Font win32_new(Font font, int targetZoom) {
        if (targetZoom == font.zoom) {
            return font;
        }
        return SWTFontProvider.getFont(font.getDevice(), font.getFontData()[0], targetZoom);
    }
}

