/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.telnet.connector;

import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.terminal.connector.telnet.connector.ITelnetSettings;
import org.eclipse.tm.terminal.connector.telnet.connector.TelnetProperties;

public class TelnetSettings
implements ITelnetSettings {
    protected String fHost;
    protected String fNetworkPort;
    protected String fTimeout;
    protected String fEndOfLine = "CR+NUL";
    private final TelnetProperties fProperties = new TelnetProperties();

    @Override
    public String getHost() {
        return this.fHost;
    }

    public void setHost(String strHost) {
        this.fHost = strHost;
    }

    public String getNetworkPortString() {
        return this.fNetworkPort;
    }

    @Override
    public int getNetworkPort() {
        try {
            return Integer.parseInt(this.fNetworkPort);
        }
        catch (NumberFormatException numberFormatException) {
            return 1313;
        }
    }

    public void setNetworkPort(String strNetworkPort) {
        this.fNetworkPort = strNetworkPort;
    }

    @Override
    public String getSummary() {
        return this.getHost() + ":" + this.getNetworkPortString();
    }

    @Override
    public void load(ISettingsStore store) {
        this.fHost = store.get("Host", this.fProperties.getDefaultHost());
        this.fNetworkPort = store.get("NetworkPort", this.fProperties.getDefaultNetworkPort());
        this.fTimeout = store.get("Timeout", "10");
        this.fEndOfLine = store.get("EndOfLine", "CR+NUL");
    }

    @Override
    public void save(ISettingsStore store) {
        store.put("Host", this.fHost);
        store.put("NetworkPort", this.fNetworkPort);
        store.put("Timeout", this.fTimeout);
        store.put("EndOfLine", this.fEndOfLine);
    }

    public TelnetProperties getProperties() {
        return this.fProperties;
    }

    @Override
    public int getTimeout() {
        try {
            return Integer.parseInt(this.fTimeout);
        }
        catch (NumberFormatException numberFormatException) {
            return 10;
        }
    }

    public String getTimeoutString() {
        return this.fTimeout;
    }

    public void setTimeout(String timeout) {
        this.fTimeout = timeout;
    }

    public void setEndOfLine(String eol) {
        this.fEndOfLine = "CR+LF".equals(eol) ? "CR+LF" : "CR+NUL";
    }

    @Override
    public String getEndOfLine() {
        return this.fEndOfLine;
    }
}

