/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.util;

import com.microsoft.java.test.plugin.model.Option;
import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.provider.TestKindProvider;
import com.microsoft.java.test.plugin.util.JUnitPlugin;
import com.microsoft.java.test.plugin.util.ProjectTestUtils;
import com.microsoft.java.test.plugin.util.TestSearchUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.handlers.CodeGenerationUtils;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class TestGenerationUtils {
    private static final String JUNIT4_PREFIX = "org.junit";
    private static final String JUNIT5_PREFIX = "org.junit.jupiter";
    private static final String TESTNG_PREFIX = "org.testng";
    private static final String JUNIT4_LIFECYCLE_ANNOTATION_PREFIX = "org.junit.";
    private static final String JUNIT4_BEFORE_CLASS_ANNOTATION = "BeforeClass";
    private static final String JUNIT4_SET_UP_ANNOTATION = "Before";
    private static final String JUNIT4_TEAR_DOWN_ANNOTATION = "After";
    private static final String JUNIT4_AFTER_CLASS_ANNOTATION = "AfterClass";
    private static final String JUNIT5_LIFECYCLE_ANNOTATION_PREFIX = "org.junit.jupiter.api.";
    private static final String JUNIT5_BEFORE_CLASS_ANNOTATION = "BeforeAll";
    private static final String JUNIT5_SET_UP_ANNOTATION = "BeforeEach";
    private static final String JUNIT5_TEAR_DOWN_ANNOTATION = "AfterEach";
    private static final String JUNIT5_AFTER_CLASS_ANNOTATION = "AfterAll";
    private static final String TESTNG_LIFECYCLE_ANNOTATION_PREFIX = "org.testng.annotations.";
    private static final String TESTNG_BEFORE_CLASS_ANNOTATION = "BeforeClass";
    private static final String TESTNG_SET_UP_ANNOTATION = "BeforeMethod";
    private static final String TESTNG_TEAR_DOWN_ANNOTATION = "AfterMethod";
    private static final String TESTNG_AFTER_CLASS_ANNOTATION = "AfterClass";

    public static WorkspaceEdit generateTests(List<Object> arguments, IProgressMonitor monitor) throws MalformedTreeException, CoreException {
        if (arguments == null || arguments.size() < 2) {
            throw new IllegalArgumentException("Wrong arguments passed to generate tests");
        }
        String uri = (String)arguments.get(0);
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit((String)uri);
        if (unit == null) {
            JUnitPlugin.logError("Failed to parse compilation unit from " + uri);
            return null;
        }
        CompilationUnit root = (CompilationUnit)TestSearchUtils.parseToAst(unit, true, monitor);
        int cursorOffset = ((Double)arguments.get(1)).intValue();
        NodeFinder nodeFinder = new NodeFinder((ASTNode)root, cursorOffset, 0);
        ASTNode coveringNode = nodeFinder.getCoveringNode();
        while (coveringNode != null) {
            if (coveringNode instanceof AbstractTypeDeclaration) break;
            coveringNode = coveringNode.getParent();
        }
        if (coveringNode == null) {
            IType primaryType = unit.findPrimaryType();
            if (primaryType == null) {
                return null;
            }
            coveringNode = root.findDeclaringNode(primaryType.getKey());
        }
        if (!(coveringNode instanceof AbstractTypeDeclaration)) {
            JUnitPlugin.logError("Failed to find type declaration from " + unit.getElementName());
            return null;
        }
        ITypeBinding binding = ((AbstractTypeDeclaration)coveringNode).resolveBinding();
        if (binding == null) {
            JUnitPlugin.logError("Failed to resolve type binding from " + unit.getElementName());
            return null;
        }
        if (!(binding.isClass() || binding.isInterface() || binding.isRecord() || binding.isEnum())) {
            JavaLanguageServerPlugin.getInstance().getClientConnection().showNotificationMessage(MessageType.Error, "Cannot generate tests if it's not a Java class/interface/record/enum.");
            return null;
        }
        IJavaProject javaProject = unit.getJavaProject();
        if (javaProject == null) {
            JUnitPlugin.logError("Cannot get Java project from " + unit.getElementName());
            return null;
        }
        IClasspathEntry[] iClasspathEntryArray = javaProject.readRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getPath().isPrefixOf(unit.getPath())) {
                if (ProjectTestUtils.isTestEntry(entry)) {
                    return TestGenerationUtils.generateTestsFromTest(unit, root, (TypeDeclaration)coveringNode, binding, cursorOffset);
                }
                return TestGenerationUtils.generateTestsFromSource(unit, binding, cursorOffset);
            }
            ++n2;
        }
        return null;
    }

    private static WorkspaceEdit generateTestsFromSource(ICompilationUnit unit, ITypeBinding typeBinding, int cursorOffset) throws CoreException {
        IJavaProject javaProject = TestGenerationUtils.determineTestProject(unit);
        if (javaProject == null) {
            return null;
        }
        List<TestKind> testFrameworksInProject = TestKindProvider.getTestKindsFromCache(javaProject);
        TestKind testKind = TestGenerationUtils.determineTestFramework(new HashSet<TestKind>(testFrameworksInProject));
        if (testKind == null) {
            return null;
        }
        IClasspathEntry testEntry = TestGenerationUtils.getTestClasspathEntry(javaProject, unit);
        if (testEntry == null) {
            JavaLanguageServerPlugin.getInstance().getClientConnection().showNotificationMessage(MessageType.Error, "Cannot find a valid classpath entry to generate tests.");
            return null;
        }
        String testFullyQualifiedName = TestGenerationUtils.getTestFullyQualifiedName(typeBinding, javaProject, testEntry);
        if (testFullyQualifiedName == null) {
            return null;
        }
        List<String> methodsToTest = TestGenerationUtils.getMethodsToTest(typeBinding);
        if (methodsToTest == null) {
            return null;
        }
        ICompilationUnit testUnit = TestGenerationUtils.getTestCompilationUnit(javaProject, testEntry, testFullyQualifiedName);
        return TestGenerationUtils.scaffoldTestFile(testKind, testUnit, methodsToTest, cursorOffset);
    }

    private static WorkspaceEdit scaffoldTestFile(TestKind kind, ICompilationUnit testUnit, List<String> methodsToTest, int cursorPosition) throws CoreException {
        if (testUnit.exists()) {
            ASTNode typeNode;
            IType[] types = testUnit.getAllTypes();
            if (types.length == 0) {
                return TestGenerationUtils.addTestClassToExistingFile(kind, testUnit, methodsToTest);
            }
            CompilationUnit root = (CompilationUnit)TestSearchUtils.parseToAst(testUnit, false, (IProgressMonitor)new NullProgressMonitor());
            if (root == null) {
                return null;
            }
            IType type = testUnit.findPrimaryType();
            if (type == null) {
                type = types[0];
            }
            if (!((typeNode = root.findDeclaringNode(type.getKey())) instanceof TypeDeclaration)) {
                return null;
            }
            ITypeBinding binding = ((TypeDeclaration)typeNode).resolveBinding();
            if (binding == null) {
                return null;
            }
            IJavaElement insertPosition = null;
            try {
                insertPosition = CodeGenerationUtils.findInsertElement((IType)type, (int)cursorPosition);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return TestGenerationUtils.addTestMethodsToExistingTestClass(root, kind, methodsToTest, (TypeDeclaration)typeNode, binding, insertPosition);
        }
        return TestGenerationUtils.createNewTestClass(kind, testUnit, methodsToTest);
    }

    private static WorkspaceEdit addTestClassToExistingFile(TestKind kind, ICompilationUnit testUnit, List<String> methodsToTest) throws CoreException {
        CompilationUnitChange cuChange = new CompilationUnitChange("", testUnit);
        String cuContent = TestGenerationUtils.constructNewCU(testUnit, methodsToTest, kind);
        cuChange.setEdit((TextEdit)new InsertEdit(0, cuContent));
        return ChangeUtil.convertToWorkspaceEdit((Change)cuChange);
    }

    private static WorkspaceEdit createNewTestClass(TestKind kind, ICompilationUnit testUnit, List<String> methodsToTest) throws CoreException {
        String cuContent = TestGenerationUtils.constructNewCU(testUnit, methodsToTest, kind);
        CreateCompilationUnitChange change = new CreateCompilationUnitChange(testUnit, cuContent, "");
        return ChangeUtil.convertToWorkspaceEdit((Change)change);
    }

    private static WorkspaceEdit addTestMethodsToExistingTestClass(CompilationUnit testRoot, TestKind kind, List<String> methodsToTest, TypeDeclaration typeNode, ITypeBinding typeBinding, IJavaElement insertPosition) throws JavaModelException, CoreException {
        String testAnnotation = TestGenerationUtils.getTestAnnotation(kind);
        List<MethodMetaData> metadata = methodsToTest.stream().map(method -> {
            String methodName = TestGenerationUtils.getTestMethodName(method);
            return new MethodMetaData(methodName, testAnnotation);
        }).collect(Collectors.toList());
        TextEdit edit = TestGenerationUtils.getTextEdit(kind, metadata, testRoot, typeNode, typeBinding, insertPosition, false);
        return SourceAssistProcessor.convertToWorkspaceEdit((ICompilationUnit)((ICompilationUnit)testRoot.getJavaElement()), (TextEdit)edit);
    }

    private static String constructNewCU(ICompilationUnit testUnit, List<String> methods, TestKind testKind) throws CoreException {
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)testUnit);
        String typeStub = TestGenerationUtils.constructTypeStub(testUnit, methods, testKind, delimiter);
        String cuContent = TestGenerationUtils.constructCUContent(testUnit, methods.size() > 0, testKind, typeStub, delimiter);
        String formattedCuStub = CodeFormatterUtil.format((int)8, (String)cuContent, (int)0, (String)delimiter, (Map)testUnit.getJavaProject().getOptions(true));
        return formattedCuStub;
    }

    private static String constructCUContent(ICompilationUnit testUnit, boolean hasMethods, TestKind testKind, String typeContent, String lineDelimiter) throws CoreException {
        IPackageFragment packageFragment = (IPackageFragment)testUnit.getParent();
        StringBuilder buf = new StringBuilder();
        if (!packageFragment.isDefaultPackage()) {
            buf.append("package ").append(packageFragment.getElementName()).append(";").append(lineDelimiter).append(lineDelimiter);
        }
        if (hasMethods) {
            buf.append("import ").append(TestGenerationUtils.getTestAnnotation(testKind)).append(";").append(lineDelimiter).append(lineDelimiter);
        }
        buf.append(typeContent);
        return buf.toString();
    }

    private static String constructTypeStub(ICompilationUnit testUnit, List<String> methods, TestKind testKind, String lineDelimiter) throws CoreException {
        String typeName = testUnit.getElementName().replace(".java", "");
        StringBuilder buf = new StringBuilder();
        buf.append("public class ").append(typeName).append(" {").append(lineDelimiter);
        HashSet<String> addedMethods = new HashSet<String>();
        for (String method : methods) {
            buf.append(TestGenerationUtils.constructMethodStub(testUnit, testKind, addedMethods, method, lineDelimiter)).append(lineDelimiter);
        }
        buf.append("}").append(lineDelimiter);
        return buf.toString();
    }

    private static String constructMethodStub(ICompilationUnit testUnit, TestKind testKind, Set<String> addedMethods, String method, String lineDelimiter) {
        StringBuilder buf = new StringBuilder();
        buf.append("@Test").append(lineDelimiter);
        if (testKind == TestKind.JUnit) {
            buf.append("public ");
        }
        String methodName = TestGenerationUtils.getUniqueMethodName(null, Collections.emptyMap(), addedMethods, TestGenerationUtils.getTestMethodName(method), false);
        addedMethods.add(methodName);
        buf.append("void ").append(methodName).append("() {").append(lineDelimiter).append(lineDelimiter).append("}");
        String methodContent = buf.toString();
        return CodeFormatterUtil.format((int)2, (String)methodContent, (int)1, (String)lineDelimiter, (Map)testUnit.getJavaProject().getOptions(true));
    }

    private static IClasspathEntry getTestClasspathEntry(IJavaProject javaProject, ICompilationUnit unit) throws JavaModelException {
        IClasspathEntry[] entries;
        IClasspathEntry testEntry = javaProject.getClasspathEntryFor(javaProject.getPath().append("src/test/java"));
        if (testEntry != null && ProjectTestUtils.isTestEntry(testEntry)) {
            return testEntry;
        }
        IClasspathEntry[] iClasspathEntryArray = entries = javaProject.readRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (ProjectTestUtils.isTestEntry(entry)) {
                return entry;
            }
            if (entry.getPath().isPrefixOf(unit.getPath())) {
                testEntry = entry;
            }
            ++n2;
        }
        return testEntry;
    }

    private static String getTestFullyQualifiedName(ITypeBinding typeBinding, IJavaProject project, IClasspathEntry testEntry) throws JavaModelException {
        String promptName = TestGenerationUtils.getDefaultTestFullyQualifiedName(typeBinding, project, testEntry);
        String fullyQualifiedName = (String)JUnitPlugin.askClientForInput("Please type the target test class name", promptName);
        if (fullyQualifiedName == null) {
            return null;
        }
        IStatus status = JavaConventions.validateJavaTypeName((String)fullyQualifiedName, (String)project.getOption("org.eclipse.jdt.core.compiler.source", true), (String)project.getOption("org.eclipse.jdt.core.compiler.compliance", true), (String)project.getOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", true));
        int severity = status.getSeverity();
        if (severity == 0 || severity == 2) {
            return fullyQualifiedName;
        }
        JavaLanguageServerPlugin.getInstance().getClientConnection().showNotificationMessage(MessageType.Error, status.getMessage());
        return null;
    }

    private static String getDefaultTestFullyQualifiedName(ITypeBinding typeBinding, IJavaProject project, IClasspathEntry testEntry) throws JavaModelException {
        String defaultName = TestGenerationUtils.getClassName(typeBinding) + "Test";
        String attemptName = TestGenerationUtils.getClassName(typeBinding) + "Tests";
        try {
            ICompilationUnit[] compilationUnits;
            ICompilationUnit testCompilationUnit = TestGenerationUtils.getTestCompilationUnit(project, testEntry, attemptName);
            if (testCompilationUnit.exists()) {
                return attemptName;
            }
            testCompilationUnit = TestGenerationUtils.getTestCompilationUnit(project, testEntry, defaultName);
            if (testCompilationUnit.exists()) {
                return defaultName;
            }
            IPackageFragment packageFragment = (IPackageFragment)testCompilationUnit.getParent();
            int counter = 0;
            ICompilationUnit[] iCompilationUnitArray = compilationUnits = packageFragment.getCompilationUnits();
            int n = compilationUnits.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit unit = iCompilationUnitArray[n2];
                String name = unit.getElementName();
                if (name.endsWith("Tests.java")) {
                    ++counter;
                } else if (name.endsWith("Test.java")) {
                    --counter;
                }
                ++n2;
            }
            if (counter > 0) {
                return attemptName;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return defaultName;
    }

    private static String getClassName(ITypeBinding typeBinding) {
        String binaryName = typeBinding.getBinaryName();
        String packageName = typeBinding.getPackage().getName();
        if (packageName.isEmpty()) {
            return binaryName.replace("$", "_");
        }
        String typeName = binaryName.substring(packageName.length() + 1);
        return packageName + "." + typeName.replace("$", "_");
    }

    private static ICompilationUnit getTestCompilationUnit(IJavaProject javaProject, IClasspathEntry testEntry, String testFullyQualifiedName) throws JavaModelException {
        IPackageFragmentRoot packageRoot = javaProject.findPackageFragmentRoot(testEntry.getPath());
        int lastDelimiterIndex = testFullyQualifiedName.lastIndexOf(".");
        String packageQualifiedName = lastDelimiterIndex < 0 ? "" : testFullyQualifiedName.substring(0, testFullyQualifiedName.lastIndexOf("."));
        IPackageFragment packageFragment = packageRoot.getPackageFragment(packageQualifiedName);
        String compilationUnitName = testFullyQualifiedName.substring(testFullyQualifiedName.lastIndexOf(".") + 1) + ".java";
        ICompilationUnit testUnit = packageFragment.getCompilationUnit(compilationUnitName);
        return testUnit;
    }

    private static List<String> getMethodsToTest(ITypeBinding typeBinding) {
        IMethodBinding[] typeMethods;
        LinkedList<IMethodBinding> allMethods = new LinkedList<IMethodBinding>();
        LinkedList<Option> options = new LinkedList<Option>();
        IMethodBinding[] iMethodBindingArray = typeMethods = typeBinding.getDeclaredMethods();
        int n = typeMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method2 = iMethodBindingArray[n2];
            int modifiers = method2.getModifiers();
            if (!(method2.isConstructor() || Modifier.isPrivate((int)modifiers) || method2.isSynthetic())) {
                allMethods.add(method2);
            }
            ++n2;
        }
        options.addAll(allMethods.stream().map(method -> {
            String returnValue = method.getReturnType().getName();
            ITypeBinding[] paramTypes = method.getParameterTypes();
            String params = String.join((CharSequence)", ", (CharSequence[])Arrays.stream(paramTypes).map(t -> t.getName()).toArray(String[]::new));
            return new Option(method.getName(), method.getName() + "(" + params + ")", ": " + returnValue, false);
        }).sorted((methodA, methodB) -> methodA.label.compareTo(methodB.label)).collect(Collectors.toList()));
        ITypeBinding superClass = typeBinding.getSuperclass();
        while (superClass != null && !"java.lang.Object".equals(superClass.getBinaryName())) {
            allMethods.clear();
            IMethodBinding[] iMethodBindingArray2 = superClass.getDeclaredMethods();
            int n3 = iMethodBindingArray2.length;
            n = 0;
            while (n < n3) {
                IMethodBinding method3 = iMethodBindingArray2[n];
                if (!method3.isConstructor() && !method3.isSynthetic() && TestGenerationUtils.isAccessible(method3, typeBinding)) {
                    allMethods.add(method3);
                }
                ++n;
            }
            options.addAll(allMethods.stream().map(method -> {
                String returnValue = method.getReturnType().getName();
                ITypeBinding[] paramTypes = method.getParameterTypes();
                String params = String.join((CharSequence)", ", (CharSequence[])Arrays.stream(paramTypes).map(t -> t.getName()).toArray(String[]::new));
                String description = ": " + returnValue + " (" + method.getDeclaringClass().getName() + ")";
                return new Option(method.getName(), method.getName() + "(" + params + ")", description, true);
            }).sorted((methodA, methodB) -> methodA.label.compareTo(methodB.label)).collect(Collectors.toList()));
            superClass = superClass.getSuperclass();
        }
        if (options.size() == 0) {
            return Collections.emptyList();
        }
        boolean hasInheritedMethods = options.stream().anyMatch(o -> o.isAdvanced);
        if (hasInheritedMethods) {
            return (List)JUnitPlugin.advancedAskClientForChoice("Select the methods to test", options, "inherited methods", true);
        }
        return (List)JUnitPlugin.askClientForChoice("Select the methods to test", options, true);
    }

    private static String getTestMethodName(String methodName) {
        return "test" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
    }

    private static WorkspaceEdit generateTestsFromTest(ICompilationUnit unit, CompilationUnit root, TypeDeclaration typeNode, ITypeBinding typeBinding, int cursorOffset) throws MalformedTreeException, CoreException {
        TestKind testKind;
        Set<TestKind> availableFrameworks = TestGenerationUtils.getTestKindFromFile(unit);
        if (availableFrameworks.size() == 0) {
            availableFrameworks.addAll(TestKindProvider.getTestKindsFromCache(unit.getJavaProject()));
        }
        if ((testKind = TestGenerationUtils.determineTestFramework(availableFrameworks)) == null) {
            return null;
        }
        List<String> lifecycleAnnotations = TestGenerationUtils.getLifecycleAnnotations(testKind);
        List<String> methodsToGenerate = TestGenerationUtils.determineMethodsToGenerate(lifecycleAnnotations);
        if (methodsToGenerate == null || methodsToGenerate.size() == 0) {
            return null;
        }
        IJavaElement insertPosition = null;
        try {
            insertPosition = CodeGenerationUtils.findInsertElement((IType)((IType)typeBinding.getJavaElement()), (int)cursorOffset);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TextEdit textEdit = TestGenerationUtils.createTextEditFromTestFile(testKind, methodsToGenerate, root, typeNode, typeBinding, insertPosition);
        return SourceAssistProcessor.convertToWorkspaceEdit((ICompilationUnit)unit, (TextEdit)textEdit);
    }

    private static List<String> determineMethodsToGenerate(List<String> lifecycleAnnotations) {
        List<Option> methodList = lifecycleAnnotations.stream().map(annotation -> new Option((String)annotation, "@" + annotation, TestGenerationUtils.capitalize(TestGenerationUtils.getSuggestedMethodNameByAnnotation(annotation)) + " Method")).collect(Collectors.toList());
        Option testMethod = new Option("Test", "@Test", "Test Method");
        testMethod.picked = true;
        methodList.add(0, testMethod);
        return (List)JUnitPlugin.askClientForChoice("Select methods to generate", methodList, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static IJavaProject determineTestProject(ICompilationUnit unit) {
        IJavaProject project;
        IJavaProject javaProject = unit.getJavaProject();
        if (TestKindProvider.getTestKindsFromCache(javaProject).size() > 0) {
            return javaProject;
        }
        IJavaProject[] javaProjects = ProjectUtils.getJavaProjects();
        LinkedList<Option> javaTestProjects = new LinkedList<Option>();
        IJavaProject[] iJavaProjectArray = javaProjects;
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            project = iJavaProjectArray[n2];
            JavaLanguageServerPlugin.getProjectsManager();
            if (!project.equals(ProjectsManager.getDefaultProject()) && TestKindProvider.getTestKindsFromCache(project).size() > 0) {
                javaTestProjects.add(new Option(project.getHandleIdentifier(), project.getElementName(), project.getProject().getLocation().toOSString()));
            }
            ++n2;
        }
        if (javaTestProjects.size() != 0) {
            Object result = JUnitPlugin.askClientForChoice("Select a project where tests are generated in", javaTestProjects);
            if (result != null) return (IJavaProject)JavaCore.create((String)((String)result));
            return null;
        }
        project = javaProject.getProject();
        String msg = "No test library found in your workspace, please add a test library to your project classpath first.";
        if (project.isAccessible() && !ProjectUtils.isVisibleProject((IProject)project)) {
            JavaLanguageServerPlugin.getProjectsManager();
            if (!project.equals((Object)ProjectsManager.getDefaultProject())) {
                JavaLanguageServerPlugin.getInstance().getClientConnection().sendActionableNotification(MessageType.Error, "No test library found in your workspace, please add a test library to your project classpath first.", null, Arrays.asList(new Command("Enable tests", "_java.test.enableTests")));
                return null;
            }
        }
        JavaLanguageServerPlugin.getInstance().getClientConnection().showNotificationMessage(MessageType.Error, "No test library found in your workspace, please add a test library to your project classpath first.");
        return null;
    }

    private static TestKind determineTestFramework(Set<TestKind> availableFrameworks) throws CoreException {
        if (availableFrameworks.size() == 0) {
            JavaLanguageServerPlugin.getInstance().getClientConnection().showNotificationMessage(MessageType.Error, "Cannot find a unit test framework in the project, please make sure it's on the classpath.");
            return null;
        }
        if (availableFrameworks.size() == 1) {
            return availableFrameworks.iterator().next();
        }
        List<Option> frameworkList = availableFrameworks.stream().sorted((kind1, kind2) -> kind1.getValue() - kind2.getValue()).map(framework -> new Option(framework.toString())).collect(Collectors.toList());
        Object result = JUnitPlugin.askClientForChoice("Select a test framework to use", frameworkList);
        if (result == null) {
            return null;
        }
        return TestKind.fromString((String)result);
    }

    private static Set<TestKind> getTestKindFromFile(ICompilationUnit unit) throws JavaModelException {
        IImportDeclaration[] imports = unit.getImports();
        HashSet<TestKind> testKindsInFile = new HashSet<TestKind>();
        IImportDeclaration[] iImportDeclarationArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration importDeclaration = iImportDeclarationArray[n2];
            String importPackage = importDeclaration.getElementName();
            if (importPackage.startsWith(JUNIT5_PREFIX)) {
                testKindsInFile.add(TestKind.JUnit5);
            } else if (importPackage.startsWith(JUNIT4_PREFIX)) {
                testKindsInFile.add(TestKind.JUnit);
            } else if (importPackage.startsWith(TESTNG_PREFIX)) {
                testKindsInFile.add(TestKind.TestNG);
            }
            ++n2;
        }
        return testKindsInFile;
    }

    private static TextEdit createTextEditFromTestFile(TestKind kind, List<String> methodsToGenerate, CompilationUnit root, TypeDeclaration typeNode, ITypeBinding typeBinding, IJavaElement insertPosition) throws MalformedTreeException, CoreException {
        String annotationPrefix = "";
        if (kind == TestKind.JUnit) {
            annotationPrefix = JUNIT4_LIFECYCLE_ANNOTATION_PREFIX;
        } else if (kind == TestKind.JUnit5) {
            annotationPrefix = JUNIT5_LIFECYCLE_ANNOTATION_PREFIX;
        } else if (kind == TestKind.TestNG) {
            annotationPrefix = TESTNG_LIFECYCLE_ANNOTATION_PREFIX;
        }
        String prefix = annotationPrefix;
        List<MethodMetaData> metadata = methodsToGenerate.stream().map(annotationName -> {
            String methodName = TestGenerationUtils.getSuggestedMethodNameByAnnotation(annotationName);
            return new MethodMetaData(methodName, prefix + annotationName);
        }).collect(Collectors.toList());
        return TestGenerationUtils.getTextEdit(kind, metadata, root, typeNode, typeBinding, insertPosition, true);
    }

    private static TextEdit getTextEdit(TestKind kind, List<MethodMetaData> methodMetadata, CompilationUnit root, TypeDeclaration typeNode, ITypeBinding typeBinding, IJavaElement insertPosition, boolean fromTest) throws CoreException {
        ASTRewrite astRewrite = ASTRewrite.create((AST)root.getAST());
        ImportRewrite importRewrite = StubUtility.createImportRewrite((CompilationUnit)root, (boolean)true);
        ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)typeNode, typeNode.getBodyDeclarationsProperty());
        AST ast = astRewrite.getAST();
        Map<String, IMethodBinding> methodsMap = TestGenerationUtils.getMethodsBindings(typeBinding);
        HashSet<String> addedMethods = new HashSet<String>();
        for (MethodMetaData method : methodMetadata) {
            ASTNode insertion;
            MethodDeclaration decl = ast.newMethodDeclaration();
            boolean isStatic = TestGenerationUtils.needStaticModifier(kind, method.annotation);
            String methodName = TestGenerationUtils.getUniqueMethodName(typeBinding.getJavaElement(), methodsMap, addedMethods, method.methodName, isStatic);
            addedMethods.add(methodName);
            decl.setName(ast.newSimpleName(methodName));
            decl.modifiers().addAll(ASTNodeFactory.newModifiers((AST)ast, (int)TestGenerationUtils.getTestMethodModifiers(methodsMap, kind, method.annotation, methodName)));
            decl.setConstructor(false);
            decl.setReturnType2((Type)ast.newPrimitiveType(PrimitiveType.VOID));
            Block body = ast.newBlock();
            body.statements().add(astRewrite.createStringPlaceholder("", 20));
            decl.setBody(body);
            MarkerAnnotation marker = ast.newMarkerAnnotation();
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(root, decl.getStartPosition(), importRewrite);
            marker.setTypeName(ast.newName(importRewrite.addImport(method.annotation, (ImportRewrite.ImportRewriteContext)context)));
            astRewrite.getListRewrite((ASTNode)decl, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)marker, null);
            if (TestGenerationUtils.needsOverrideAnnotation(isStatic, methodsMap.get(methodName), typeBinding)) {
                CodeGenerationSettings settings = new CodeGenerationSettings();
                settings.overrideAnnotation = true;
                StubUtility2Core.addOverrideAnnotation((CodeGenerationSettings)settings, (IJavaProject)root.getJavaElement().getJavaProject(), (ASTRewrite)astRewrite, (ImportRewrite)importRewrite, (MethodDeclaration)decl, (boolean)typeBinding.isInterface(), null);
            }
            if ((insertion = StubUtility2Core.getNodeToInsertBefore((ListRewrite)listRewrite, (IJavaElement)insertPosition)) != null && fromTest) {
                listRewrite.insertBefore((ASTNode)decl, insertion, null);
                continue;
            }
            listRewrite.insertLast((ASTNode)decl, null);
        }
        MultiTextEdit edit = new MultiTextEdit();
        edit.addChild(importRewrite.rewriteImports(null));
        edit.addChild(astRewrite.rewriteAST());
        return edit;
    }

    private static List<String> getLifecycleAnnotations(TestKind testKind) {
        ArrayList<String> list = new ArrayList<String>();
        switch (testKind) {
            case JUnit: {
                list.add("BeforeClass");
                list.add(JUNIT4_SET_UP_ANNOTATION);
                list.add(JUNIT4_TEAR_DOWN_ANNOTATION);
                list.add("AfterClass");
                break;
            }
            case JUnit5: {
                list.add(JUNIT5_BEFORE_CLASS_ANNOTATION);
                list.add(JUNIT5_SET_UP_ANNOTATION);
                list.add(JUNIT5_TEAR_DOWN_ANNOTATION);
                list.add(JUNIT5_AFTER_CLASS_ANNOTATION);
                break;
            }
            case TestNG: {
                list.add("BeforeClass");
                list.add(TESTNG_SET_UP_ANNOTATION);
                list.add(TESTNG_TEAR_DOWN_ANNOTATION);
                list.add("AfterClass");
                break;
            }
        }
        return list;
    }

    private static String getSuggestedMethodNameByAnnotation(String annotation) {
        switch (annotation) {
            case "BeforeAll": 
            case "BeforeClass": {
                return "beforeClass";
            }
            case "AfterClass": 
            case "AfterAll": {
                return "afterClass";
            }
            case "BeforeEach": 
            case "BeforeMethod": 
            case "Before": {
                return "setUp";
            }
            case "AfterEach": 
            case "After": 
            case "AfterMethod": {
                return "tearDown";
            }
        }
        return "testName";
    }

    private static int getTestMethodModifiers(Map<String, IMethodBinding> methodsMap, TestKind kind, String annotation, String methodName) {
        int modifiers = 0;
        if (TestGenerationUtils.needStaticModifier(kind, annotation)) {
            modifiers |= 8;
        }
        if (kind == TestKind.JUnit) {
            return modifiers |= 1;
        }
        IMethodBinding binding = methodsMap.get(methodName);
        if (binding == null) {
            return modifiers;
        }
        int superModifiers = binding.getModifiers();
        if (Modifier.isProtected((int)superModifiers)) {
            modifiers |= 4;
        } else if (Modifier.isPublic((int)superModifiers)) {
            modifiers |= 1;
        }
        return modifiers;
    }

    private static Map<String, IMethodBinding> getMethodsBindings(ITypeBinding typeBinding) {
        IMethodBinding[] typeMethods;
        HashMap<String, IMethodBinding> methods = new HashMap<String, IMethodBinding>();
        IMethodBinding[] iMethodBindingArray = typeMethods = typeBinding.getDeclaredMethods();
        int n = typeMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding methodBinding = iMethodBindingArray[n2];
            methods.put(methodBinding.getName(), methodBinding);
            ++n2;
        }
        ITypeBinding superClass = typeBinding.getSuperclass();
        while (superClass != null) {
            IMethodBinding[] iMethodBindingArray2 = superClass.getDeclaredMethods();
            int n3 = iMethodBindingArray2.length;
            n = 0;
            while (n < n3) {
                IMethodBinding methodBinding = iMethodBindingArray2[n];
                if (!methods.containsKey(methodBinding.getName()) && TestGenerationUtils.isAccessible(methodBinding, typeBinding)) {
                    methods.put(methodBinding.getName(), methodBinding);
                }
                ++n;
            }
            superClass = superClass.getSuperclass();
        }
        return methods;
    }

    private static boolean isAccessible(IMethodBinding superMethod, ITypeBinding declaredType) {
        int modifiers = superMethod.getModifiers();
        if (Modifier.isPrivate((int)modifiers)) {
            return false;
        }
        if (!Modifier.isProtected((int)modifiers) && !Modifier.isPublic((int)modifiers)) {
            IPackageBinding superMethodPackage = superMethod.getDeclaringClass().getPackage();
            IPackageBinding declaredPackage = declaredType.getPackage();
            return superMethodPackage != null && declaredPackage != null && superMethodPackage.getName().equals(declaredPackage.getName());
        }
        return true;
    }

    private static boolean needStaticModifier(TestKind kind, String annotation) {
        block22: {
            block20: {
                if (annotation == null) {
                    return false;
                }
                if (kind == TestKind.TestNG) {
                    return false;
                }
                annotation = annotation.substring(annotation.lastIndexOf(".") + 1);
                if (kind != TestKind.JUnit) break block20;
                switch (annotation) {
                    case "AfterClass": 
                    case "BeforeClass": {
                        return true;
                    }
                }
                return false;
            }
            if (kind != TestKind.JUnit5) break block22;
            switch (annotation) {
                case "BeforeAll": 
                case "AfterAll": {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static boolean needsOverrideAnnotation(boolean isStatic, IMethodBinding methodBinding, ITypeBinding declaredType) {
        if (isStatic) {
            return false;
        }
        if (methodBinding == null) {
            return false;
        }
        return !Objects.equals(declaredType.getBinaryName(), methodBinding.getDeclaringClass().getBinaryName());
    }

    private static String getTestAnnotation(TestKind testKind) {
        if (testKind == TestKind.JUnit) {
            return "org.junit.Test";
        }
        if (testKind == TestKind.TestNG) {
            return "org.testng.annotations.Test";
        }
        return "org.junit.jupiter.api.Test";
    }

    private static String getUniqueMethodName(IJavaElement type, Map<String, IMethodBinding> methodsMap, Set<String> addedMethods, String suggestedName, boolean isStatic) {
        IMethod[] methods = null;
        if (type instanceof IType) {
            try {
                methods = ((IType)type).getMethods();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        if (methods == null) {
            methods = new IMethod[]{};
        }
        int suggestedPostfix = 0;
        String resultName = suggestedName;
        while (suggestedPostfix < 1000) {
            int modifier;
            String string = resultName = ++suggestedPostfix > 1 ? suggestedName + suggestedPostfix : suggestedName;
            if (TestGenerationUtils.hasMethod(methods, addedMethods, resultName)) continue;
            IMethodBinding superMethod = methodsMap.get(resultName);
            if (superMethod == null) {
                return resultName;
            }
            if (!"void".equals(superMethod.getReturnType().getName()) || Modifier.isFinal((int)(modifier = superMethod.getModifiers())) || Modifier.isStatic((int)modifier) != isStatic) continue;
            return resultName;
        }
        return suggestedName;
    }

    private static boolean hasMethod(IMethod[] methods, Set<String> addedMethods, String name) {
        if (addedMethods.contains(name)) {
            return true;
        }
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (name.equals(method.getElementName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String capitalize(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    static class MethodMetaData {
        public String methodName;
        public String annotation;

        public MethodMetaData(String methodName, String annotation) {
            this.methodName = methodName;
            this.annotation = annotation;
        }
    }
}

