"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["theia-extensions_launcher_lib_browser_create-launcher-frontend-module_js"],{

/***/ "../../theia-extensions/launcher/lib/browser/create-launcher-contribution.js":
/*!***********************************************************************************!*\
  !*** ../../theia-extensions/launcher/lib/browser/create-launcher-contribution.js ***!
  \***********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2022-2024 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the MIT License, which is available in the project root.
 *
 * SPDX-License-Identifier: MIT
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CreateLauncherCommandContribution = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const launcher_service_1 = __webpack_require__(/*! ./launcher-service */ "../../theia-extensions/launcher/lib/browser/launcher-service.js");
const desktopfile_service_1 = __webpack_require__(/*! ./desktopfile-service */ "../../theia-extensions/launcher/lib/browser/desktopfile-service.js");
let CreateLauncherCommandContribution = class CreateLauncherCommandContribution {
    onStart(_app) {
        this.launcherService.isInitialized().then(async (initialized) => {
            if (!initialized) {
                const messageContainer = document.createElement('div');
                // eslint-disable-next-line max-len
                messageContainer.textContent = nls_1.nls.localizeByDefault("Would you like to install a shell command that launches the application?\nYou will be able to run CDT Cloud Blueprint from the command line by typing 'cdt-cloud'.");
                messageContainer.setAttribute('style', 'white-space: pre-line');
                const details = document.createElement('p');
                details.textContent = 'Administrator privileges are required, you will need to enter your password next.';
                messageContainer.appendChild(details);
                const dialog = new browser_1.ConfirmDialog({
                    title: nls_1.nls.localizeByDefault('Create launcher'),
                    msg: messageContainer,
                    ok: browser_1.Dialog.YES,
                    cancel: browser_1.Dialog.NO
                });
                const install = await dialog.open();
                this.launcherService.createLauncher(!!install);
                this.logger.info('Initialized application launcher.');
            }
            else {
                this.logger.info('Application launcher was already initialized.');
            }
        });
        this.desktopFileService.isInitialized().then(async (initialized) => {
            if (!initialized) {
                const messageContainer = document.createElement('div');
                // eslint-disable-next-line max-len
                messageContainer.textContent = nls_1.nls.localizeByDefault('Would you like to create a .desktop file for CDT Cloud Blueprint?\nThis will make it easier to open CDT Cloud Blueprint directly\nfrom your applications menu and enables further features.');
                messageContainer.setAttribute('style', 'white-space: pre-line');
                const dialog = new browser_1.ConfirmDialog({
                    title: nls_1.nls.localizeByDefault('Create .desktop file'),
                    msg: messageContainer,
                    ok: browser_1.Dialog.YES,
                    cancel: browser_1.Dialog.NO
                });
                const install = await dialog.open();
                this.desktopFileService.createOrUpdateDesktopfile(!!install);
                this.logger.info('Created or updated .desktop file.');
            }
            else {
                this.logger.info('Desktop file was not updated or created.');
            }
        });
    }
};
__decorate([
    (0, inversify_1.inject)(browser_1.StorageService),
    __metadata("design:type", Object)
], CreateLauncherCommandContribution.prototype, "storageService", void 0);
__decorate([
    (0, inversify_1.inject)(common_1.ILogger),
    __metadata("design:type", Object)
], CreateLauncherCommandContribution.prototype, "logger", void 0);
__decorate([
    (0, inversify_1.inject)(launcher_service_1.LauncherService),
    __metadata("design:type", launcher_service_1.LauncherService)
], CreateLauncherCommandContribution.prototype, "launcherService", void 0);
__decorate([
    (0, inversify_1.inject)(desktopfile_service_1.DesktopFileService),
    __metadata("design:type", desktopfile_service_1.DesktopFileService)
], CreateLauncherCommandContribution.prototype, "desktopFileService", void 0);
CreateLauncherCommandContribution = __decorate([
    (0, inversify_1.injectable)()
], CreateLauncherCommandContribution);
exports.CreateLauncherCommandContribution = CreateLauncherCommandContribution;


/***/ }),

/***/ "../../theia-extensions/launcher/lib/browser/create-launcher-frontend-module.js":
/*!**************************************************************************************!*\
  !*** ../../theia-extensions/launcher/lib/browser/create-launcher-frontend-module.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
/********************************************************************************
 * Copyright (C) 2022-2024 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the MIT License, which is available in the project root.
 *
 * SPDX-License-Identifier: MIT
 ********************************************************************************/
const create_launcher_contribution_1 = __webpack_require__(/*! ./create-launcher-contribution */ "../../theia-extensions/launcher/lib/browser/create-launcher-contribution.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const launcher_service_1 = __webpack_require__(/*! ./launcher-service */ "../../theia-extensions/launcher/lib/browser/launcher-service.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const desktopfile_service_1 = __webpack_require__(/*! ./desktopfile-service */ "../../theia-extensions/launcher/lib/browser/desktopfile-service.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(browser_1.FrontendApplicationContribution).to(create_launcher_contribution_1.CreateLauncherCommandContribution);
    bind(launcher_service_1.LauncherService).toSelf().inSingletonScope();
    bind(desktopfile_service_1.DesktopFileService).toSelf().inSingletonScope();
});


/***/ }),

/***/ "../../theia-extensions/launcher/lib/browser/desktopfile-service.js":
/*!**************************************************************************!*\
  !*** ../../theia-extensions/launcher/lib/browser/desktopfile-service.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2024 STMicroelectronics and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the MIT License, which is available in the project root.
 *
 * SPDX-License-Identifier: MIT
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DesktopFileService = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
let DesktopFileService = class DesktopFileService {
    async isInitialized() {
        const response = await fetch(new Request(`${this.endpoint()}/initialized`), {
            body: undefined,
            method: 'GET'
        }).then(r => r.json());
        return !!(response === null || response === void 0 ? void 0 : response.initialized);
    }
    async createOrUpdateDesktopfile(create) {
        fetch(new Request(`${this.endpoint()}`), {
            body: JSON.stringify({ create }),
            method: 'PUT',
            headers: new Headers({ 'Content-Type': 'application/json' })
        });
    }
    endpoint() {
        const url = new browser_1.Endpoint({ path: 'desktopfile' }).getRestUrl().toString();
        return url.endsWith('/') ? url.slice(0, -1) : url;
    }
};
DesktopFileService = __decorate([
    (0, inversify_1.injectable)()
], DesktopFileService);
exports.DesktopFileService = DesktopFileService;


/***/ }),

/***/ "../../theia-extensions/launcher/lib/browser/launcher-service.js":
/*!***********************************************************************!*\
  !*** ../../theia-extensions/launcher/lib/browser/launcher-service.js ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2022 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the MIT License, which is available in the project root.
 *
 * SPDX-License-Identifier: MIT
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LauncherService = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
let LauncherService = class LauncherService {
    async isInitialized() {
        const response = await fetch(new Request(`${this.endpoint()}/initialized`), {
            body: undefined,
            method: 'GET'
        }).then(r => r.json());
        return !!(response === null || response === void 0 ? void 0 : response.initialized);
    }
    async createLauncher(create) {
        fetch(new Request(`${this.endpoint()}`), {
            body: JSON.stringify({ create }),
            method: 'PUT',
            headers: new Headers({ 'Content-Type': 'application/json' })
        });
    }
    endpoint() {
        const url = new browser_1.Endpoint({ path: 'launcher' }).getRestUrl().toString();
        return url.endsWith('/') ? url.slice(0, -1) : url;
    }
};
LauncherService = __decorate([
    (0, inversify_1.injectable)()
], LauncherService);
exports.LauncherService = LauncherService;


/***/ })

}]);
//# sourceMappingURL=theia-extensions_launcher_lib_browser_create-launcher-frontend-module_js.js.map