/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil;

import java.io.InvalidObjectException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sun.security.action.GetPropertyAction;

public final class IORCheckImpl {
    private static final Set<String> stubsToCheck;

    private static Set<String> getStubsToCheck(boolean bl, boolean bl2) {
        if (!bl && !bl2) {
            return Collections.emptySet();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.addAll(IORCheckImpl.getLocalStubs());
        }
        if (bl2) {
            arrayList.addAll(IORCheckImpl.getRemoteStubs());
        }
        return Collections.unmodifiableSet(new HashSet(arrayList));
    }

    private static List<String> getLocalStubs() {
        String[] stringArray = new String[]{"org.omg.DynamicAny._DynAnyFactoryStub", "org.omg.DynamicAny._DynAnyStub", "org.omg.DynamicAny._DynArrayStub", "org.omg.DynamicAny._DynEnumStub", "org.omg.DynamicAny._DynFixedStub", "org.omg.DynamicAny._DynSequenceStub", "org.omg.DynamicAny._DynStructStub", "org.omg.DynamicAny._DynUnionStub", "org.omg.DynamicAny._DynValueStub"};
        return Arrays.asList(stringArray);
    }

    private static List<String> getRemoteStubs() {
        String[] stringArray = new String[]{"com.sun.corba.se.spi.activation._ActivatorStub", "com.sun.corba.se.spi.activation._InitialNameServiceStub", "com.sun.corba.se.spi.activation._LocatorStub", "com.sun.corba.se.spi.activation._RepositoryStub", "com.sun.corba.se.spi.activation._ServerManagerStub", "com.sun.corba.se.spi.activation._ServerStub", "org.omg.CosNaming._BindingIteratorStub", "org.omg.CosNaming._NamingContextExtStub", "org.omg.CosNaming._NamingContextStub", "org.omg.PortableServer._ServantActivatorStub", "org.omg.PortableServer._ServantLocatorStub"};
        return Arrays.asList(stringArray);
    }

    public static void check(String string, String string2) throws InvalidObjectException {
        if (stubsToCheck.contains(string2) && !string.startsWith("IOR:")) {
            throw new InvalidObjectException("IOR: expected");
        }
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = AccessController.doPrivileged(new GetPropertyAction(string, String.valueOf(bl)));
        return "true".equalsIgnoreCase(string2);
    }

    static {
        boolean bl = !IORCheckImpl.getBooleanProperty("org.omg.DynamicAny.disableIORCheck", IORCheckImpl.getBooleanProperty("com.sun.CORBA.ORBAllowDeserializeObject", false));
        boolean bl2 = IORCheckImpl.getBooleanProperty("org.omg.CORBA.IDL.Stubs.enableIORCheck", false);
        stubsToCheck = IORCheckImpl.getStubsToCheck(bl, bl2);
    }
}

