/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.classloader;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import jdk.test.lib.classloader.ClassLoadUtils;
import jdk.test.lib.classloader.TemplateClass;

public class GeneratingClassLoader
extends ClassLoader {
    public static final String DEFAULT_CLASSNAME = TemplateClass.class.getName();
    static final String PREFIX = "Class";
    private final String[] classPath;
    private byte[] bytecode;
    private int[] offsets;
    private final String encoding = "UTF8";
    private final String templateClassName;
    private final byte[] templateClassNameBytes;

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (!name.startsWith(PREFIX)) {
            return super.loadClass(name, resolve);
        }
        if (name.length() != this.templateClassName.length()) {
            throw new ClassNotFoundException("Only can load classes with name.length() = " + this.getNameLength() + " got: '" + name + "' length: " + name.length());
        }
        byte[] bytecode = this.getPatchedByteCode(name);
        c = this.defineClass(name, bytecode, 0, bytecode.length);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public GeneratingClassLoader(String templateClassName) {
        this.templateClassName = templateClassName;
        this.classPath = System.getProperty("java.class.path").split(File.pathSeparator);
        try {
            this.templateClassNameBytes = templateClassName.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public GeneratingClassLoader() {
        this(TemplateClass.class.getName());
    }

    public int getNameLength() {
        return this.templateClassName.length();
    }

    String getPrefix() {
        return PREFIX;
    }

    public String getClassName(int number) {
        StringBuffer sb = new StringBuffer();
        sb.append(PREFIX);
        sb.append(number);
        int n = this.templateClassName.length() - sb.length();
        for (int i = 0; i < n; ++i) {
            sb.append("_");
        }
        return sb.toString();
    }

    private byte[] getPatchedByteCode(String name) throws ClassNotFoundException {
        try {
            byte[] bytecode = this.getByteCode();
            String fname = name.replace(".", File.separator);
            byte[] replaceBytes = fname.getBytes("UTF8");
            for (int offset : this.offsets) {
                for (int i = 0; i < replaceBytes.length; ++i) {
                    bytecode[offset + i] = replaceBytes[i];
                }
            }
            return bytecode;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getByteCode() throws ClassNotFoundException {
        if (this.bytecode == null) {
            this.readByteCode();
        }
        if (this.offsets == null) {
            this.getOffsets(this.bytecode);
            if (this.offsets == null) {
                throw new RuntimeException("Class name not found in template class file");
            }
        }
        return (byte[])this.bytecode.clone();
    }

    private void readByteCode() throws ClassNotFoundException {
        String fname = this.templateClassName.replace(".", File.separator) + ".class";
        File target = null;
        for (int i = 0; i < this.classPath.length && !(target = new File(this.classPath[i] + File.separator + fname)).exists(); ++i) {
        }
        if (target == null || !target.exists()) {
            throw new ClassNotFoundException("File not found: " + String.valueOf(target));
        }
        try {
            this.bytecode = ClassLoadUtils.readFile(target);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(this.templateClassName, e);
        }
    }

    private void getOffsets(byte[] bytecode) {
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        if (this.offsets == null) {
            String pname = this.templateClassName.replace(".", "/");
            try {
                byte[] pnameb = pname.getBytes("UTF8");
                int i = 0;
                while (true) {
                    if (i < bytecode.length) {
                        int j;
                        for (j = 0; j < pnameb.length && bytecode[i + j] == pnameb[j]; ++j) {
                        }
                        if (j != pnameb.length) {
                            ++i;
                            continue;
                        }
                    }
                    if (i != bytecode.length) {
                        offsets.add(i);
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.offsets = new int[offsets.size()];
            for (int i = 0; i < offsets.size(); ++i) {
                this.offsets[i] = (Integer)offsets.get(i);
            }
        }
    }
}

