/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import java.text.MessageFormat;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.internal.view.factories.SiriusNoteViewFactory;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class RepresentationLinkMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("14.1.0.201810111800");

    private boolean migrateDiagram(Diagram diag) {
        boolean changed = false;
        TreeIterator it = diag.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof View) || !ViewType.NOTE.equals(((View)next).getType()) || !(((View)next).getElement() instanceof DRepresentationDescriptor)) continue;
            SiriusNoteViewFactory.markAsLinkNote((View)next);
            changed = true;
        }
        return changed;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            StringBuilder builder = new StringBuilder();
            boolean isModified = false;
            for (DView view : dAnalysis.getOwnedViews()) {
                for (DRepresentationDescriptor representationDesc : new DViewQuery(view).getLoadedRepresentationsDescriptors()) {
                    DDiagramGraphicalQuery query;
                    Option<Diagram> option;
                    if (!(representationDesc.getRepresentation() instanceof DDiagram) || !(option = (query = new DDiagramGraphicalQuery((DDiagram)representationDesc.getRepresentation())).getAssociatedGMFDiagram()).some() || !this.migrateDiagram((Diagram)option.get())) continue;
                    builder.append(MessageFormat.format(Messages.RepresentationLinkMigrationParticipant_entry, representationDesc.getName())).append(System.lineSeparator());
                    isModified = true;
                }
            }
            if (isModified) {
                builder.insert(0, System.lineSeparator());
                builder.insert(0, Messages.RepresentationLinkMigrationParticipant_title);
                DiagramPlugin.getDefault().logInfo(builder.toString());
            }
        }
    }

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }
}

