/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.meta.jvmmodel;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.core.meta.MetaDataRuntimeModule;
import org.eclipse.elk.core.meta.metaData.MdAlgorithm;
import org.eclipse.elk.core.meta.metaData.MdBundle;
import org.eclipse.elk.core.meta.metaData.MdBundleMember;
import org.eclipse.elk.core.meta.metaData.MdCategory;
import org.eclipse.elk.core.meta.metaData.MdGraphFeature;
import org.eclipse.elk.core.meta.metaData.MdGroup;
import org.eclipse.elk.core.meta.metaData.MdModel;
import org.eclipse.elk.core.meta.metaData.MdOption;
import org.eclipse.elk.core.meta.metaData.MdOptionDependency;
import org.eclipse.elk.core.meta.metaData.MdOptionSupport;
import org.eclipse.elk.core.meta.metaData.MdOptionTargetType;
import org.eclipse.elk.graph.properties.GraphFeature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.JvmModelGenerator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class MelkDocumentationGenerator
extends JvmModelGenerator {
    private IFileSystemAccess fsa;
    private Path algorithmsOutputPath;
    private Path optionsOutputPath;
    private Path optionGroupsOutputPath;
    private Path imageOutputPath;
    private Path projectDocumentationSourceFolder;

    protected void _internalDoGenerate(MdModel model, IFileSystemAccess fsa) {
        this.fsa = fsa;
        String propertyOutputPath = System.getProperty("elk.metadata.documentation.outputPath");
        if (propertyOutputPath == null) {
            return;
        }
        this.setupOutputPaths(propertyOutputPath);
        if (model.getName() == null || model.getBundle() == null) {
            return;
        }
        MdBundle bundle = model.getBundle();
        EList<MdBundleMember> members = bundle.getMembers();
        String _documentationFolder = bundle.getDocumentationFolder();
        boolean _tripleNotEquals = _documentationFolder != null;
        this.projectDocumentationSourceFolder = _tripleNotEquals ? Paths.get(bundle.getDocumentationFolder(), new String[0]) : Paths.get("docs", new String[0]);
        Iterable _filter = Iterables.filter(members, MdAlgorithm.class);
        for (MdAlgorithm algorithm : _filter) {
            this.writeDoc(algorithm, this.algorithmsOutputPath);
        }
        Iterable<MdOption> _allOptionDefinitions = this.getAllOptionDefinitions((Iterable<? extends MdBundleMember>)members);
        for (MdOption option : _allOptionDefinitions) {
            this.writeDoc(option, this.optionsOutputPath);
        }
        Iterable<MdGroup> _allGroupDefinitions = this.getAllGroupDefinitions((Iterable<? extends MdBundleMember>)members);
        for (MdGroup group : _allGroupDefinitions) {
            this.writeDoc(group, this.optionGroupsOutputPath);
        }
    }

    private Path setupOutputPaths(String docsOutputPathString) {
        try {
            Path _xblockexpression = null;
            Path docsOutputPath = Paths.get(docsOutputPathString, new String[0]);
            Path referencePath = docsOutputPath.resolve("content").resolve("reference");
            this.algorithmsOutputPath = referencePath.resolve("algorithms");
            Files.createDirectories(this.algorithmsOutputPath, new FileAttribute[0]);
            this.optionsOutputPath = referencePath.resolve("options");
            Files.createDirectories(this.optionsOutputPath, new FileAttribute[0]);
            this.optionGroupsOutputPath = referencePath.resolve("groups");
            Files.createDirectories(this.optionGroupsOutputPath, new FileAttribute[0]);
            this.imageOutputPath = docsOutputPath.resolve("static").resolve("img_gen");
            _xblockexpression = Files.createDirectories(this.imageOutputPath, new FileAttribute[0]);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void writeDoc(MdBundleMember member, Path outputPath) {
        String fileName = this.toHugoIdentifier(this.getQualifiedName(member));
        this.writeDoc(fileName, outputPath, this.generateDoc(member));
    }

    private void writeDoc(String fileName, Path outputPath, String documentation) {
        boolean _not;
        String file = fileName;
        boolean _endsWith = file.endsWith(".md");
        boolean bl = _not = !_endsWith;
        if (_not) {
            String _file = file;
            file = String.valueOf(_file) + ".md";
        }
        try (PrintWriter out = null;){
            try {
                PrintWriter _printWriter;
                String _string = outputPath.resolve(file).toString();
                out = _printWriter = new PrintWriter(_string);
                out.print(documentation);
            }
            catch (Throwable _t) {
                if (!(_t instanceof Exception)) {
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                Exception exception = (Exception)_t;
                exception.printStackTrace();
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private void copyImageToOutputPath(String path, String newFileName) {
        if (path == null || newFileName == null) {
            return;
        }
        try {
            InputStream iStream = ((AbstractFileSystemAccess2)this.fsa).readBinaryFile(path, MetaDataRuntimeModule.MelkOutputConfigurationProvider.AD_INPUT);
            Files.copy(iStream, this.imageOutputPath.resolve(newFileName), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception exception = (Exception)_t;
                exception.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private String _generateDoc(MdAlgorithm algorithm) {
        boolean _isEmpty_1;
        boolean _not_3;
        String _documentation;
        boolean _tripleNotEquals_2;
        boolean _isEmpty;
        boolean _not_2;
        MdCategory _category;
        boolean _tripleNotEquals_1;
        boolean _not;
        boolean _tripleNotEquals;
        String _name;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("---");
        _builder.newLine();
        _builder.append("title: \"");
        String _elvis = null;
        String _label = algorithm.getLabel();
        _elvis = _label != null ? _label : (_name = algorithm.getName());
        _builder.append(_elvis);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("displayid: \"");
        String _qualifiedName = this.getQualifiedName(algorithm);
        _builder.append(_qualifiedName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("menu:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("main:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("identifier: \"alg-");
        String _hugoIdentifier = this.toHugoIdentifier(this.getQualifiedName(algorithm));
        _builder.append(_hugoIdentifier, "    ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("parent: \"Algorithms\"");
        _builder.newLine();
        _builder.append("---");
        _builder.newLine();
        _builder.newLine();
        String doc = _builder.toString();
        String _previewImage = algorithm.getPreviewImage();
        boolean bl = _tripleNotEquals = _previewImage != null;
        if (_tripleNotEquals) {
            String _hugoIdentifier_1 = this.toHugoIdentifier(this.getQualifiedName(algorithm));
            String _plus = String.valueOf(_hugoIdentifier_1) + "_preview_";
            String _previewImage_1 = algorithm.getPreviewImage();
            int _lastIndexOf = algorithm.getPreviewImage().lastIndexOf("/");
            int _plus_1 = _lastIndexOf + 1;
            String _substring = _previewImage_1.substring(_plus_1);
            String newFileName = String.valueOf(_plus) + _substring;
            this.copyImageToOutputPath(algorithm.getPreviewImage(), newFileName);
            String _doc = doc;
            doc = String.valueOf(_doc) + "{{< image src=\"" + newFileName + "\" alt=\"Preview Image\" gen=\"1\" >}}\n\n";
        }
        String _doc_1 = doc;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Property | Value");
        _builder_1.newLine();
        _builder_1.append("-------- | -----");
        _builder_1.newLine();
        _builder_1.append("*Identifier:* | `");
        String _qualifiedName_1 = this.getQualifiedName(algorithm);
        _builder_1.append(_qualifiedName_1);
        _builder_1.append("`");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("*Meta Data Provider:* | `");
        String _targetClass = this.getBundle(algorithm).getTargetClass();
        _builder_1.append(_targetClass);
        _builder_1.append("`");
        _builder_1.newLineIfNotEmpty();
        _builder_1.newLine();
        doc = String.valueOf(_doc_1) + _builder_1;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)algorithm.getDescription());
        boolean bl2 = _not = !_isNullOrEmpty;
        if (_not) {
            String _doc_2 = doc;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("## Description");
            _builder_2.newLine();
            _builder_2.newLine();
            String _trimNewlineTabsAndReduceToSingleSpace = this.trimNewlineTabsAndReduceToSingleSpace(algorithm.getDescription());
            _builder_2.append(_trimNewlineTabsAndReduceToSingleSpace);
            _builder_2.newLineIfNotEmpty();
            _builder_2.newLine();
            doc = String.valueOf(_doc_2) + _builder_2;
        }
        boolean bl3 = _tripleNotEquals_1 = (_category = algorithm.getCategory()) != null;
        if (_tripleNotEquals_1) {
            boolean _not_1;
            String _name_1;
            String _doc_3 = doc;
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("## Category: ");
            String _elvis_1 = null;
            String _label_1 = algorithm.getCategory().getLabel();
            _elvis_1 = _label_1 != null ? _label_1 : (_name_1 = algorithm.getCategory().getName());
            _builder_3.append(_elvis_1);
            _builder_3.newLineIfNotEmpty();
            _builder_3.newLine();
            doc = String.valueOf(_doc_3) + _builder_3;
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)algorithm.getCategory().getDescription());
            boolean bl4 = _not_1 = !_isNullOrEmpty_1;
            if (_not_1) {
                String _doc_4 = doc;
                StringConcatenation _builder_4 = new StringConcatenation();
                String _trimNewlineTabsAndReduceToSingleSpace_1 = this.trimNewlineTabsAndReduceToSingleSpace(algorithm.getCategory().getDescription());
                _builder_4.append(_trimNewlineTabsAndReduceToSingleSpace_1);
                _builder_4.newLineIfNotEmpty();
                _builder_4.newLine();
                doc = String.valueOf(_doc_4) + _builder_4;
            }
        }
        boolean bl5 = _not_2 = !(_isEmpty = algorithm.getSupportedFeatures().isEmpty());
        if (_not_2) {
            String _doc_5 = doc;
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("## Supported Graph Features");
            _builder_5.newLine();
            _builder_5.newLine();
            _builder_5.append("Name | Description");
            _builder_5.newLine();
            _builder_5.append("----|----");
            _builder_5.newLine();
            doc = String.valueOf(_doc_5) + _builder_5;
            EList<MdGraphFeature> _supportedFeatures = algorithm.getSupportedFeatures();
            for (MdGraphFeature supportedFeature : _supportedFeatures) {
                String _doc_6 = doc;
                Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                    public String apply(String it) {
                        return StringExtensions.toFirstUpper((String)it);
                    }
                };
                String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)supportedFeature.getLiteral().split("_"))), (Functions.Function1)_function), (CharSequence)" ");
                String _plus_2 = String.valueOf(_join) + " | ";
                String _description = GraphFeature.valueOf((String)supportedFeature.name()).getDescription();
                String _plus_3 = String.valueOf(_plus_2) + _description;
                String _plus_4 = String.valueOf(_plus_3) + "\n";
                doc = String.valueOf(_doc_6) + _plus_4;
            }
            String _doc_7 = doc;
            doc = String.valueOf(_doc_7) + "\n";
        }
        boolean bl6 = _tripleNotEquals_2 = (_documentation = algorithm.getDocumentation()) != null;
        if (_tripleNotEquals_2) {
            String _doc_8 = doc;
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append("## Additional Documentation");
            _builder_6.newLine();
            _builder_6.newLine();
            String _additionalDocumentation = this.additionalDocumentation(algorithm.getDocumentation(), this.toHugoIdentifier(this.getQualifiedName(algorithm)));
            _builder_6.append(_additionalDocumentation);
            _builder_6.newLineIfNotEmpty();
            _builder_6.newLine();
            doc = String.valueOf(_doc_8) + _builder_6;
        }
        boolean bl7 = _not_3 = !(_isEmpty_1 = algorithm.getSupportedOptions().isEmpty());
        if (_not_3) {
            String _doc_9 = doc;
            StringConcatenation _builder_7 = new StringConcatenation();
            _builder_7.append("## Supported Options");
            _builder_7.newLine();
            _builder_7.newLine();
            _builder_7.append("Option | Default Value");
            _builder_7.newLine();
            _builder_7.append("----|----");
            _builder_7.newLine();
            doc = String.valueOf(_doc_9) + _builder_7;
            Functions.Function1<MdOptionSupport, String> _function_1 = new Functions.Function1<MdOptionSupport, String>(){

                public String apply(MdOptionSupport it) {
                    String _name;
                    String _elvis = null;
                    String _label = it.getOption().getLabel();
                    _elvis = _label != null ? _label : (_name = it.getOption().getName());
                    return _elvis.toLowerCase();
                }
            };
            List _sortBy = IterableExtensions.sortBy(algorithm.getSupportedOptions(), (Functions.Function1)_function_1);
            for (MdOptionSupport supportedOption : _sortBy) {
                String _text_1;
                String _name_4;
                boolean _tripleNotEquals_3;
                String optionFileName = this.toHugoIdentifier(this.getQualifiedName(supportedOption.getOption()));
                String _documentation_1 = supportedOption.getDocumentation();
                boolean bl8 = _tripleNotEquals_3 = _documentation_1 != null;
                if (_tripleNotEquals_3) {
                    String _name_3;
                    String _name_2;
                    String _plus_6;
                    String _hugoIdentifier_2 = this.toHugoIdentifier(this.getQualifiedName(supportedOption.getOption()));
                    String _plus_5 = String.valueOf(_hugoIdentifier_2) + "_";
                    String _hugoIdentifier_3 = this.toHugoIdentifier(this.getQualifiedName(algorithm));
                    optionFileName = _plus_6 = String.valueOf(_plus_5) + _hugoIdentifier_3;
                    MdOption _option = supportedOption.getOption();
                    String _elvis_2 = null;
                    String _label_2 = supportedOption.getOption().getLabel();
                    _elvis_2 = _label_2 != null ? _label_2 : (_name_2 = supportedOption.getOption().getName());
                    String _plus_7 = String.valueOf(_elvis_2) + " (";
                    String _elvis_3 = null;
                    String _label_3 = algorithm.getLabel();
                    _elvis_3 = _label_3 != null ? _label_3 : (_name_3 = algorithm.getName());
                    String _plus_8 = String.valueOf(_plus_7) + _elvis_3;
                    String _plus_9 = String.valueOf(_plus_8) + ")";
                    this.writeDoc(optionFileName, this.optionsOutputPath, this.generateDoc(_option, _plus_9, optionFileName, this.additionalDocumentation(supportedOption.getDocumentation(), optionFileName)));
                }
                StringConcatenation _builder_8 = new StringConcatenation();
                _builder_8.append("{{< relref \"reference/options/");
                _builder_8.append(optionFileName);
                _builder_8.append(".md\" >}}");
                String optionFileLink = _builder_8.toString();
                String _doc_10 = doc;
                StringConcatenation _builder_9 = new StringConcatenation();
                _builder_9.append("[");
                String _elvis_4 = null;
                String _label_4 = supportedOption.getOption().getLabel();
                _elvis_4 = _label_4 != null ? _label_4 : (_name_4 = supportedOption.getOption().getName());
                _builder_9.append(_elvis_4);
                _builder_9.append("](");
                _builder_9.append(optionFileLink);
                _builder_9.append(")");
                StringConcatenation _builder_10 = new StringConcatenation();
                _builder_10.append(" ");
                _builder_10.append("| `");
                String _elvis_5 = null;
                XExpression _value = supportedOption.getValue();
                String _text = null;
                if (_value != null) {
                    _text = this.getText(_value);
                }
                _elvis_5 = _text != null ? _text : (_text_1 = this.getText(supportedOption.getOption().getDefaultValue()));
                _builder_10.append(_elvis_5, " ");
                _builder_10.append("`");
                String _plus_10 = String.valueOf(_builder_9.toString()) + _builder_10;
                String _plus_11 = String.valueOf(_plus_10) + "\n";
                doc = String.valueOf(_doc_10) + _plus_11;
            }
            String _doc_10 = doc;
            doc = String.valueOf(_doc_10) + "\n";
        }
        return doc;
    }

    private String _generateDoc(MdOption option) {
        String _name;
        String _elvis = null;
        String _label = option.getLabel();
        _elvis = _label != null ? _label : (_name = option.getName());
        return this.generateDoc(option, _elvis, this.toHugoIdentifier(this.getQualifiedName(option)), this.additionalDocumentation(option.getDocumentation(), this.toHugoIdentifier(this.getQualifiedName(option))));
    }

    private String generateDoc(MdOption option, String title, String id, String additionalDoc) {
        boolean _not_5;
        boolean _tripleNotEquals_4;
        boolean _not_4;
        boolean _not_3;
        boolean _not_2;
        boolean _not_1;
        boolean _tripleNotEquals_3;
        boolean _tripleNotEquals_2;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("---");
        _builder.newLine();
        _builder.append("title: \"");
        _builder.append(title);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("displayid: \"");
        String _qualifiedName = this.getQualifiedName(option);
        _builder.append(_qualifiedName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("menu:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("main:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("identifier: \"option-");
        _builder.append(id, "    ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("parent: \"LayoutOptions\"");
        _builder.newLine();
        _builder.append("---");
        _builder.newLine();
        _builder.newLine();
        String doc = _builder.toString();
        boolean _isDeprecated = option.isDeprecated();
        Pair _mappedTo = Pair.of((Object)"deprecated", (Object)_isDeprecated);
        boolean _isAdvanced = option.isAdvanced();
        Pair _mappedTo_1 = Pair.of((Object)"advanced", (Object)_isAdvanced);
        boolean _isProgrammatic = option.isProgrammatic();
        Pair _mappedTo_2 = Pair.of((Object)"programmatic", (Object)_isProgrammatic);
        boolean _isOutput = option.isOutput();
        Pair _mappedTo_3 = Pair.of((Object)"output", (Object)_isOutput);
        boolean _isGlobal = option.isGlobal();
        Pair _mappedTo_4 = Pair.of((Object)"global", (Object)_isGlobal);
        Functions.Function1<Pair<String, Boolean>, Boolean> _function = new Functions.Function1<Pair<String, Boolean>, Boolean>(){

            public Boolean apply(Pair<String, Boolean> it) {
                return (Boolean)it.getValue();
            }
        };
        Iterable kinds = IterableExtensions.filter(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3, _mappedTo_4})), (Functions.Function1)_function);
        String _doc = doc;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.newLine();
        _builder_1.append("Property | Value");
        _builder_1.newLine();
        _builder_1.append("-------- | -----");
        _builder_1.newLine();
        StringConcatenation _xifexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)kinds);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("*Type:* | ");
            Functions.Function1<Pair<String, Boolean>, String> _function_1 = new Functions.Function1<Pair<String, Boolean>, String>(){

                public String apply(Pair<String, Boolean> it) {
                    return (String)it.getKey();
                }
            };
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)kinds, (Functions.Function1)_function_1), (CharSequence)", ");
            _builder_2.append(_join);
            _xifexpression = _builder_2;
        }
        _builder_1.append(_xifexpression);
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("*Identifier:* | `");
        String _qualifiedName_1 = this.getQualifiedName(option);
        _builder_1.append(_qualifiedName_1);
        _builder_1.append("`");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("*Meta Data Provider:* | `");
        String _targetClass = this.getBundle(option).getTargetClass();
        _builder_1.append(_targetClass);
        _builder_1.append("`");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("*Value Type:* | `");
        JvmTypeReference _type = option.getType();
        String _identifier = null;
        if (_type != null) {
            _identifier = _type.getIdentifier();
        }
        _builder_1.append(_identifier);
        _builder_1.append("`");
        String _xifexpression_1 = null;
        JvmTypeReference _type_1 = option.getType();
        JvmType _type_2 = null;
        if (_type_1 != null) {
            _type_2 = _type_1.getType();
        }
        if (_type_2 instanceof JvmEnumerationType) {
            _xifexpression_1 = " (Enum)";
        }
        _builder_1.append(_xifexpression_1);
        _builder_1.newLineIfNotEmpty();
        String _xifexpression_2 = null;
        Iterable<? extends JvmField> _possibleValues = this.getPossibleValues(option.getType());
        boolean bl2 = _tripleNotEquals = _possibleValues != null;
        if (_tripleNotEquals) {
            Functions.Function1<JvmField, String> _function_2 = new Functions.Function1<JvmField, String>(){

                public String apply(JvmField it) {
                    String _simpleName = it.getSimpleName();
                    String _plus = "`" + _simpleName;
                    String _plus_1 = String.valueOf(_plus) + "`";
                    EList _annotations = it.getAnnotations();
                    List _sortBy = null;
                    if (_annotations != null) {
                        Functions.Function1<JvmAnnotationReference, String> _function = new Functions.Function1<JvmAnnotationReference, String>(){

                            public String apply(JvmAnnotationReference it_1) {
                                JvmAnnotationType _annotation = it_1.getAnnotation();
                                String _simpleName = null;
                                if (_annotation != null) {
                                    _simpleName = _annotation.getSimpleName();
                                }
                                return _simpleName;
                            }
                        };
                        _sortBy = IterableExtensions.sortBy((Iterable)_annotations, (Functions.Function1)_function);
                    }
                    Functions.Function1<JvmAnnotationReference, CharSequence> _function_1 = new Functions.Function1<JvmAnnotationReference, CharSequence>(){

                        public CharSequence apply(JvmAnnotationReference it_1) {
                            JvmAnnotationType _annotation = it_1.getAnnotation();
                            String _simpleName = null;
                            if (_annotation != null) {
                                _simpleName = _annotation.getSimpleName();
                            }
                            String _plus = "*`@" + _simpleName;
                            return String.valueOf(_plus) + "`*";
                        }
                    };
                    String _join = IterableExtensions.join((Iterable)_sortBy, (CharSequence)" (", (CharSequence)" and ", (CharSequence)")", (Functions.Function1)_function_1);
                    return String.valueOf(_plus_1) + _join;
                }
            };
            String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map(this.getPossibleValues(option.getType()), (Functions.Function1)_function_2), (CharSequence)"<br>");
            _xifexpression_2 = "*Possible Values:* | " + _join_1;
        }
        _builder_1.append(_xifexpression_2);
        _builder_1.newLineIfNotEmpty();
        StringConcatenation _xifexpression_3 = null;
        XExpression _defaultValue = option.getDefaultValue();
        boolean bl3 = _tripleNotEquals_1 = _defaultValue != null;
        if (_tripleNotEquals_1) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("*Default Value:* | `");
            String _text = this.getText(option.getDefaultValue());
            _builder_3.append(_text);
            _builder_3.append("` (as defined in `");
            String _elvis = null;
            String _idPrefix = this.getBundle(option).getIdPrefix();
            if (_idPrefix != null) {
                _elvis = _idPrefix;
            } else {
                String _name;
                EObject _eContainer = this.getBundle(option).eContainer();
                _elvis = _name = ((MdModel)_eContainer).getName();
            }
            _builder_3.append(_elvis);
            _builder_3.append("`)");
            _xifexpression_3 = _builder_3;
        }
        _builder_1.append(_xifexpression_3);
        _builder_1.newLineIfNotEmpty();
        StringConcatenation _xifexpression_4 = null;
        XExpression _lowerBound = option.getLowerBound();
        boolean bl4 = _tripleNotEquals_2 = _lowerBound != null;
        if (_tripleNotEquals_2) {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("*Lower Bound:* | `");
            String _text_1 = this.getText(option.getLowerBound());
            _builder_4.append(_text_1);
            _builder_4.append("`");
            _xifexpression_4 = _builder_4;
        }
        _builder_1.append(_xifexpression_4);
        _builder_1.newLineIfNotEmpty();
        StringConcatenation _xifexpression_5 = null;
        XExpression _upperBound = option.getUpperBound();
        boolean bl5 = _tripleNotEquals_3 = _upperBound != null;
        if (_tripleNotEquals_3) {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("*Upper Bound:* | `");
            String _text_2 = this.getText(option.getUpperBound());
            _builder_5.append(_text_2);
            _builder_5.append("`");
            _xifexpression_5 = _builder_5;
        }
        _builder_1.append(_xifexpression_5);
        _builder_1.newLineIfNotEmpty();
        String _xifexpression_6 = null;
        boolean _isEmpty_1 = option.getTargets().isEmpty();
        boolean bl6 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            Functions.Function1<MdOptionTargetType, String> _function_3 = new Functions.Function1<MdOptionTargetType, String>(){

                public String apply(MdOptionTargetType it) {
                    return it.getLiteral();
                }
            };
            String _join_2 = IterableExtensions.join((Iterable)ListExtensions.map(option.getTargets(), (Functions.Function1)_function_3), (CharSequence)", ");
            _xifexpression_6 = "*Applies To:* | " + _join_2;
        }
        _builder_1.append(_xifexpression_6);
        _builder_1.newLineIfNotEmpty();
        String _xifexpression_7 = null;
        boolean _isEmpty_2 = option.getLegacyIds().isEmpty();
        boolean bl7 = _not_2 = !_isEmpty_2;
        if (_not_2) {
            Functions.Function1<String, String> _function_4 = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    return "`" + it + "`";
                }
            };
            String _join_3 = IterableExtensions.join((Iterable)ListExtensions.map(option.getLegacyIds(), (Functions.Function1)_function_4), (CharSequence)", ");
            _xifexpression_7 = "*Legacy Id:* | " + _join_3;
        }
        _builder_1.append(_xifexpression_7);
        _builder_1.newLineIfNotEmpty();
        String _xifexpression_8 = null;
        boolean _isEmpty_3 = option.getDependencies().isEmpty();
        boolean bl8 = _not_3 = !_isEmpty_3;
        if (_not_3) {
            Functions.Function1<MdOptionDependency, String> _function_5 = new Functions.Function1<MdOptionDependency, String>(){

                public String apply(MdOptionDependency it) {
                    return MelkDocumentationGenerator.this.toOptionDocsString(it);
                }
            };
            String _join_4 = IterableExtensions.join((Iterable)ListExtensions.map(option.getDependencies(), (Functions.Function1)_function_5), (CharSequence)", ");
            _xifexpression_8 = "*Dependencies:* | " + _join_4;
        }
        _builder_1.append(_xifexpression_8);
        _builder_1.newLineIfNotEmpty();
        String _xifexpression_9 = null;
        boolean _isEmpty_4 = IterableExtensions.isEmpty(this.getGroups(option));
        boolean bl9 = _not_4 = !_isEmpty_4;
        if (_not_4) {
            Functions.Function1<MdGroup, String> _function_6 = new Functions.Function1<MdGroup, String>(){

                public String apply(MdGroup it) {
                    return MelkDocumentationGenerator.this.toOptionDocsString(it);
                }
            };
            String _join_5 = IterableExtensions.join((Iterable)IterableExtensions.map(this.getGroups(option), (Functions.Function1)_function_6), (CharSequence)" -> ");
            _xifexpression_9 = "*Containing Group:* | " + _join_5;
        }
        _builder_1.append(_xifexpression_9);
        _builder_1.newLineIfNotEmpty();
        String _xifexpression_10 = null;
        String _description = option.getDescription();
        boolean bl10 = _tripleNotEquals_4 = _description != null;
        if (_tripleNotEquals_4) {
            String _trimNewlineTabsAndReduceToSingleSpace = this.trimNewlineTabsAndReduceToSingleSpace(option.getDescription());
            _xifexpression_10 = "\n### Description\n\n" + _trimNewlineTabsAndReduceToSingleSpace;
        }
        _builder_1.append(_xifexpression_10);
        _builder_1.newLineIfNotEmpty();
        String _xifexpression_11 = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)additionalDoc);
        boolean bl11 = _not_5 = !_isNullOrEmpty;
        if (_not_5) {
            _xifexpression_11 = "\n## Additional Documentation\n\n" + additionalDoc;
        }
        _builder_1.append(_xifexpression_11);
        _builder_1.newLineIfNotEmpty();
        doc = String.valueOf(_doc) + _builder_1;
        return doc;
    }

    private String toOptionDocsString(MdOptionDependency dependency) {
        boolean _tripleNotEquals;
        String _qualifiedName = this.getQualifiedName(dependency.getTarget());
        String _plus = "[" + _qualifiedName;
        String _plus_1 = String.valueOf(_plus) + "]({{< relref \"reference/options/";
        String _hugoIdentifier = this.toHugoIdentifier(this.getQualifiedName(dependency.getTarget()));
        String _plus_2 = String.valueOf(_plus_1) + _hugoIdentifier;
        String result = String.valueOf(_plus_2) + ".md\" >}})";
        XExpression _value = dependency.getValue();
        boolean bl = _tripleNotEquals = _value != null;
        if (_tripleNotEquals) {
            String _result = result;
            String _text = this.getText(dependency.getValue());
            String _plus_3 = " (`" + _text;
            String _plus_4 = String.valueOf(_plus_3) + "`)";
            result = String.valueOf(_result) + _plus_4;
        }
        return result;
    }

    private String toOptionDocsString(MdGroup group) {
        String _name = group.getName();
        String _plus = "[" + _name;
        String _plus_1 = String.valueOf(_plus) + "]({{< relref \"reference/groups/";
        String _hugoIdentifier = this.toHugoIdentifier(this.getQualifiedName(group));
        String _plus_2 = String.valueOf(_plus_1) + _hugoIdentifier;
        return String.valueOf(_plus_2) + ".md\" >}})";
    }

    private String _generateDoc(MdGroup group) {
        boolean _tripleNotEquals;
        boolean _not_1;
        boolean _not;
        boolean _equals;
        Functions.Function1<MdGroup, String> _function = new Functions.Function1<MdGroup, String>(){

            public String apply(MdGroup it) {
                return it.getName();
            }
        };
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.getGroups(group), (Functions.Function1)_function), (CharSequence)".");
        StringBuffer title = new StringBuffer(_join);
        int _length = title.length();
        boolean bl = _equals = _length == 0;
        if (_equals) {
            title.append(group.getName());
        } else {
            title.append(".").append(group.getName());
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("---");
        _builder.newLine();
        _builder.append("title: \"");
        String _string = title.toString();
        _builder.append(_string);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("displayid: \"");
        String _qualifiedName = this.getQualifiedName(group);
        _builder.append(_qualifiedName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("menu:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("main:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("identifier: \"group-");
        String _hugoIdentifier = this.toHugoIdentifier(this.getQualifiedName(group));
        _builder.append(_hugoIdentifier, "    ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("parent: \"LayoutOptionGroups\"");
        _builder.newLine();
        _builder.append("---");
        _builder.newLine();
        _builder.newLine();
        _builder.append("Property | Value");
        _builder.newLine();
        _builder.append("-------- | -----");
        _builder.newLine();
        _builder.append("*Identifier:* | `");
        String _qualifiedName_1 = this.getQualifiedName(group);
        _builder.append(_qualifiedName_1);
        _builder.append("`");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _xifexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter(group.getChildren(), MdOption.class));
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            Functions.Function1<MdOption, String> _function_1 = new Functions.Function1<MdOption, String>(){

                public String apply(MdOption it) {
                    String _name;
                    String _elvis = null;
                    String _label = it.getLabel();
                    _elvis = _label != null ? _label : (_name = it.getName());
                    String _plus = "* [" + _elvis;
                    String _plus_1 = String.valueOf(_plus) + "]({{< relref \"reference/options/";
                    String _hugoIdentifier = MelkDocumentationGenerator.this.toHugoIdentifier(MelkDocumentationGenerator.this.getQualifiedName(it));
                    String _plus_2 = String.valueOf(_plus_1) + _hugoIdentifier;
                    return String.valueOf(_plus_2) + ".md\" >}})";
                }
            };
            String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)Iterables.filter(group.getChildren(), MdOption.class), (Functions.Function1)_function_1), (CharSequence)"\n");
            _xifexpression = "\n## Options\n\n" + _join_1;
        }
        _builder.append(_xifexpression);
        _builder.newLineIfNotEmpty();
        String _xifexpression_1 = null;
        boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)Iterables.filter(group.getChildren(), MdGroup.class));
        boolean bl3 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            Functions.Function1<MdGroup, String> _function_2 = new Functions.Function1<MdGroup, String>(){

                public String apply(MdGroup it) {
                    String _name = it.getName();
                    String _plus = "* [" + _name;
                    String _plus_1 = String.valueOf(_plus) + "]({{< relref \"reference/groups/";
                    String _hugoIdentifier = MelkDocumentationGenerator.this.toHugoIdentifier(MelkDocumentationGenerator.this.getQualifiedName(it));
                    String _plus_2 = String.valueOf(_plus_1) + _hugoIdentifier;
                    return String.valueOf(_plus_2) + ".md\" >}})";
                }
            };
            String _join_2 = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)Iterables.filter(group.getChildren(), MdGroup.class), (Functions.Function1)_function_2), (CharSequence)"\n");
            _xifexpression_1 = "\n## Subgroups\n\n" + _join_2;
        }
        _builder.append(_xifexpression_1);
        _builder.newLineIfNotEmpty();
        String _xifexpression_2 = null;
        String _documentation = group.getDocumentation();
        boolean bl4 = _tripleNotEquals = _documentation != null;
        if (_tripleNotEquals) {
            String _additionalDocumentation = this.additionalDocumentation(group.getDocumentation(), this.toHugoIdentifier(this.getQualifiedName(group)));
            _xifexpression_2 = "\n## Additional Documentation\n\n" + _additionalDocumentation;
        }
        _builder.append(_xifexpression_2);
        _builder.newLineIfNotEmpty();
        String doc = _builder.toString();
        return doc;
    }

    private String additionalDocumentation(String documentation, String fileNamePrefix) {
        boolean _not;
        if (documentation == null) {
            return "";
        }
        String doc = "";
        boolean _startsWith = documentation.startsWith("@");
        boolean bl = _not = !_startsWith;
        if (_not) {
            doc = this.trimNewlineTabsAndReduceToSingleSpace(documentation);
        } else {
            try {
                doc = ((AbstractFileSystemAccess2)this.fsa).readTextFile(this.projectDocumentationSourceFolder.resolve(documentation.substring(1)).toString(), MetaDataRuntimeModule.MelkOutputConfigurationProvider.AD_INPUT).toString();
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception exception = (Exception)_t;
                    exception.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        String res = "";
        int i = 0;
        int l = doc.length();
        while (i < l) {
            String _res = res;
            char _charAt = doc.charAt(i);
            res = String.valueOf(_res) + Character.valueOf(_charAt);
            ++i;
            boolean _endsWith = res.endsWith("![");
            if (!_endsWith) continue;
            while (i < l && !res.endsWith("](")) {
                String _res_1 = res;
                char _charAt_1 = doc.charAt(i);
                res = String.valueOf(_res_1) + Character.valueOf(_charAt_1);
                ++i;
            }
            res = res.substring(0, res.lastIndexOf("!["));
            String path = "";
            int openedParens = 1;
            while (i < l && openedParens > 0) {
                String _path = path;
                char _charAt_1 = doc.charAt(i);
                path = String.valueOf(_path) + Character.valueOf(_charAt_1);
                String _string = Character.valueOf(doc.charAt(++i)).toString();
                boolean _matched = false;
                if (Objects.equal((Object)_string, (Object)"(")) {
                    _matched = true;
                    ++openedParens;
                }
                if (_matched || !Objects.equal((Object)_string, (Object)")")) continue;
                _matched = true;
                --openedParens;
            }
            String imgTitle = "";
            boolean _endsWith_1 = (path = path.trim()).endsWith("\"");
            if (_endsWith_1) {
                String _plus;
                int _length = path.length();
                int _minus = _length - 2;
                String _substring = path.substring(path.lastIndexOf("\"", _minus));
                imgTitle = _plus = " " + _substring;
                int _length_1 = path.length();
                int _minus_1 = _length_1 - 2;
                path = path.substring(0, path.lastIndexOf("\"", _minus_1)).trim();
            }
            int _lastIndexOf = path.lastIndexOf("/");
            int _plus_1 = _lastIndexOf + 1;
            String _substring_1 = path.substring(_plus_1);
            String newFileName = String.valueOf(fileNamePrefix) + "_" + _substring_1;
            this.copyImageToOutputPath(this.projectDocumentationSourceFolder.resolve(path).toString(), newFileName);
            String _res_1 = res;
            res = String.valueOf(_res_1) + "{{< image src=\"" + newFileName + "\" alt=\"" + imgTitle + "\" gen=\"1\" >}}\n\n";
            ++i;
        }
        return res;
    }

    private String getQualifiedName(MdBundleMember member) {
        String _name;
        MdBundle bundle = this.getBundle(member);
        EObject _eContainer = bundle.eContainer();
        MdModel model = (MdModel)_eContainer;
        String _elvis = null;
        String _idPrefix = bundle.getIdPrefix();
        _elvis = _idPrefix != null ? _idPrefix : (_name = model.getName());
        String prefix = _elvis;
        boolean _endsWith = prefix.endsWith(member.getName());
        if (_endsWith) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        String _xifexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty(this.getGroups(member));
        _xifexpression = _isEmpty ? "" : ".";
        String _plus = String.valueOf(prefix) + _xifexpression;
        Functions.Function1<MdGroup, String> _function = new Functions.Function1<MdGroup, String>(){

            public String apply(MdGroup it) {
                return it.getName();
            }
        };
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.getGroups(member), (Functions.Function1)_function), (CharSequence)".");
        String _plus_1 = String.valueOf(_plus) + _join;
        String _plus_2 = String.valueOf(_plus_1) + ".";
        String _name_1 = member.getName();
        return String.valueOf(_plus_2) + _name_1;
    }

    private String toHugoIdentifier(String optionName) {
        boolean _endsWith = optionName.endsWith(".index");
        if (_endsWith) {
            return (String.valueOf(optionName) + "2").replace(".", "-");
        }
        return optionName.replace(".", "-");
    }

    private String getText(XExpression exp) {
        int _lastIndexOf;
        int _plus;
        if (exp == null) {
            return "<not defined>";
        }
        String text = NodeModelUtils.getNode((EObject)exp).getText().trim();
        String fName = text.substring(_plus = (_lastIndexOf = text.lastIndexOf(".")) + 1);
        if (Character.isLowerCase(fName.charAt(0)) && !Objects.equal((Object)fName, (Object)text) && !fName.endsWith(")")) {
            String _text = text;
            text = String.valueOf(_text) + "()";
        }
        return text;
    }

    private String trimNewlineTabsAndReduceToSingleSpace(String string) {
        return CharMatcher.breakingWhitespace().replaceFrom((CharSequence)string, (CharSequence)" ").replaceAll(" +", " ");
    }

    private Iterable<? extends JvmField> getPossibleValues(JvmTypeReference type) {
        if (type != null) {
            String _canonicalName;
            JvmType jvmType = type.getType();
            if (jvmType instanceof JvmEnumerationType) {
                JvmEnumerationType enumType = (JvmEnumerationType)jvmType;
                return enumType.getLiterals();
            }
            String _identifier = jvmType.getIdentifier();
            boolean _equals = Objects.equal((Object)_identifier, (Object)(_canonicalName = EnumSet.class.getCanonicalName()));
            if (_equals) {
                JvmType _type = ((JvmTypeReference)IterableExtensions.head((Iterable)((JvmParameterizedTypeReference)type).getArguments())).getType();
                JvmEnumerationType enumType_1 = (JvmEnumerationType)_type;
                return enumType_1.getLiterals();
            }
        }
        return null;
    }

    private Iterable<MdGroup> getAllGroupDefinitions(Iterable<? extends MdBundleMember> elements) {
        Iterable groups = Iterables.filter(elements, MdGroup.class);
        Functions.Function1<MdGroup, Iterable<MdGroup>> _function = new Functions.Function1<MdGroup, Iterable<MdGroup>>(){

            public Iterable<MdGroup> apply(MdGroup it) {
                return MelkDocumentationGenerator.this.getAllGroupDefinitions((Iterable<? extends MdBundleMember>)it.getChildren());
            }
        };
        return Iterables.concat((Iterable)groups, (Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)groups, (Functions.Function1)_function)));
    }

    private Iterable<MdOption> getAllOptionDefinitions(Iterable<? extends MdBundleMember> elements) {
        Functions.Function1<MdGroup, Iterable<MdOption>> _function = new Functions.Function1<MdGroup, Iterable<MdOption>>(){

            public Iterable<MdOption> apply(MdGroup it) {
                return MelkDocumentationGenerator.this.getAllOptionDefinitions((Iterable<? extends MdBundleMember>)it.getChildren());
            }
        };
        return Iterables.concat((Iterable)Iterables.filter(elements, MdOption.class), (Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(elements, MdGroup.class), (Functions.Function1)_function)));
    }

    private MdBundle getBundle(MdBundleMember member) {
        EObject parent = member.eContainer();
        while (!(parent instanceof MdBundle)) {
            parent = parent.eContainer();
        }
        return (MdBundle)parent;
    }

    private Iterable<MdGroup> getGroups(MdBundleMember member) {
        LinkedList<MdGroup> groups = new LinkedList<MdGroup>();
        EObject group = member.eContainer();
        while (group instanceof MdGroup) {
            groups.addFirst((MdGroup)group);
            group = ((MdGroup)group).eContainer();
        }
        return groups;
    }

    public void internalDoGenerate(EObject model, IFileSystemAccess fsa) {
        if (model instanceof JvmDeclaredType) {
            this._internalDoGenerate((JvmDeclaredType)model, fsa);
            return;
        }
        if (model instanceof MdModel) {
            this._internalDoGenerate((MdModel)model, fsa);
            return;
        }
        if (model != null) {
            this._internalDoGenerate(model, fsa);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(model, fsa).toString());
    }

    private String generateDoc(MdBundleMember group) {
        if (group instanceof MdGroup) {
            return this._generateDoc((MdGroup)group);
        }
        if (group instanceof MdOption) {
            return this._generateDoc((MdOption)group);
        }
        if (group instanceof MdAlgorithm) {
            return this._generateDoc((MdAlgorithm)group);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(group).toString());
    }
}

