/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.dnssd;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.util.ExtensionRegistryRunnable;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.provider.dnssd.ContainerInstantiator;
import org.eclipse.ecf.provider.dnssd.DnsSdDiscoveryAdvertiser;
import org.eclipse.ecf.provider.dnssd.DnsSdDiscoveryContainerAdapter;
import org.eclipse.ecf.provider.dnssd.DnsSdDiscoveryLocator;
import org.eclipse.ecf.provider.dnssd.DnsSdNamespace;
import org.eclipse.ecf.provider.dnssd.DnsSdServiceTypeID;
import org.eclipse.ecf.provider.dnssd.IDnsSdDiscoveryConstants;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.dnssd";
    public static final String DISCOVERY_CONTAINER_NAME_VALUE = "ecf.discovery.dnssd";
    public static final String LOCATOR = ".locator";
    public static final String ADVERTISER = ".advertiser";
    private static final String DISCOVERY_CONTAINER_NAME_KEY = "org.eclipse.ecf.discovery.containerName";
    private final Map serviceRegistrations = new HashMap();
    private volatile BundleContext context;

    public void start(final BundleContext context) throws Exception {
        this.context = context;
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(context){

            protected void runWithoutRegistry() throws Exception {
                context.registerService(Namespace.class, (Object)new DnsSdNamespace(), null);
                context.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.discovery.dnssd.locator", (IContainerInstantiator)new ContainerInstantiator(), "Discovery Locator Container"), null);
                context.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.discovery.dnssd.advertiser", (IContainerInstantiator)new ContainerInstantiator(), "Discovery Advertiser Container"), null);
            }
        });
        Hashtable<String, String> locCmProps = new Hashtable<String, String>();
        locCmProps.put("service.pid", "ecf.discovery.dnssd.locator");
        context.registerService(ManagedServiceFactory.class.getName(), (Object)new DnsSdManagedServiceFactory(DnsSdDiscoveryLocator.class), locCmProps);
        Hashtable<String, Object> locProps = new Hashtable<String, Object>();
        locProps.put(DISCOVERY_CONTAINER_NAME_KEY, "ecf.discovery.dnssd.locator");
        locProps.put("service.ranking", 750);
        this.serviceRegistrations.put(null, context.registerService(IDiscoveryLocator.class.getName(), (Object)new DnsSdServiceFactory(DnsSdDiscoveryLocator.class), locProps));
        Hashtable<String, String> advCmProps = new Hashtable<String, String>();
        advCmProps.put("service.pid", "ecf.discovery.dnssd.advertiser");
        context.registerService(ManagedServiceFactory.class.getName(), (Object)new DnsSdManagedServiceFactory(DnsSdDiscoveryAdvertiser.class), advCmProps);
        Hashtable<String, Object> advProps = new Hashtable<String, Object>();
        advProps.put(DISCOVERY_CONTAINER_NAME_KEY, "ecf.discovery.dnssd.advertiser");
        advProps.put("service.ranking", 750);
        this.serviceRegistrations.put(null, context.registerService(IDiscoveryAdvertiser.class.getName(), (Object)new DnsSdServiceFactory(DnsSdDiscoveryAdvertiser.class), advProps));
    }

    public void stop(BundleContext context) throws Exception {
        if (this.serviceRegistrations != null) {
            for (ServiceRegistration serviceRegistration : this.serviceRegistrations.values()) {
                this.disposeServiceRegistration(serviceRegistration);
            }
        }
        this.context = null;
    }

    private void disposeServiceRegistration(ServiceRegistration serviceRegistration) {
        ServiceReference reference = serviceRegistration.getReference();
        DnsSdDiscoveryContainerAdapter aContainer = (DnsSdDiscoveryContainerAdapter)((Object)this.context.getService(reference));
        serviceRegistration.unregister();
        IContainer container = (IContainer)aContainer.getAdapter(IContainer.class);
        container.dispose();
        container.disconnect();
    }

    private class DnsSdManagedServiceFactory
    implements ManagedServiceFactory {
        private final Class containerClass;

        public DnsSdManagedServiceFactory(Class aContainerClass) {
            this.containerClass = aContainerClass;
        }

        public String getName() {
            return this.getClass().getName();
        }

        public void updated(String pid, Dictionary properties) throws ConfigurationException {
            if (properties != null) {
                DnsSdDiscoveryContainerAdapter adapter = null;
                DnsSdServiceTypeID targetID = null;
                try {
                    String tsigKey;
                    String resolver;
                    ServiceRegistration serviceRegistration = (ServiceRegistration)Activator.this.serviceRegistrations.get(pid);
                    if (serviceRegistration != null) {
                        adapter = (DnsSdDiscoveryContainerAdapter)((Object)Activator.this.context.getService(serviceRegistration.getReference()));
                        targetID = (DnsSdServiceTypeID)adapter.getConnectedID();
                    } else {
                        adapter = (DnsSdDiscoveryContainerAdapter)((Object)this.containerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        targetID = new DnsSdServiceTypeID();
                    }
                    String[] searchPaths = (String[])properties.get("searchPath");
                    if (searchPaths != null) {
                        targetID.setSearchPath(searchPaths);
                    }
                    if ((resolver = (String)properties.get("resolver")) != null) {
                        adapter.setResolver(resolver);
                    }
                    if ((tsigKey = (String)properties.get("tsig-key")) != null) {
                        String tsigKeyName = (String)properties.get(IDnsSdDiscoveryConstants.CA_TSIG_KEY_NAME);
                        adapter.setTsigKey(tsigKeyName, tsigKey);
                    }
                    if (serviceRegistration == null) {
                        Hashtable<String, String> props = new Hashtable<String, String>();
                        props.put("service.pid", pid);
                        adapter.connect((ID)targetID, null);
                        Activator.this.serviceRegistrations.put(pid, Activator.this.context.registerService(IDiscoveryLocator.class.getName(), (Object)adapter, props));
                    }
                }
                catch (Exception e) {
                    throw new ConfigurationException("IDnsSdDiscoveryConstants properties", e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }

        public void deleted(String pid) {
            ServiceRegistration serviceRegistration = (ServiceRegistration)Activator.this.serviceRegistrations.get(pid);
            Activator.this.disposeServiceRegistration(serviceRegistration);
        }
    }

    public class DnsSdServiceFactory
    implements ServiceFactory {
        private volatile DnsSdDiscoveryContainerAdapter container;
        private final Class containerClass;

        public DnsSdServiceFactory(Class aDiscoveryContainerClass) {
            this.containerClass = aDiscoveryContainerClass;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            if (this.container == null) {
                try {
                    this.container = (DnsSdDiscoveryContainerAdapter)((Object)this.containerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    this.container.connect(null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.container = null;
                }
            }
            return this.container;
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

