/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.messages;

import ch.ethz.iks.r_osgi.messages.RemoteOSGiMessage;
import ch.ethz.iks.util.StringUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class DeliverServiceMessage
extends RemoteOSGiMessage {
    private String serviceID;
    private String[] serviceInterfaceNames;
    private String smartProxyName;
    private Map injections;
    private String imports;
    private String exports;
    private String optionalImports = "";

    public DeliverServiceMessage() {
        super((short)3);
    }

    DeliverServiceMessage(ObjectInputStream input) throws IOException {
        super((short)3);
        String[] imps;
        this.serviceID = input.readUTF();
        this.imports = input.readUTF();
        this.exports = input.readUTF();
        this.serviceInterfaceNames = DeliverServiceMessage.readStringArray(input);
        String p = input.readUTF();
        this.smartProxyName = "".equals(p) ? null : p;
        short blocks = input.readShort();
        this.injections = new HashMap(blocks);
        short i = 0;
        while (i < blocks) {
            this.injections.put(input.readUTF(), DeliverServiceMessage.readBytes(input));
            i = (short)(i + 1);
        }
        HashSet<String> set = new HashSet<String>();
        if (this.imports != null && (imps = StringUtils.stringToArray(this.imports, ",")) != null) {
            String[] stringArray = imps;
            int n = imps.length;
            int n2 = 0;
            while (n2 < n) {
                String imp = stringArray[n2];
                String[] opts = imp.split(";");
                if (opts != null && opts.length > 1) {
                    set.add(opts[0].trim());
                }
                ++n2;
            }
        }
        for (String className : this.injections.keySet()) {
            int lastIndexOf;
            String pkgName = className.substring(0, lastIndexOf = className.lastIndexOf("/")).replace('/', '.');
            if (set.contains(pkgName)) continue;
            set.add(pkgName);
            this.optionalImports = String.valueOf(this.optionalImports) + (this.optionalImports.length() > 0 ? ", " : "") + pkgName + ";resolution:=optional";
        }
    }

    @Override
    public void writeBody(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.serviceID);
        out.writeUTF(this.imports);
        out.writeUTF(this.exports);
        DeliverServiceMessage.writeStringArray(out, this.serviceInterfaceNames);
        out.writeUTF(this.smartProxyName == null ? "" : this.smartProxyName);
        short blocks = (short)this.injections.size();
        out.writeShort(blocks);
        String[] injectionNames = this.injections.keySet().toArray(new String[blocks]);
        short i = 0;
        while (i < blocks) {
            out.writeUTF(injectionNames[i]);
            DeliverServiceMessage.writeBytes(out, (byte[])this.injections.get(injectionNames[i]));
            i = (short)(i + 1);
        }
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public void setServiceID(String serviceID) {
        this.serviceID = serviceID;
    }

    public void setInjections(Map injections) {
        this.injections = injections;
    }

    public String[] getInterfaceNames() {
        return this.serviceInterfaceNames;
    }

    public void setInterfaceNames(String[] interfaceNames) {
        this.serviceInterfaceNames = interfaceNames;
    }

    public byte[] getInterfaceClass() {
        return (byte[])this.injections.get(String.valueOf(this.serviceInterfaceNames[0].replace('.', '/')) + ".class");
    }

    public String getSmartProxyName() {
        return this.smartProxyName;
    }

    public void setSmartProxyName(String smartProxyName) {
        this.smartProxyName = smartProxyName;
    }

    public byte[] getProxyClass() {
        if (this.smartProxyName == null) {
            return null;
        }
        return (byte[])this.injections.get(String.valueOf(this.smartProxyName.replace('.', '/')) + ".class");
    }

    public Map getInjections() {
        return this.injections;
    }

    public String getImports() {
        return this.imports;
    }

    public void setImports(String imports) {
        this.imports = imports;
    }

    public String getExports() {
        return this.exports;
    }

    public void setExports(String exports) {
        this.exports = exports;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DELIVER_SERVICE] - XID: ");
        buffer.append(this.xid);
        buffer.append(", serviceID: ");
        buffer.append(this.serviceID);
        buffer.append(", serviceInterfaceName: ");
        buffer.append(Arrays.asList(this.serviceInterfaceNames));
        if (this.smartProxyName != null) {
            buffer.append(" smartProxy: ");
            buffer.append(this.smartProxyName);
        }
        if (this.injections.size() > 0) {
            buffer.append(", classInjections ");
            buffer.append(this.injections.keySet());
        }
        return buffer.toString();
    }

    public String getOptionalImports() {
        return this.optionalImports;
    }
}

