/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery.internal.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.wst.server.discovery.internal.Messages;

public class ErrorWizardPage
extends WizardPage {
    private static final String NESTING_INDENT = "  ";
    private List list;
    protected String message;
    private IStatus status;
    private Clipboard clipboard;

    public ErrorWizardPage() {
        super("error-page");
        this.setTitle(Messages.wizExtensionTitle);
        this.setDescription(Messages.wizExtensionDescription);
    }

    public void createControl(Composite parent) {
        List control = this.createDropDownList(parent);
        this.setControl((Control)control);
    }

    public void setStatus(IStatus status) {
        if (this.status != status) {
            this.status = status;
        }
        this.setDescription(status.getMessage());
        if (this.list != null && !this.list.isDisposed()) {
            this.list.removeAll();
            this.populateList(this.list);
        }
    }

    protected List createDropDownList(Composite parent) {
        this.list = new List(parent, 2818);
        this.populateList(this.list);
        GridData data = new GridData(4, 4, false, false);
        data.widthHint = 225;
        this.list.setLayoutData((Object)data);
        this.list.setFont(parent.getFont());
        Menu copyMenu = new Menu((Control)this.list);
        MenuItem copyItem = new MenuItem(copyMenu, 0);
        copyItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ErrorWizardPage.this.copyToClipboard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ErrorWizardPage.this.copyToClipboard();
            }
        });
        copyItem.setText(JFaceResources.getString((String)"copy"));
        this.list.setMenu(copyMenu);
        return this.list;
    }

    protected void copyToClipboard() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        StringBuffer statusBuffer = new StringBuffer();
        this.populateCopyBuffer(this.status, statusBuffer, 0);
        this.clipboard = new Clipboard(this.list.getDisplay());
        this.clipboard.setContents(new Object[]{statusBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        super.dispose();
    }

    private void populateCopyBuffer(IStatus buildingStatus, StringBuffer buffer, int nesting) {
        int i = 0;
        while (i < nesting) {
            buffer.append(NESTING_INDENT);
            ++i;
        }
        buffer.append(buildingStatus.getMessage());
        buffer.append("\n");
        Throwable t = buildingStatus.getException();
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            this.populateCopyBuffer(ce.getStatus(), buffer, nesting + 1);
        } else if (t != null) {
            int i2 = 0;
            while (i2 < nesting) {
                buffer.append(NESTING_INDENT);
                ++i2;
            }
            String message = t.getLocalizedMessage();
            if (message == null) {
                message = t.toString();
            }
            buffer.append(message);
            buffer.append("\n");
        }
        IStatus[] children = buildingStatus.getChildren();
        int i3 = 0;
        while (i3 < children.length) {
            this.populateCopyBuffer(children[i3], buffer, nesting + 1);
            ++i3;
        }
    }

    private void populateList(List listToPopulate) {
        this.populateList(listToPopulate, this.status, 0, true);
    }

    private void populateList(List listToPopulate, IStatus buildingStatus, int nesting, boolean includeStatus) {
        String message;
        StringBuffer sb;
        Throwable t = buildingStatus.getException();
        boolean isCoreException = t instanceof CoreException;
        boolean incrementNesting = false;
        if (includeStatus) {
            sb = new StringBuffer();
            int i = 0;
            while (i < nesting) {
                sb.append(NESTING_INDENT);
                ++i;
            }
            message = buildingStatus.getMessage();
            sb.append(message);
            listToPopulate.add(sb.toString());
            incrementNesting = true;
        }
        if (!isCoreException && t != null) {
            sb = new StringBuffer();
            int i = 0;
            while (i < nesting) {
                sb.append(NESTING_INDENT);
                ++i;
            }
            message = t.getLocalizedMessage();
            if (message == null) {
                message = t.toString();
            }
            sb.append(message);
            listToPopulate.add(sb.toString());
            incrementNesting = true;
        }
        if (incrementNesting) {
            ++nesting;
        }
        if (isCoreException) {
            CoreException ce = (CoreException)t;
            IStatus eStatus = ce.getStatus();
            if (this.message == null || this.message.indexOf(eStatus.getMessage()) == -1) {
                this.populateList(listToPopulate, eStatus, nesting, true);
            }
        }
        IStatus[] children = buildingStatus.getChildren();
        int i = 0;
        while (i < children.length) {
            this.populateList(listToPopulate, children[i], nesting, true);
            ++i;
        }
    }
}

