/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model.ui;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableTitleAreaDialog;
import org.eclipse.wb.internal.swing.MigLayout.Activator;
import org.eclipse.wb.internal.swing.MigLayout.model.MigDimensionInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ModelMessages;

abstract class DimensionsDialog<T extends MigDimensionInfo>
extends ResizableTitleAreaDialog {
    protected final MigLayoutInfo m_layout;
    private final List<T> m_dimensions2;
    private TableViewer m_viewer;
    private Button m_editButton;
    private Button m_removeButton;
    private Button m_moveUpButton;
    private Button m_moveDownButton;

    public DimensionsDialog(Shell parentShell, MigLayoutInfo layout, List<T> dimensions) {
        super(parentShell, (AbstractUIPlugin)Activator.getDefault());
        this.setShellStyle(67696);
        this.m_layout = layout;
        this.m_dimensions2 = dimensions;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridDataFactory.create((Control)container).grab().fill();
        GridLayoutFactory.create((Composite)container).columns(2);
        Label label = new Label(container, 0);
        GridDataFactory.create((Control)label).spanH(2);
        label.setText(this.getViewerTitle());
        this.createViewer(container);
        this.createButtonsComposite(container);
        this.updateButtons();
        this.setTitle(this.getDialogTitle());
        this.setMessage(this.getDialogMessage());
        return area;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, false);
    }

    private void createViewer(Composite container) {
        this.m_viewer = new TableViewer(container, 67586);
        Table table = this.m_viewer.getTable();
        GridDataFactory.create((Control)table).hintC(60, 15).grab().fill();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumn(ModelMessages.DimensionsDialog_columnNumber, 5);
        this.createColumn(ModelMessages.DimensionsDialog_columnSpecification, 65);
        this.m_viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new DimensionsLabelProvider());
        this.m_viewer.setInput(this.m_dimensions2);
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DimensionsDialog.this.updateButtons();
            }
        });
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DimensionsDialog.this.editSelectedDimension();
            }
        });
        if (!this.m_dimensions2.isEmpty()) {
            this.m_viewer.getTable().setSelection(0);
        }
    }

    private void createColumn(String text, int widthInChars) {
        TableColumn column = new TableColumn(this.m_viewer.getTable(), 0);
        column.setText(text);
        column.setWidth(this.convertWidthInCharsToPixels(widthInChars));
    }

    private void createButtonsComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.create((Control)composite).fill();
        GridLayoutFactory.create((Composite)composite).marginsV(0);
        DimensionsDialog.createButton(composite, ModelMessages.DimensionsDialog_insertButton, new Listener(){

            public void handleEvent(Event event) {
                DimensionsDialog.this.addNewDimension(0);
            }
        });
        DimensionsDialog.createButton(composite, ModelMessages.DimensionsDialog_appendButton, new Listener(){

            public void handleEvent(Event event) {
                DimensionsDialog.this.addNewDimension(1);
            }
        });
        this.m_editButton = DimensionsDialog.createButton(composite, ModelMessages.DimensionsDialog_editButton, new Listener(){

            public void handleEvent(Event event) {
                DimensionsDialog.this.editSelectedDimension();
            }
        });
        this.m_removeButton = DimensionsDialog.createButton(composite, ModelMessages.DimensionsDialog_removeButton, new Listener(){

            public void handleEvent(Event event) {
                final AtomicInteger lastIndex = new AtomicInteger();
                DimensionsDialog.this.applyChanges(new RunnableEx(){

                    public void run() throws Exception {
                        Iterable selectedDimensions = GenericsUtils.iterable((ISelection)(this).DimensionsDialog.this.m_viewer.getSelection());
                        for (MigDimensionInfo dimension : selectedDimensions) {
                            lastIndex.set(dimension.getIndex());
                            dimension.delete();
                        }
                    }
                });
                int index = lastIndex.get();
                index = Math.min(index, DimensionsDialog.this.m_dimensions2.size() - 1);
                DimensionsDialog.this.m_viewer.getTable().select(index);
                DimensionsDialog.this.updateButtons();
            }
        });
        new Label(composite, 0);
        this.m_moveUpButton = DimensionsDialog.createButton(composite, ModelMessages.DimensionsDialog_moveUpButton, new Listener(){

            public void handleEvent(Event event) {
                DimensionsDialog.this.applyChanges(new RunnableEx(){

                    public void run() throws Exception {
                        Iterable selectedDimensions = GenericsUtils.iterable((ISelection)(this).DimensionsDialog.this.m_viewer.getSelection());
                        DimensionsDialog.this.moveDimensionsUp(selectedDimensions);
                    }
                });
                DimensionsDialog.this.updateButtons();
            }
        });
        this.m_moveDownButton = DimensionsDialog.createButton(composite, ModelMessages.DimensionsDialog_moveDownButton, new Listener(){

            public void handleEvent(Event event) {
                DimensionsDialog.this.applyChanges(new RunnableEx(){

                    public void run() throws Exception {
                        Iterable selectedDimensions = GenericsUtils.iterable((ISelection)(this).DimensionsDialog.this.m_viewer.getSelection());
                        DimensionsDialog.this.moveDimensionsDown(selectedDimensions);
                    }
                });
                DimensionsDialog.this.updateButtons();
            }
        });
    }

    private static Button createButton(Composite parent, String text, Listener listener) {
        Button button = new Button(parent, 0);
        GridDataFactory.create((Control)button).grabH().fillH();
        button.setText(text);
        button.addListener(13, listener);
        return button;
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.m_viewer.getSelection();
        boolean empty = selection.isEmpty();
        this.m_editButton.setEnabled(selection.size() == 1);
        this.m_removeButton.setEnabled(!empty);
        this.m_moveUpButton.setEnabled(!empty);
        this.m_moveDownButton.setEnabled(!empty);
        for (MigDimensionInfo dimension : GenericsUtils.iterable((ISelection)selection)) {
            int index = dimension.getIndex();
            if (index == 0) {
                this.m_moveUpButton.setEnabled(false);
            }
            if (index != this.m_dimensions2.size() - 1) continue;
            this.m_moveDownButton.setEnabled(false);
        }
    }

    private void addNewDimension(int indexOffset) {
        final int index = this.addNewDimension_getIndex(indexOffset);
        this.applyChanges(new RunnableEx(){

            public void run() throws Exception {
                DimensionsDialog.this.createNewDimension(index);
            }
        });
        this.m_viewer.getTable().setSelection(index);
        this.editSelectedDimension();
    }

    private int addNewDimension_getIndex(int indexOffset) {
        int index = this.m_viewer.getTable().getSelectionIndex();
        if (index == -1) {
            return this.m_dimensions2.size();
        }
        return index + indexOffset;
    }

    private void editSelectedDimension() {
        MigDimensionInfo dimension = (MigDimensionInfo)GenericsUtils.first((ISelection)this.m_viewer.getSelection());
        this.editSelectedDimension(dimension);
        this.applyChanges(new RunnableEx(){

            public void run() throws Exception {
            }
        });
    }

    private void applyChanges(final RunnableEx runnable) {
        ExecutionUtils.run((ObjectInfo)this.m_layout, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                runnable.run();
                DimensionsDialog.this.m_layout.writeDimensions();
            }
        });
        this.m_viewer.refresh();
    }

    protected abstract String getDialogTitle();

    protected abstract String getDialogMessage();

    protected abstract String getViewerTitle();

    protected abstract void moveDimensionsUp(Iterable<T> var1) throws Exception;

    protected abstract void moveDimensionsDown(Iterable<T> var1) throws Exception;

    protected abstract boolean editSelectedDimension(T var1);

    protected abstract T createNewDimension(int var1) throws Exception;

    private class DimensionsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DimensionsLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            MigDimensionInfo dimension = (MigDimensionInfo)element;
            if (columnIndex == 0) {
                return "" + dimension.getIndex();
            }
            if (columnIndex == 1) {
                return dimension.getString(false);
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

