/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.part;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.core.gef.command.CompoundEditCommand;
import org.eclipse.wb.core.gef.policy.selection.NonResizableSelectionEditPolicy;
import org.eclipse.wb.core.gef.policy.selection.TopSelectionEditPolicy;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.DisplayEventListener;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.core.requests.DragPermissionRequest;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.gef.policy.OpenErrorLogEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.OpenListenerEditPolicy;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.draw2d.EventManager;
import org.eclipse.wb.internal.gef.core.IObjectInfoEditPart;

public abstract class AbstractComponentEditPart
extends GraphicalEditPart
implements IObjectInfoEditPart {
    public static final Point TOP_LOCATION = EnvironmentUtils.IS_MAC ? new Point(20, 28) : new Point(20, 20);
    private final AbstractComponentInfo m_component;

    public AbstractComponentEditPart(AbstractComponentInfo component) {
        this.m_component = component;
        this.setModel((Object)this.m_component);
        this.listenFor_delayEvents();
    }

    public final AbstractComponentInfo getComponent() {
        return this.m_component;
    }

    protected IFigure createFigure() {
        return new Figure(){

            protected void paintClientArea(Graphics graphics) {
                if (AbstractComponentEditPart.this.m_component.isRoot()) {
                    Image image = AbstractComponentEditPart.this.m_component.getImage();
                    graphics.drawImage(image, 0, 0);
                }
                AbstractComponentEditPart.this.drawCustomBorder((IFigure)this, graphics);
            }
        };
    }

    protected void drawCustomBorder(IFigure figure, Graphics graphics) {
    }

    protected void refreshVisuals() {
        Rectangle bounds = this.m_component.getBounds();
        if (this.m_component.isRoot()) {
            Point rootLocation = this.getRootLocation();
            bounds = bounds.getCopy().setLocation(rootLocation);
        }
        if (bounds == null) {
            bounds = new Rectangle(0, 0, 0, 0);
        }
        this.getFigure().setBounds(bounds);
    }

    protected Point getRootLocation() {
        return TOP_LOCATION;
    }

    protected void createEditPolicies() {
        if (this.m_component.isRoot()) {
            this.installEditPolicy("Selection Feedback", (EditPolicy)new TopSelectionEditPolicy(this.m_component));
        } else {
            this.installEditPolicy("Selection Feedback", (EditPolicy)new NonResizableSelectionEditPolicy());
        }
        this.installEditPolicy((EditPolicy)new OpenListenerEditPolicy(this.m_component));
        OpenErrorLogEditPolicy.install(this);
        this.refreshEditPolicies();
    }

    protected void refreshEditPolicies() {
        OpenErrorLogEditPolicy.refresh(this);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof SelectionRequest && JavaInfoUtils.hasTrueParameter(this.m_component, "GEF.clickToParent")) {
            return this.getParent().getTargetEditPart(request);
        }
        return super.getTargetEditPart(request);
    }

    public void performRequest(Request request) {
        super.performRequest(request);
        if (request instanceof DragPermissionRequest) {
            DragPermissionRequest permissionRequest = (DragPermissionRequest)request;
            permissionRequest.setMove(JavaInfoUtils.canMove(this.m_component));
            permissionRequest.setReparent(JavaInfoUtils.canReparent(this.m_component));
        }
    }

    public CompoundCommand createCompoundCommand() {
        return new CompoundEditCommand((ObjectInfo)this.m_component);
    }

    public void refresh() {
        this.refreshEditPolicies();
        super.refresh();
    }

    protected List<?> getModelChildren() {
        return (List)ExecutionUtils.runObjectLog(() -> this.m_component.getPresentation().getChildrenGraphical(), Collections.emptyList());
    }

    private void listenFor_delayEvents() {
        if (this.m_component.isRoot()) {
            this.m_component.addBroadcastListener(new DisplayEventListener(){
                private int m_level = 0;

                public void beforeMessagesLoop() {
                    if (this.isEnabled()) {
                        ++this.m_level;
                        if (this.m_level == 1) {
                            this.delayEvents(true);
                        }
                    }
                }

                public void afterMessagesLoop() {
                    if (this.isEnabled()) {
                        --this.m_level;
                        if (this.m_level == 0) {
                            this.delayEvents(false);
                            this.runDelayedEvents();
                        }
                    }
                }

                private boolean isEnabled() {
                    if (!AbstractComponentEditPart.this.isActive()) {
                        return false;
                    }
                    return !AbstractComponentEditPart.this.getViewer().getControl().isDisposed();
                }

                private void delayEvents(boolean delay) {
                    Control viewerControl = AbstractComponentEditPart.this.getViewer().getControl();
                    EventManager.delayEvents((Control)viewerControl, (boolean)delay);
                }

                private void runDelayedEvents() {
                    ExecutionUtils.runLogLater((RunnableEx)new RunnableEx(){

                        public void run() throws Exception {
                            if (this.isEnabled()) {
                                Control viewerControl = AbstractComponentEditPart.this.getViewer().getControl();
                                EventManager.runDelayedEvents((Control)viewerControl);
                            }
                        }
                    });
                }
            });
        }
    }
}

