/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.model;

import java.time.Duration;
import java.time.Instant;
import org.eclipse.core.runtime.Assert;
import org.eclipse.unittest.internal.model.ProgressState;
import org.eclipse.unittest.internal.model.Status;
import org.eclipse.unittest.internal.model.TestRunSession;
import org.eclipse.unittest.internal.model.TestSuiteElement;
import org.eclipse.unittest.model.ITestElement;

public abstract class TestElement
implements ITestElement {
    private final TestSuiteElement fParent;
    private final String fId;
    private final String fTestName;
    private final String fData;
    private final String fDisplayName;
    private Status fStatus;
    protected ITestElement.FailureTrace fTrace;
    private boolean fAssumptionFailed;
    protected Instant testStartedInstant = null;
    protected Duration fDuration = null;

    public TestElement(TestSuiteElement parent, String id, String testName, String displayName, String data) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)testName);
        this.fParent = parent;
        this.fId = id;
        this.fTestName = testName;
        this.fDisplayName = displayName;
        this.fData = data;
        this.fStatus = Status.NOT_RUN;
        if (parent != null) {
            parent.addChild(this);
        } else if (!(this instanceof TestRunSession)) {
            throw new IllegalArgumentException("Test elements must have a parent");
        }
    }

    public ProgressState getProgressState() {
        return this.getStatus().convertToProgressState();
    }

    public ITestElement.Result getTestResult(boolean includeChildren) {
        if (this.fAssumptionFailed) {
            return ITestElement.Result.IGNORED;
        }
        return this.getStatus().convertToResult();
    }

    public TestSuiteElement getParentContainer() {
        return this.fParent;
    }

    @Override
    public ITestElement.FailureTrace getFailureTrace() {
        ITestElement.Result testResult = this.getTestResult(false);
        if (testResult == ITestElement.Result.ERROR || testResult == ITestElement.Result.FAILURE || testResult == ITestElement.Result.IGNORED && this.fTrace != null) {
            return this.fTrace;
        }
        return null;
    }

    @Override
    public TestSuiteElement getParent() {
        return this.fParent;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getTestName() {
        return this.fTestName;
    }

    public void setStatus(Status status) {
        if (status == Status.RUNNING) {
            this.testStartedInstant = Instant.now();
        } else if (status.convertToProgressState() == ProgressState.COMPLETED && this.testStartedInstant != null) {
            this.fDuration = Duration.between(this.testStartedInstant, Instant.now());
        }
        this.fStatus = status;
        TestSuiteElement parent = this.getParent();
        if (parent != null) {
            parent.childChangedStatus(this, status);
        }
    }

    public void setStatus(Status status, ITestElement.FailureTrace failureTrace) {
        this.fTrace = failureTrace != null && this.fTrace != null ? new ITestElement.FailureTrace(this.fTrace.getTrace() + failureTrace.getTrace(), this.fTrace.getExpected(), this.fTrace.getActual()) : failureTrace;
        this.setStatus(status);
    }

    public Status getStatus() {
        return this.fStatus;
    }

    public void setDuration(Duration duration) {
        this.fDuration = duration;
    }

    @Override
    public Duration getDuration() {
        return this.fDuration;
    }

    public void setAssumptionFailed(boolean assumptionFailed) {
        this.fAssumptionFailed = assumptionFailed;
    }

    public boolean isAssumptionFailure() {
        return this.fAssumptionFailed;
    }

    public String toString() {
        return this.getTestName() + "[" + String.valueOf((Object)this.getProgressState()) + " - " + String.valueOf((Object)this.getTestResult(true)) + "]";
    }

    @Override
    public String getDisplayName() {
        return this.fDisplayName != null ? this.fDisplayName : this.getTestName();
    }

    @Override
    public String getData() {
        return this.fData;
    }

    @Override
    public TestRunSession getTestRunSession() {
        return this.getParent().getTestRunSession();
    }

    abstract Integer getFinalTestCaseCount();

    abstract int countStartedTestCases();

    abstract int getCurrentFailureCount();

    abstract int getCurrentAssumptionFailureCount();

    abstract int getCurrentIgnoredCount();

    abstract int getCurrentErrorCount();
}

