/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.session;

import java.lang.ref.WeakReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IMemento;

public class SessionEditorInput
extends URIEditorInput {
    private static final String SESSION_RESOURCE_URI = "SESSION_RESOURCE_URI";
    private static final String REP_DESC_URI = "REP_DESC_URI";
    private WeakReference<Session> sessionRef;
    private String name;
    private URI sessionResourceURI;
    private WeakReference<EObject> inputRef;
    private IStatus status;
    private URI repDescURI;

    public SessionEditorInput(URI uri, String name, Session session) {
        super(uri, name);
        this.name = name;
        this.sessionRef = new WeakReference<Session>(session);
        if (session.getSessionResource() != null) {
            this.sessionResourceURI = session.getSessionResource().getURI();
        }
    }

    public SessionEditorInput(URI uri, URI repDescURI, String name, Session session) {
        this(uri, name, session);
        this.repDescURI = repDescURI;
    }

    public SessionEditorInput(IMemento memento) {
        super(memento);
    }

    public Session getSession() {
        return this.getSession(true);
    }

    public Session getSession(boolean restore) {
        Session session;
        Session session2 = session = this.sessionRef != null ? (Session)this.sessionRef.get() : null;
        if (session == null || !session.isOpen() && !Messages.SessionEditorInput_defaultEditorName.equals(this.name)) {
            URI sessionModelURI = this.getURI().trimFragment();
            if (this.sessionResourceURI != null) {
                sessionModelURI = this.sessionResourceURI;
            }
            if ((session = this.getSession(sessionModelURI, restore)) != null) {
                this.sessionRef = new WeakReference<Session>(session);
            }
        }
        return session;
    }

    public EObject getInput() {
        return this.getInput(true);
    }

    private EObject getInput(boolean restore) {
        Session session;
        EObject input;
        EObject eObject = input = this.inputRef != null ? (EObject)this.inputRef.get() : null;
        if (input == null && (session = this.getSession(restore)) != null && session.isOpen() && this.getURI().hasFragment() && (input = session.getTransactionalEditingDomain().getResourceSet().getEObject(this.getURI(), false)) != null) {
            this.inputRef = new WeakReference<EObject>(input);
        }
        return input;
    }

    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    public URI getRepDescUri() {
        return this.repDescURI;
    }

    public void setRepDescURI(URI repDescURI) {
        this.repDescURI = repDescURI;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("uri", this.getURI().toString());
        memento.putString("name", this.getName());
        memento.putString("class", ((Object)((Object)this)).getClass().getName());
        if (this.sessionResourceURI != null) {
            memento.putString(SESSION_RESOURCE_URI, this.sessionResourceURI.toString());
        }
        if (this.repDescURI != null) {
            memento.putString(REP_DESC_URI, this.repDescURI.toString());
        }
    }

    protected void loadState(IMemento memento) {
        super.loadState(memento);
        this.setName(memento.getString("name"));
        String sessionResourceURIString = memento.getString(SESSION_RESOURCE_URI);
        String repDescURIString = memento.getString(REP_DESC_URI);
        if (sessionResourceURIString != null) {
            this.sessionResourceURI = URI.createURI((String)sessionResourceURIString);
            Session newSession = this.getSession(this.sessionResourceURI);
            if (newSession != null) {
                this.sessionRef = new WeakReference<Session>(newSession);
            }
        }
        if (repDescURIString != null) {
            this.repDescURI = URI.createURI((String)repDescURIString);
        }
    }

    protected Session getSession(URI sessionModelURI) {
        return this.getSession(sessionModelURI, true);
    }

    private Session getSession(URI sessionModelURI, boolean restore) {
        Session sessionFromURI;
        try {
            sessionFromURI = SessionManager.INSTANCE.getExistingSession(sessionModelURI);
            if (sessionFromURI == null && restore) {
                this.status = Status.OK_STATUS;
            }
            sessionFromURI = SessionEditorInput.openSession(sessionModelURI, restore, sessionFromURI);
        }
        catch (OperationCanceledException e) {
            sessionFromURI = null;
            this.status = new Status(8, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            sessionFromURI = null;
            this.status = new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e);
        }
        return sessionFromURI;
    }

    private static Session openSession(URI sessionModelURI, boolean restore, Session sessionFromURI) {
        Session session = sessionFromURI;
        if (session == null && restore) {
            session = SessionManager.INSTANCE.openSession(sessionModelURI, (IProgressMonitor)new NullProgressMonitor(), SiriusEditPlugin.getPlugin().getUiCallback(), true);
        }
        if (session != null && session.isOpen()) {
            IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(session);
            if (uiSession == null && restore) {
                uiSession = SessionUIManager.INSTANCE.getOrCreateUISession(session);
            }
            if (uiSession != null && !uiSession.isOpen()) {
                uiSession.open();
            }
        }
        return session;
    }

    protected String getBundleSymbolicName() {
        return SiriusEditPlugin.getPlugin().getSymbolicName();
    }

    public String getFactoryId() {
        return "org.eclipse.sirius.ui.business.api.session.SessionEditorInputFactory";
    }

    public static SessionEditorInput create(URI sessionResourceURI) {
        Session session = SessionManager.INSTANCE.getExistingSession(sessionResourceURI);
        if (session == null) {
            session = SessionEditorInput.openSession(sessionResourceURI, true, null);
        }
        return new SessionEditorInput(sessionResourceURI, Messages.SessionEditorInput_defaultEditorName, session);
    }

    public String getToolTipText() {
        return this.getURI().trimFragment().toString() + "/" + this.getName();
    }

    @Deprecated
    public void dispose() {
    }

    public URI getURI() {
        EObject input;
        EObject eObject = input = this.inputRef != null ? (EObject)this.inputRef.get() : null;
        if (input != null) {
            try {
                return EcoreUtil.getURI((EObject)input);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return super.getURI();
    }

    public boolean exists() {
        Resource resource;
        EObject input;
        boolean exists = super.exists();
        if (!exists && (input = this.getInput(false)) != null && !input.eIsProxy() && (resource = input.eResource()) != null && resource.getResourceSet() != null) {
            exists = resource.getResourceSet().getURIConverter().exists(resource.getURI(), null);
        }
        return exists;
    }

    public IStatus getStatus() {
        if (this.status == null) {
            this.status = Status.OK_STATUS;
        }
        return this.status;
    }

    public Object getAdapter(Class adapter) {
        Object a = super.getAdapter(adapter);
        if (IFile.class == adapter && a == null && EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
            Session inputSession = this.getSession(false);
            if (inputSession != null && inputSession.isOpen()) {
                a = URIEditorInput.EclipseUtil.getAdapter((Class)adapter, (URI)inputSession.getSessionResource().getURI());
            } else if (this.sessionResourceURI != null) {
                a = URIEditorInput.EclipseUtil.getAdapter((Class)adapter, (URI)this.sessionResourceURI);
            }
        }
        return a;
    }

    public int hashCode() {
        EObject input = this.getInput(false);
        if (input != null) {
            return input.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        boolean equals;
        boolean bl = equals = this == o || o instanceof SessionEditorInput && this.getURI().equals(((SessionEditorInput)((Object)o)).getURI());
        if (equals && o instanceof SessionEditorInput) {
            SessionEditorInput otherSessionEditorInput = (SessionEditorInput)((Object)o);
            IStatus otherStatus = otherSessionEditorInput.getStatus();
            if (this.getStatus() != otherStatus) {
                equals = false;
            } else {
                EObject input = this.getInput(false);
                if (input != null) {
                    equals = input.equals(otherSessionEditorInput.getInput(false));
                }
            }
        }
        return equals;
    }
}

