/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.php.internal.server.core.builtin.IPHPServerRunner;
import org.eclipse.php.internal.server.core.builtin.Messages;

public abstract class AbstractPHPServerRunner
implements IPHPServerRunner {
    protected Process exec(String[] cmdLine, File workingDirectory) throws CoreException {
        cmdLine = AbstractPHPServerRunner.quoteWindowsArgs(cmdLine);
        return DebugPlugin.exec((String[])cmdLine, (File)workingDirectory);
    }

    protected Process exec(String[] cmdLine, File workingDirectory, String[] envp) throws CoreException {
        cmdLine = AbstractPHPServerRunner.quoteWindowsArgs(cmdLine);
        return DebugPlugin.exec((String[])cmdLine, (File)workingDirectory, (String[])envp);
    }

    private static String[] quoteWindowsArgs(String[] cmdLine) {
        if (Platform.getOS().equals("win32")) {
            String[] winCmdLine = new String[cmdLine.length];
            if (cmdLine.length > 0) {
                winCmdLine[0] = cmdLine[0];
            }
            int i = 1;
            while (i < cmdLine.length) {
                winCmdLine[i] = AbstractPHPServerRunner.winQuote(cmdLine[i]);
                ++i;
            }
            cmdLine = winCmdLine;
        }
        return cmdLine;
    }

    private static boolean needsQuoting(String s) {
        int len = s.length();
        if (len == 0) {
            return true;
        }
        if ("\"\"".equals(s)) {
            return false;
        }
        int i = 0;
        while (i < len) {
            switch (s.charAt(i)) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '\\': {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static String winQuote(String s) {
        if (!AbstractPHPServerRunner.needsQuoting(s)) {
            return s;
        }
        s = s.replaceAll("([\\\\]*)\"", "$1$1\\\\\"");
        s = s.replaceAll("([\\\\]*)\\z", "$1$1");
        return "\"" + s + "\"";
    }

    protected String getCmdLineAsString(String[] cmdLine) {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        int numStrings = cmdLine.length;
        while (i < numStrings) {
            buff.append(cmdLine[i]);
            buff.append(' ');
            ++i;
        }
        return buff.toString().trim();
    }

    protected String renderCommandLine(String[] commandLine) {
        return DebugPlugin.renderArguments((String[])commandLine, null);
    }

    protected IProcess newProcess(ILaunch launch, Process p, String label, Map<String, String> attributes) throws CoreException {
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)label, attributes);
        if (process == null) {
            p.destroy();
            this.abort(Messages.AbstractPHPServerRunner_0, null, 1);
        }
        return process;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.php.server.core", code, message, exception));
    }

    protected Map<String, String> getDefaultProcessMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(IProcess.ATTR_PROCESS_TYPE, "php");
        return map;
    }
}

