/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.runner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.m2m.atl.adt.runner.ATLProperties;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;

public class CreateRunnableData {
    private static final String[] NON_LAUNCHER_OPTIONS = new String[]{"OPTION_DERIVED", "OPTION_CLEAR"};
    private IFile[] transformationFiles;
    private String fileType;
    private boolean isRefining;
    private Map<String, String> inModels;
    private Map<String, String> inOutModels;
    private Map<String, String> outModels;
    private Map<String, String> metamodelLocations;
    private Map<String, String> libraryLocations;
    private Map<String, String> options;
    private Set<String> libraryNames;
    private String classShortName;

    public void load(String ... filePaths) throws IOException, CoreException {
        ArrayList<IFile> atlModules = new ArrayList<IFile>();
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            IFile file = CreateRunnableData.getFile(filePath);
            if (file != null) {
                atlModules.add(file);
            }
            ++n2;
        }
        this.transformationFiles = atlModules.toArray(new IFile[atlModules.size()]);
        this.updateFromFiles();
    }

    public void load(ATLProperties properties) throws IOException, CoreException {
        this.transformationFiles = properties.getTransformationFiles();
        this.updateFromFiles();
        this.libraryLocations.putAll(properties.getLibraryLocations());
        this.metamodelLocations.putAll(properties.getMetamodelLocations());
        this.options.putAll(properties.getOptions());
    }

    public void load(ILaunchConfiguration configuration) throws IOException, CoreException {
        IFile mainFile;
        String mainModulePath = configuration.getAttribute("ATL File Name", "<null>");
        List superimposedModulesPaths = configuration.getAttribute("Superimpose", Collections.EMPTY_LIST);
        ArrayList<IFile> atlModules = new ArrayList<IFile>();
        if (mainModulePath != null && !"".equals(mainModulePath) && (mainFile = CreateRunnableData.getFile(mainModulePath)) != null) {
            atlModules.add(mainFile);
            for (String path : superimposedModulesPaths) {
                IFile file = CreateRunnableData.getFile(path);
                if (file == null) continue;
                atlModules.add(file);
            }
        }
        this.transformationFiles = atlModules.toArray(new IFile[atlModules.size()]);
        this.updateFromFiles();
        Map launchConfigOptions = configuration.getAttribute("Options", Collections.EMPTY_MAP);
        for (Object optionName : launchConfigOptions.keySet()) {
            if (Arrays.asList(NON_LAUNCHER_OPTIONS).contains(optionName)) continue;
            this.options.put(optionName.toString(), launchConfigOptions.get(optionName).toString());
        }
        Map launchConfigLibraryPaths = configuration.getAttribute("Libs", Collections.EMPTY_MAP);
        Map<String, String> libraryPaths = CreateRunnableData.convertLocations(launchConfigLibraryPaths);
        for (String libraryName : this.getAllLibrariesNames()) {
            this.libraryLocations.put(libraryName, libraryPaths.get(libraryName));
        }
        Map launchConfigModelPaths = configuration.getAttribute("Path", Collections.EMPTY_MAP);
        Map<String, String> modelPaths = CreateRunnableData.convertLocations(launchConfigModelPaths);
        for (String metamodelName : this.getAllMetamodelsNames()) {
            this.metamodelLocations.put(metamodelName, modelPaths.get(metamodelName));
        }
    }

    public Object getClassShortName() {
        return this.classShortName;
    }

    private void updateFromFiles() throws IOException, CoreException {
        this.inModels = new LinkedHashMap<String, String>();
        this.inOutModels = new LinkedHashMap<String, String>();
        this.outModels = new LinkedHashMap<String, String>();
        this.libraryNames = new LinkedHashSet<String>();
        if (this.libraryLocations == null) {
            this.libraryLocations = new HashMap<String, String>();
        }
        if (this.metamodelLocations == null) {
            this.metamodelLocations = new HashMap<String, String>();
        }
        if (this.options == null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (this.transformationFiles.length >= 1) {
            AtlSourceManager sourceManager = new AtlSourceManager();
            sourceManager.updateDataSource(this.transformationFiles[0].getContents());
            this.isRefining = sourceManager.isRefining();
            this.classShortName = new Path(String.valueOf(Character.toUpperCase(this.transformationFiles[0].getName().charAt(0))) + this.transformationFiles[0].getName().substring(1)).removeFileExtension().lastSegment();
            switch (sourceManager.getATLFileType()) {
                case 1: {
                    this.fileType = "Module";
                    break;
                }
                case 3: {
                    this.fileType = "Query";
                    break;
                }
                case 4: {
                    this.fileType = "Library";
                    break;
                }
            }
            IFile[] iFileArray = this.transformationFiles;
            int n = this.transformationFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                sourceManager.updateDataSource(file.getContents());
                this.updateFromFile(sourceManager);
                ++n2;
            }
            if (this.isRefining) {
                this.inOutModels.putAll(this.inModels);
                this.inModels.clear();
                ArrayList<String> toRemove = new ArrayList<String>();
                block6: for (String modelName : this.inOutModels.keySet()) {
                    String metamodelName = this.inOutModels.get(modelName);
                    for (String outModelName : this.outModels.keySet()) {
                        if (!metamodelName.equals(this.outModels.get(outModelName))) continue;
                        toRemove.add(outModelName);
                        continue block6;
                    }
                }
                for (String modelName : toRemove) {
                    this.outModels.remove(modelName);
                }
            }
        }
    }

    private void updateFromFile(AtlSourceManager sourceManager) {
        if (sourceManager.getInputModels() != null) {
            this.inModels.putAll(sourceManager.getInputModels());
        }
        if (sourceManager.getOutputModels() != null) {
            this.outModels.putAll(sourceManager.getOutputModels());
        }
        this.libraryNames.addAll(sourceManager.getLibrariesImports());
        Map<String, String> locationsFromFile = CreateRunnableData.convertLocations(sourceManager.getMetamodelLocations());
        for (String metamodelName : this.getAllMetamodelsNames()) {
            String location = locationsFromFile.get(metamodelName);
            if (location == null) continue;
            this.metamodelLocations.put(metamodelName, location);
        }
    }

    public IFile[] getTransformationFiles() {
        return this.transformationFiles;
    }

    public String getFileType() {
        return this.fileType;
    }

    public boolean isRefining() {
        return this.isRefining;
    }

    public Map<String, String> getInModels() {
        return this.inModels;
    }

    public Map<String, String> getInOutModels() {
        return this.inOutModels;
    }

    public Map<String, String> getOutModels() {
        return this.outModels;
    }

    public Set<String> getAllLibrariesNames() {
        return this.libraryNames;
    }

    public Map<String, String> getLibraryLocations() {
        return this.libraryLocations;
    }

    public Map<String, String> getMetamodelLocations() {
        return this.metamodelLocations;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void updateLibraryLocation(String name, String location) {
        this.libraryLocations.put(name, location);
    }

    public void updateMetamodelLocation(String name, String location) {
        this.metamodelLocations.put(name, location);
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public List<String> getAllModelsNames() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.getInModels().keySet());
        res.addAll(this.getInOutModels().keySet());
        res.addAll(this.getOutModels().keySet());
        return res;
    }

    public List<String> getModelsToLoadNames() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.getInModels().keySet());
        res.addAll(this.getInOutModels().keySet());
        return res;
    }

    public List<String> getModelsToSaveNames() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.getInOutModels().keySet());
        res.addAll(this.getOutModels().keySet());
        return res;
    }

    public Set<String> getAllMetamodelsNames() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(this.getInModels().values());
        res.addAll(this.getInOutModels().values());
        res.addAll(this.getOutModels().values());
        return res;
    }

    public boolean isMetametamodel(String metamodelName) {
        String location = this.getMetamodelLocations().get(metamodelName);
        if (location != null) {
            return location.startsWith("#");
        }
        return false;
    }

    public boolean isQuery() {
        return "Query".equals(this.getFileType());
    }

    private static Map<String, String> convertLocations(Map<String, String> paths) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : paths.keySet()) {
            String location = paths.get(name);
            String validLocation = null;
            if (location.startsWith("uri:")) {
                validLocation = location.substring(4);
            } else if (!(location.startsWith("ext:") || location.startsWith("platform:") || location.startsWith("pathmap"))) {
                validLocation = location;
            }
            if (validLocation == null) continue;
            result.put(name, validLocation);
        }
        return result;
    }

    public static IFile getFile(String path) {
        IResource res = null;
        if (path != null && !"".equals(path) && (res = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) instanceof IFile) {
            IFile file = (IFile)res;
            IFile atlFile = null;
            String extension = file.getFileExtension().toLowerCase();
            if (extension.equals("asm")) {
                String atlPath = file.getFullPath().removeFileExtension().addFileExtension("atl").toString();
                atlFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(atlPath));
            } else if (extension.equals("atl")) {
                atlFile = file;
            }
            if (atlFile.isAccessible()) {
                return atlFile;
            }
        }
        return null;
    }
}

