/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.revision;

import java.io.IOException;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOElementProxy;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.common.security.CDOPermissionProvider;
import org.eclipse.emf.cdo.common.security.NoPermissionException;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.revision.CDOListImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.revision.AbstractCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionMerger;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionUnchunker;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.om.trace.PerfTracer;

public abstract class BaseCDORevision
extends AbstractCDORevision {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, BaseCDORevision.class);
    private static final PerfTracer READING = new PerfTracer(OM.PERF_REVISION_READING, BaseCDORevision.class);
    private static final PerfTracer WRITING = new PerfTracer(OM.PERF_REVISION_WRITING, BaseCDORevision.class);
    private static final int RESOURCE_NODE_NAME_INDEX = 1;
    private static final int RESOURCE_FOLDER_NODES_INDEX = 2;
    private static final byte UNSET_OPCODE = 0;
    private static final byte SET_NULL_OPCODE = 1;
    private static final byte SET_NOT_NULL_OPCODE = 2;
    private static final byte READ_PERMISSION_FLAG = 1;
    private static final byte WRITE_PERMISSION_FLAG = 2;
    private static final byte FROZEN_FLAG = 4;
    private static final byte UNCHUNKED_FLAG = 8;
    private static final byte BYPASS_PERMISSION_CHECKS_FLAG = 16;
    private static final byte LIST_PRESERVING_FLAG = 32;
    private static final byte PERMISSION_MASK = 3;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private CDOID id;
    private CDOBranchPoint branchPoint;
    private int version;
    private long revised;
    private CDOID resourceID;
    private Object containerID;
    private int containingFeatureID;
    private transient byte flags;

    public BaseCDORevision(EClass eClass) {
        super(eClass);
        if (eClass != null) {
            this.version = 0;
            this.revised = 0L;
            this.resourceID = CDOID.NULL;
            this.containerID = CDOID.NULL;
            this.containingFeatureID = 0;
            this.initValues(this.getAllPersistentFeatures());
        }
        this.flags = CDOPermission.WRITE.getBits();
    }

    protected BaseCDORevision(BaseCDORevision source) {
        super(source.getEClass());
        this.id = source.id;
        this.branchPoint = source.branchPoint;
        this.version = source.version;
        this.revised = source.revised;
        this.resourceID = source.resourceID;
        this.containerID = source.containerID;
        this.containingFeatureID = source.containingFeatureID;
        this.flags = (byte)(source.flags & 0xFFFFFFFB);
    }

    @Override
    public void read(CDODataInput in) throws IOException {
        if (READING.isEnabled()) {
            READING.start((Object)this);
        }
        this.readSystemValues(in);
        this.flags = in.readByte();
        this.flags = (byte)(this.flags | 8);
        this.flags = (byte)(this.flags | 0x10);
        if ((this.flags & 3) == CDOPermission.NONE.ordinal()) {
            if (this.getClassInfo().isResourceNode()) {
                this.clearValues();
                EClass eClass = this.getEClass();
                EStructuralFeature[] features = this.getAllPersistentFeatures();
                this.readValue(in, eClass, features[1], 1, true);
                if (this.getClassInfo().isResourceFolder() && !this.readValue(in, eClass, features[2], 2, true)) {
                    this.flags = (byte)(this.flags & 0xFFFFFFF7);
                }
            }
        } else if (!this.readValues(in)) {
            this.flags = (byte)(this.flags & 0xFFFFFFF7);
        }
        this.flags = (byte)(this.flags & 0xFFFFFFEF);
        if (READING.isEnabled()) {
            READING.stop((Object)this);
        }
    }

    protected void readSystemValues(CDODataInput in) throws IOException {
        EClassifier classifier = in.readCDOClassifierRefAndResolve();
        this.initClassInfo((EClass)classifier);
        this.id = in.readCDOID();
        this.branchPoint = in.readCDOBranchPoint();
        this.version = in.readXInt();
        if (!this.id.isTemporary()) {
            this.revised = in.readXLong();
        }
        this.resourceID = in.readCDOID();
        this.containerID = in.readCDOID();
        this.containingFeatureID = in.readXInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading revision: ID={0}, className={1}, version={2}, branchPoint={3}, revised={4}, resource={5}, container={6}, featureID={7}", new Object[]{this.id, this.getEClass().getName(), this.version, this.branchPoint, this.revised, this.resourceID, this.containerID, this.containingFeatureID});
        }
    }

    @Override
    public boolean readValues(CDODataInput in) throws IOException {
        EClass owner = this.getEClass();
        EStructuralFeature[] features = this.getAllPersistentFeatures();
        this.initValues(features);
        boolean unchunked = true;
        int i = 0;
        while (i < features.length) {
            unchunked = this.readValue(in, owner, features[i], i, unchunked);
            ++i;
        }
        return unchunked;
    }

    @Override
    public boolean readValue(CDODataInput in, EClass owner, EStructuralFeature feature, int i, boolean unchunked) throws IOException {
        Object value;
        byte unsetState = in.readByte();
        switch (unsetState) {
            case 0: {
                return unchunked;
            }
            case 1: {
                this.setValue(i, CDORevisionData.NIL);
                return unchunked;
            }
        }
        if (feature.isMany()) {
            Object lastElement;
            int size;
            CDOList list = in.readCDOList(owner, feature);
            if (unchunked && (size = list.size()) != 0 && ((lastElement = list.get(size - 1)) == InternalCDOList.UNINITIALIZED || lastElement instanceof CDOElementProxy)) {
                unchunked = false;
            }
            value = list;
        } else {
            value = in.readCDOFeatureValue(feature);
            if (TRACER.isEnabled()) {
                TRACER.format("Read feature {0}: {1}", new Object[]{feature.getName(), value});
            }
        }
        this.setValue(i, value);
        return unchunked;
    }

    @Override
    public void write(CDODataOutput out, int referenceChunk) throws IOException {
        this.write(out, referenceChunk, null);
    }

    @Override
    public void write(CDODataOutput out, int referenceChunk, CDOBranchPoint securityContext) throws IOException {
        if (WRITING.isEnabled()) {
            WRITING.start((Object)this);
        }
        this.writeSystemValues(out);
        CDOPermissionProvider permissionProvider = out.getPermissionProvider();
        CDOPermission permission = permissionProvider.getPermission(this, securityContext);
        out.writeByte(permission.getBits());
        if (permission == CDOPermission.NONE) {
            if (this.getClassInfo().isResourceNode()) {
                EClass eClass = this.getEClass();
                EStructuralFeature[] features = this.getAllPersistentFeatures();
                this.writeValue(out, eClass, features[1], 1, referenceChunk);
                if (this.getClassInfo().isResourceFolder()) {
                    this.writeValue(out, eClass, features[2], 2, referenceChunk);
                }
            }
        } else {
            CDORevisionUnchunker unchunker;
            if (!this.isUnchunked() && referenceChunk != 0 && (unchunker = out.getRevisionUnchunker()) != null) {
                unchunker.ensureChunks(this, referenceChunk);
            }
            this.writeValues(out, referenceChunk);
        }
        if (WRITING.isEnabled()) {
            WRITING.stop((Object)this);
        }
    }

    protected void writeSystemValues(CDODataOutput out) throws IOException {
        EClass eClass = this.getEClass();
        CDOClassifierRef classRef = new CDOClassifierRef((EClassifier)eClass);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing revision: ID={0}, className={1}, version={2}, branchPoint={3}, revised={4}, resource={5}, container={6}, featureID={7}", new Object[]{this.id, eClass.getName(), this.getVersion(), this.branchPoint, this.revised, this.resourceID, this.containerID, this.containingFeatureID});
        }
        out.writeCDOClassifierRef(classRef);
        out.writeCDOID(this.id);
        out.writeCDOBranchPoint(this.branchPoint);
        out.writeXInt(this.getVersion());
        if (!this.id.isTemporary()) {
            out.writeXLong(this.revised);
        }
        out.writeCDOID(this.resourceID);
        out.writeCDOID(out.getIDProvider().provideCDOID(this.containerID));
        out.writeXInt(this.containingFeatureID);
    }

    @Override
    public void writeValues(CDODataOutput out, int referenceChunk) throws IOException {
        EClass owner = this.getEClass();
        EStructuralFeature[] features = this.getAllPersistentFeatures();
        int i = 0;
        while (i < features.length) {
            this.writeValue(out, owner, features[i], i, referenceChunk);
            ++i;
        }
    }

    @Override
    public void writeValue(CDODataOutput out, EClass owner, EStructuralFeature feature, int i, int referenceChunk) throws IOException {
        Object value = this.getValue(i);
        if (value == null) {
            out.writeByte(0);
            return;
        }
        if (value == CDORevisionData.NIL) {
            out.writeByte(1);
            return;
        }
        out.writeByte(2);
        if (feature.isMany()) {
            CDOList list = (CDOList)value;
            out.writeCDOList(owner, feature, list, referenceChunk);
        } else {
            if (feature instanceof EReference) {
                value = out.getIDProvider().provideCDOID(value);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Writing feature {0}: {1}", new Object[]{feature.getName(), value});
            }
            out.writeCDOFeatureValue(feature, value);
        }
    }

    @Override
    public void convertEObjects(CDOIDProvider idProvider) {
        if (!(this.containerID instanceof CDOID)) {
            this.containerID = idProvider.provideCDOID(this.containerID);
        }
        EStructuralFeature[] features = this.getAllPersistentFeatures();
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            if (feature.isMany()) {
                CDOList list = this.getValueAsList(i);
                if (list != null) {
                    int j = 0;
                    while (j < list.size()) {
                        CDOID newValue;
                        Object value = list.get(j, false);
                        EStructuralFeature innerFeature = feature;
                        if (value != null && innerFeature instanceof EReference && (newValue = idProvider.provideCDOID(value)) != value) {
                            list.set(j, newValue);
                        }
                        ++j;
                    }
                }
            } else {
                CDOID newValue;
                Object value = this.getValue(i);
                if (value != null && feature instanceof EReference && (newValue = idProvider.provideCDOID(value)) != value) {
                    this.setValue(i, (Object)newValue);
                }
            }
            ++i;
        }
    }

    @Override
    public CDOID getID() {
        return this.id;
    }

    @Override
    public void setID(CDOID id) {
        if (CDOIDUtil.isNull(id)) {
            throw new IllegalArgumentException(Messages.getString("AbstractCDORevision.1"));
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Setting ID: {0}", new Object[]{id});
        }
        this.id = id;
    }

    @Override
    public InternalCDOBranch getBranch() {
        if (this.branchPoint == null) {
            return null;
        }
        return (InternalCDOBranch)this.branchPoint.getBranch();
    }

    @Override
    public long getTimeStamp() {
        if (this.branchPoint == null) {
            return 0L;
        }
        return this.branchPoint.getTimeStamp();
    }

    @Override
    public void setBranchPoint(CDOBranchPoint branchPoint) {
        branchPoint = CDOBranchUtil.copyBranchPoint(branchPoint);
        if (TRACER.isEnabled()) {
            TRACER.format("Setting branchPoint {0}: {1}", new Object[]{this, branchPoint});
        }
        this.branchPoint = branchPoint;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting version for {0}: v{1}", new Object[]{this, version});
        }
        this.version = version;
    }

    @Override
    public long getRevised() {
        return this.revised;
    }

    @Override
    public void setRevised(long revised) {
        long created = this.branchPoint.getTimeStamp();
        if (revised != 0L && revised < Math.max(0L, created)) {
            throw new IllegalArgumentException("revision=" + this + ", created=" + CDOCommonUtil.formatTimeStamp(created) + ", revised=" + CDOCommonUtil.formatTimeStamp(revised));
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Setting revised {0}: {1}", new Object[]{this, CDOCommonUtil.formatTimeStamp(revised)});
        }
        this.revised = revised;
    }

    @Override
    public InternalCDORevisionDelta compare(CDORevision origin) {
        return new CDORevisionDeltaImpl(origin, this);
    }

    @Override
    public void merge(CDORevisionDelta delta) {
        CDORevisionMerger applier = new CDORevisionMerger();
        applier.merge(this, delta);
    }

    @Override
    public CDOID getResourceID() {
        return this.resourceID;
    }

    @Override
    public void setResourceID(CDOID resourceID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting resourceID {0}: {1}", new Object[]{this, resourceID});
        }
        this.resourceID = resourceID;
    }

    @Override
    public Object getContainerID() {
        return this.containerID;
    }

    @Override
    public void setContainerID(Object containerID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting containerID {0}: {1}", new Object[]{this, containerID});
        }
        this.containerID = containerID;
    }

    @Override
    public int getContainingFeatureID() {
        return this.containingFeatureID;
    }

    @Override
    public void setContainingFeatureID(int containingFeatureID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting containingFeatureID {0}: {1}", new Object[]{this, containingFeatureID});
        }
        this.containingFeatureID = containingFeatureID;
    }

    @Override
    public int hashCode(EStructuralFeature feature) {
        Object value = this.getValue(feature);
        if (value == null) {
            return 1;
        }
        return value.hashCode();
    }

    @Override
    public Object get(EStructuralFeature feature, int index) {
        if (feature.isMany()) {
            CDOList list = this.getListOrNull(feature);
            if (list == null) {
                throw new CDOListImpl.IndexOutOfBoundsException(index, 0);
            }
            return list.get(index);
        }
        return this.getValue(feature);
    }

    @Override
    public boolean contains(EStructuralFeature feature, Object value) {
        CDOList list = this.getListOrNull(feature);
        return list != null && list.contains(value);
    }

    @Override
    public int indexOf(EStructuralFeature feature, Object value) {
        CDOList list = this.getListOrNull(feature);
        return list == null ? -1 : list.indexOf(value);
    }

    @Override
    public int lastIndexOf(EStructuralFeature feature, Object value) {
        CDOList list = this.getListOrNull(feature);
        return list == null ? -1 : list.lastIndexOf(value);
    }

    @Override
    public boolean isEmpty(EStructuralFeature feature) {
        CDOList list = this.getListOrNull(feature);
        return ObjectUtil.isEmpty((Collection)((Object)list));
    }

    @Override
    public int size(EStructuralFeature feature) {
        CDOList list = this.getListOrNull(feature);
        return list == null ? 0 : list.size();
    }

    @Override
    public Object[] toArray(EStructuralFeature feature) {
        if (!feature.isMany()) {
            throw new IllegalStateException("!feature.isMany()");
        }
        CDOList list = this.getListOrNull(feature);
        return list == null ? EMPTY_ARRAY : list.toArray();
    }

    @Override
    public <T> T[] toArray(EStructuralFeature feature, T[] array) {
        if (!feature.isMany()) {
            throw new IllegalStateException("!feature.isMany()");
        }
        CDOList list = this.getListOrNull(feature);
        if (list == null) {
            if (array.length != 0) {
                Object[] emptyArray = (Object[])Array.newInstance(array.getClass().getComponentType(), 0);
                return emptyArray;
            }
            return array;
        }
        return list.toArray(array);
    }

    @Override
    public void add(EStructuralFeature feature, int index, Object value) {
        CDOList list = this.getOrCreateList(feature);
        list.add(index, value);
    }

    @Override
    public void clear(EStructuralFeature feature) {
        if (feature.isMany() && feature.isUnsettable()) {
            this.getOrCreateList(feature).clear();
        } else {
            this.setValue(feature, null);
        }
    }

    @Override
    public Object move(EStructuralFeature feature, int targetIndex, int sourceIndex) {
        CDOList list = this.getListOrNull(feature);
        if (list == null) {
            throw new CDOListImpl.IndexOutOfBoundsException(sourceIndex, 0);
        }
        return list.move(targetIndex, sourceIndex);
    }

    @Override
    public Object remove(EStructuralFeature feature, int index) {
        CDOList list = this.getListOrNull(feature);
        if (list == null) {
            throw new CDOListImpl.IndexOutOfBoundsException(index, 0);
        }
        return list.remove(index);
    }

    @Override
    public Object set(EStructuralFeature feature, int index, Object value) {
        if (feature.isMany()) {
            CDOList list = this.getOrCreateList(feature);
            return list.set(index, value);
        }
        return this.setValue(feature, value);
    }

    @Override
    public void unset(EStructuralFeature feature) {
        this.setValue(feature, null);
    }

    @Override
    public boolean adjustReferences(CDOReferenceAdjuster referenceAdjuster) {
        Object id2;
        if (TRACER.isEnabled()) {
            TRACER.format("Adjusting references for revision {0}", new Object[]{this});
        }
        boolean changed = false;
        CDOID id1 = (CDOID)referenceAdjuster.adjustReference(this.resourceID, (EStructuralFeature)CDOContainerFeatureDelta.CONTAINER_FEATURE, -1);
        if (id1 != this.resourceID) {
            this.resourceID = id1;
            changed = true;
        }
        if ((id2 = referenceAdjuster.adjustReference(this.containerID, (EStructuralFeature)CDOContainerFeatureDelta.CONTAINER_FEATURE, -1)) != this.containerID) {
            this.containerID = id2;
            changed = true;
        }
        EStructuralFeature[] features = this.getAllPersistentFeatures();
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            if (feature instanceof EReference) {
                if (feature.isMany()) {
                    InternalCDOList list = (InternalCDOList)this.getValueAsList(i);
                    if (list != null) {
                        changed |= list.adjustReferences(referenceAdjuster, feature);
                    }
                } else {
                    Object newValue;
                    CDOType type = CDOModelUtil.getType(feature);
                    Object oldValue = this.getValue(i);
                    if (oldValue != (newValue = type.adjustReferences(referenceAdjuster, oldValue, feature, -1))) {
                        this.setValue(i, newValue);
                        changed = true;
                    }
                }
            }
            ++i;
        }
        return changed;
    }

    @Override
    public void adjustBranches(CDOBranchManager newBranchManager) {
        CDOBranch branch;
        if (this.branchPoint != null && (branch = this.branchPoint.getBranch()) != null) {
            branch = newBranchManager.getBranch(branch.getID());
            this.branchPoint = branch.getPoint(this.branchPoint.getTimeStamp());
        }
    }

    @Override
    public Object getValue(EStructuralFeature feature) {
        this.checkReadable(feature);
        int featureIndex = this.getFeatureIndex(feature);
        return this.getValue(featureIndex);
    }

    @Override
    public Object setValue(EStructuralFeature feature, Object value) {
        int featureIndex = this.getFeatureIndex(feature);
        try {
            Object old = this.getValue(featureIndex);
            this.setValue(featureIndex, value);
            return old;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("AbstractCDORevision.20"), feature, this.getClassInfo()), ex);
        }
    }

    @Override
    public CDOList getListOrNull(EStructuralFeature feature) {
        return this.getOrCreateList(feature, -1);
    }

    @Override
    public CDOList getOrCreateList(EStructuralFeature feature) {
        return this.getOrCreateList(feature, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOList getOrCreateList(EStructuralFeature feature, int size) {
        this.checkReadable(feature);
        int featureIndex = this.getFeatureIndex(feature);
        InternalCDOList list = (InternalCDOList)this.getValue(featureIndex);
        if (list == null) {
            if (size == -1) {
                return null;
            }
            list = (InternalCDOList)CDOListFactory.DEFAULT.createList(size, 0, 0);
            if (feature instanceof EReference && list instanceof InternalCDOList.ConfigurableEquality) {
                ((InternalCDOList.ConfigurableEquality)list).setUseEquals(false);
            }
            BaseCDORevision baseCDORevision = this;
            synchronized (baseCDORevision) {
                boolean bypassPermissionChecks = this.bypassPermissionChecks(true);
                try {
                    this.setValue(featureIndex, (Object)list);
                }
                finally {
                    this.bypassPermissionChecks(bypassPermissionChecks);
                }
            }
        }
        return list;
    }

    @Override
    public void setList(EStructuralFeature feature, InternalCDOList list) {
        int featureIndex = this.getFeatureIndex(feature);
        this.setValue(featureIndex, (Object)list);
    }

    @Override
    public EStructuralFeature[] clearValues() {
        EStructuralFeature[] features = this.getClassInfo().getAllPersistentFeatures();
        this.initValues(features);
        return features;
    }

    @Override
    public String getResourceNodeName() {
        return (String)this.doGetValue(1);
    }

    @Override
    public CDOPermission getPermission() {
        return CDOPermission.get(this.flags & 3);
    }

    @Override
    public void setPermission(CDOPermission permission) {
        this.flags = (byte)(this.flags & 0xFFFFFFFC | permission.getBits() & 3);
        if (permission == CDOPermission.NONE) {
            EStructuralFeature[] features = this.getClassInfo().getAllPersistentFeatures();
            InternalCDOClassInfo classInfo = this.getClassInfo();
            if (classInfo.isResourceNode()) {
                EStructuralFeature[] eStructuralFeatureArray = features;
                int n = features.length;
                int n2 = 0;
                while (n2 < n) {
                    EStructuralFeature feature = eStructuralFeatureArray[n2];
                    if (!CDOModelUtil.isResourcePathFeature(feature)) {
                        this.setValue(feature, null);
                    }
                    ++n2;
                }
            } else {
                this.initValues(features);
            }
        }
    }

    @Override
    public boolean bypassPermissionChecks(boolean on) {
        boolean old = (this.flags & 0x10) != 0;
        this.flags = on ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
        return old;
    }

    @Override
    public boolean isListPreserving() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public void setListPreserving() {
        this.flags = (byte)(this.flags | 0x20);
    }

    @Override
    public void freeze() {
        this.flags = (byte)(this.flags | 4);
        if (this.isReadable()) {
            EStructuralFeature[] features = this.getAllPersistentFeatures();
            int i = 0;
            while (i < features.length) {
                InternalCDOList list;
                EStructuralFeature feature = features[i];
                if (feature.isMany() && (list = (InternalCDOList)this.doGetValue(i)) != null) {
                    list.freeze();
                }
                ++i;
            }
        }
    }

    public void unfreeze() {
        this.flags = (byte)(this.flags & 0xFFFFFFFB);
        if (this.isReadable()) {
            EStructuralFeature[] features = this.getAllPersistentFeatures();
            int i = 0;
            while (i < features.length) {
                Object value;
                EStructuralFeature feature = features[i];
                if (feature.isMany() && (value = this.doGetValue(i)) instanceof CDOListImpl) {
                    CDOListImpl list = (CDOListImpl)value;
                    list.unfreeze();
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isFrozen() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isUnchunked() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void setUnchunked() {
        this.flags = (byte)(this.flags | 8);
    }

    protected Object getValue(int featureIndex) {
        return this.doGetValue(featureIndex);
    }

    protected void setValue(int featureIndex, Object value) {
        this.checkUnfrozen(featureIndex, value);
        this.checkWritable();
        this.doSetValue(featureIndex, value);
    }

    protected abstract void initValues(EStructuralFeature[] var1);

    protected abstract Object doGetValue(int var1);

    protected abstract void doSetValue(int var1, Object var2);

    private CDOList getValueAsList(int i) {
        return (CDOList)this.getValue(i);
    }

    private void checkUnfrozen(int featureIndex, Object value) {
        if ((this.flags & 4) != 0) {
            boolean newIsEmptyList;
            if ((this.flags & 0x10) != 0) {
                return;
            }
            Object oldValue = this.getValue(featureIndex);
            boolean bl = newIsEmptyList = value instanceof EList && ((EList)value).size() == 0;
            if (newIsEmptyList && oldValue == null) {
                return;
            }
            if (oldValue instanceof CDOIDTemp && value instanceof CDOID) {
                return;
            }
            throw new IllegalStateException("Cannot modify a frozen revision");
        }
    }

    private void checkReadable(EStructuralFeature feature) {
        if ((this.flags & 0x10) != 0) {
            return;
        }
        if (CDOModelUtil.isResourcePathFeature(feature)) {
            return;
        }
        if ((this.flags & 1) == 0) {
            throw new NoPermissionException((Object)this, false);
        }
    }

    private void checkWritable() {
        if ((this.flags & 0x10) != 0) {
            return;
        }
        if ((this.flags & 2) == 0) {
            throw new NoPermissionException((Object)this, true);
        }
    }

    @Deprecated
    public static void checkNoFeatureMap(EStructuralFeature feature) {
        throw new UnsupportedOperationException();
    }

    public static Object remapID(Object value, Map<CDOID, CDOID> idMappings, boolean allowUnmappedTempIDs) {
        CDOID oldID;
        if (value instanceof CDOID && !(oldID = (CDOID)value).isNull()) {
            CDOID newID = idMappings.get(oldID);
            if (newID != null) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Adjusting ID: {0} --> {1}", new Object[]{oldID, newID});
                }
                return newID;
            }
            if (oldID instanceof CDOIDTemp) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("AbstractCDORevision.2"), oldID));
            }
        }
        return value;
    }

    public static String formatFlags(BaseCDORevision revision) {
        byte flags = revision.flags;
        StringBuilder builder = new StringBuilder();
        if ((flags & 8) != 0) {
            builder.append("UNCHUNKED");
        }
        if ((flags & 4) != 0) {
            StringUtil.appendSeparator((StringBuilder)builder, (char)'|');
            builder.append("FROZEN");
        }
        if ((flags & 1) != 0) {
            StringUtil.appendSeparator((StringBuilder)builder, (char)'|');
            builder.append("READ");
        }
        if ((flags & 2) != 0) {
            StringUtil.appendSeparator((StringBuilder)builder, (char)'|');
            builder.append("WRITE");
        }
        if ((flags & 0x10) != 0) {
            StringUtil.appendSeparator((StringBuilder)builder, (char)'|');
            builder.append("BYPASS_PERMISSION_CHECKS");
        }
        return builder.toString();
    }
}

