/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.utils;

import org.eclipse.datatools.modelbase.sql.datatypes.BinaryStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.NumberDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.NumericalDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;

public class ASADatatypeUtil {
    public static PredefinedDataType getPredefinedRepresentation(DataType datatype) {
        if (datatype instanceof DistinctUserDefinedType) {
            DistinctUserDefinedType udt = (DistinctUserDefinedType)datatype;
            PredefinedDataType pType = udt.getPredefinedRepresentation();
            return pType;
        }
        return null;
    }

    public static boolean isNumericType(DataType datatype) {
        if (ASADatatypeUtil.getPredefinedRepresentation(datatype) != null) {
            return ASADatatypeUtil.isNumericType((DataType)ASADatatypeUtil.getPredefinedRepresentation(datatype));
        }
        return datatype instanceof NumericalDataType || datatype instanceof NumberDataType;
    }

    public static boolean isStringType(DataType datatype) {
        if (ASADatatypeUtil.getPredefinedRepresentation(datatype) != null) {
            return ASADatatypeUtil.isStringType((DataType)ASADatatypeUtil.getPredefinedRepresentation(datatype));
        }
        return datatype instanceof CharacterStringDataType;
    }

    public static boolean isTSType(DataType datatype) {
        if (datatype.getName().equalsIgnoreCase("timestamp")) {
            return true;
        }
        if (ASADatatypeUtil.getPredefinedRepresentation(datatype) != null) {
            if (ASADatatypeUtil.getPredefinedRepresentation(datatype) instanceof TimeDataType) {
                return true;
            }
            if (ASADatatypeUtil.isDateType((DataType)ASADatatypeUtil.getPredefinedRepresentation(datatype))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isTimeType(DataType datatype) {
        return datatype instanceof TimeDataType && datatype.getName().equalsIgnoreCase("time");
    }

    public static boolean isDateType(DataType datatype) {
        return datatype instanceof DateDataType;
    }

    public static boolean isBinaryType(DataType datatype) {
        if (ASADatatypeUtil.getPredefinedRepresentation(datatype) != null) {
            return ASADatatypeUtil.isBinaryType((DataType)ASADatatypeUtil.getPredefinedRepresentation(datatype));
        }
        return datatype instanceof BinaryStringDataType;
    }
}

