/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.nativelib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMMap;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclSimpleType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMTupleType;

public class ASMTuple
extends ASMOclAny {
    public static ASMOclType myType = new ASMOclSimpleType("Tuple", ASMTuple.getOclAnyType());
    private Map s;

    public ASMTuple() {
        super(myType);
        this.s = new HashMap();
    }

    public ASMTuple(Map init) {
        super(myType);
        this.s = new HashMap(init);
    }

    public ASMTuple(ASMTuple init) {
        super(myType);
        this.s = new HashMap(init.s);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("Tuple {");
        Iterator i = this.s.keySet().iterator();
        while (i.hasNext()) {
            Object n = i.next();
            Object o = this.s.get(n);
            ret.append(((ASMString)n).getSymbol());
            ret.append(" = ");
            ret.append(o);
            if (!i.hasNext()) continue;
            ret.append(", ");
        }
        ret.append("}");
        return ret.toString();
    }

    public boolean equals(Object o) {
        return o instanceof ASMTuple && ((ASMTuple)o).s.equals(this.s);
    }

    public int hashCode() {
        return this.s.hashCode();
    }

    @Override
    public ASMOclAny get(StackFrame frame, String name) {
        ASMOclAny ret = null;
        if (frame != null && this.isHelper(frame, name)) {
            ret = this.getHelper(frame, name);
        } else {
            ret = (ASMOclAny)this.s.get(new ASMString(name));
            if (ret == null) {
                ret = new ASMOclUndefined();
            }
        }
        return ret;
    }

    @Override
    public void set(StackFrame frame, String name, ASMOclAny value) {
        this.s.put(new ASMString(name), value);
        HashMap<String, ASMOclType> attrs = new HashMap<String, ASMOclType>();
        for (ASMString n : this.s.keySet()) {
            attrs.put(n.getSymbol(), ASMOclAny.myType);
        }
        this.setType(new ASMTupleType(attrs));
    }

    @Override
    public void unset(StackFrame frame, String name) {
        this.s.remove(new ASMString(name));
        HashMap<String, ASMOclType> attrs = new HashMap<String, ASMOclType>();
        for (ASMString n : this.s.keySet()) {
            attrs.put(n.getSymbol(), ASMOclAny.myType);
        }
        this.setType(new ASMTupleType(attrs));
    }

    public Map getMap() {
        return this.s;
    }

    public static ASMMap asMap(StackFrame frame, ASMTuple self) {
        return new ASMMap(self.s);
    }
}

