/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.query.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.query.AbstractTraitQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.internal.SearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleResultSet;

public class SimpleTraitQueryVisitorImpl
extends AbstractTraitQueryVisitor {
    private String _traitQuery;
    private SearchControl _control;
    private boolean _stop;
    private List<Trait> _traitResults;

    public SimpleTraitQueryVisitorImpl() {
        this._control = new SearchControl();
    }

    public SimpleTraitQueryVisitorImpl(SearchControl control) {
        this._control = control;
    }

    @Override
    public IResultSet<Trait> findTraits(Entity entity, String traitQuery) {
        this.resetQuery();
        if (entity != null) {
            this._traitQuery = traitQuery;
            for (Trait t : entity.getTraits()) {
                t.accept(this);
                if (this.stopVisiting()) break;
            }
        }
        return new SimpleResultSet<Trait>(this.getInternalTraitResults());
    }

    @Override
    public void visit(Trait trait) {
        if (trait.getId().equals(this._traitQuery)) {
            this.getInternalTraitResults().add(trait);
        }
        this.checkShouldStopVisitingTraits();
    }

    private void resetQuery() {
        this._stop = false;
        this._traitResults = null;
    }

    private List<Trait> getInternalTraitResults() {
        if (this._traitResults == null) {
            this._traitResults = new ArrayList<Trait>();
        }
        return this._traitResults;
    }

    @Override
    public boolean stopVisiting() {
        return this._stop;
    }

    private void checkShouldStopVisitingTraits() {
        if (this._control.getCountLimit() == this.getInternalTraitResults().size() && this._control.getCountLimit() != -1) {
            this._stop = true;
        }
    }
}

