/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.actions;

import java.util.ArrayList;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.policies.DeletionPolicy;
import org.eclipse.gef.mvc.fx.ui.actions.AbstractViewerAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.actions.ActionFactory;

public class DeleteAction
extends AbstractViewerAction {
    private ListChangeListener<IContentPart<? extends Node>> selectionListener = new ListChangeListener<IContentPart<? extends Node>>(){

        public void onChanged(ListChangeListener.Change<? extends IContentPart<? extends Node>> c) {
            DeleteAction.this.setEnabled(!c.getList().isEmpty());
        }
    };

    public DeleteAction() {
        this("Delete", 1, null);
        this.setId(ActionFactory.DELETE.getId());
    }

    protected DeleteAction(String text, int style, ImageDescriptor imageDescriptor) {
        super(text, style, imageDescriptor);
    }

    @Override
    protected ITransactionalOperation createOperation(Event event) {
        DeletionPolicy deletionPolicy = (DeletionPolicy)this.getViewer().getRootPart().getAdapter(DeletionPolicy.class);
        if (deletionPolicy == null) {
            throw new IllegalStateException("DeleteActionHandler requires a DeletionPolicy to be registered at the viewer's root part.");
        }
        deletionPolicy.init();
        for (IContentPart s : new ArrayList(this.getSelectionModel().getSelectionUnmodifiable())) {
            deletionPolicy.delete(s);
        }
        ITransactionalOperation deleteOperation = deletionPolicy.commit();
        return deleteOperation;
    }

    protected SelectionModel getSelectionModel() {
        return this.getViewer() == null ? null : (SelectionModel)this.getViewer().getAdapter(SelectionModel.class);
    }

    @Override
    protected void register() {
        SelectionModel newSelectionModel = this.getSelectionModel();
        if (newSelectionModel != null) {
            newSelectionModel.getSelectionUnmodifiable().addListener(this.selectionListener);
        }
        this.setEnabled(newSelectionModel != null && !newSelectionModel.getSelectionUnmodifiable().isEmpty());
    }

    @Override
    protected void unregister() {
        this.setEnabled(false);
        SelectionModel oldSelectionModel = this.getSelectionModel();
        if (oldSelectionModel != null) {
            oldSelectionModel.getSelectionUnmodifiable().removeListener(this.selectionListener);
        }
    }
}

