/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.Arrays;
import org.eclipse.epp.internal.mpc.ui.css.StyleHelper;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractMarketplaceWizardDialog;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceDropAdapter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplacePage;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.ui.MarketplaceUrlHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class MarketplaceWizardDialog
extends AbstractMarketplaceWizardDialog {
    public MarketplaceWizardDialog(Shell parentShell, MarketplaceWizard newWizard) {
        super(null, (IWizard)newWizard);
        int shellStyle = this.getShellStyle();
        int allModal = 229376;
        shellStyle &= ~allModal;
        this.setShellStyle(shellStyle |= 0);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setData((Object)this);
        new StyleHelper().on((Widget)newShell).setClass("MarketplaceWizardDialog").setId("MarketplaceWizard");
        new MarketplaceDropAdapter(){

            @Override
            protected void proceedInstallation(String url) {
                MarketplaceUrlHandler.SolutionInstallationInfo info = MarketplaceUrlHandler.createSolutionInstallInfo(url);
                String installItem = info.getInstallId();
                if (installItem != null && installItem.length() > 0) {
                    info.setState(null);
                    MarketplaceWizardDialog.this.getWizard().handleInstallRequest(info, url);
                }
            }
        }.installDropTarget(newShell);
        IWorkbenchListener workbenchListener = new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                MarketplaceWizardDialog wizardDialog = MarketplaceWizardDialog.this;
                Shell wizardShell = wizardDialog.getShell();
                if (wizardShell != null && !wizardShell.isDisposed()) {
                    if (!forced) {
                        MarketplaceWizard wizard = wizardDialog.getWizard();
                        boolean hasPendingActions = false;
                        IWizardPage currentPage = wizardDialog.getCurrentPage();
                        if (currentPage != null && wizard != null) {
                            hasPendingActions = currentPage == wizard.getCatalogPage() ? !wizard.getSelectionModel().getSelectedCatalogItems().isEmpty() : true;
                        }
                        if (hasPendingActions) {
                            Shell parentShell = this.activate(wizardDialog.getShell());
                            MessageDialog messageDialog = new MessageDialog(parentShell, Messages.MarketplaceWizardDialog_PromptPendingActionsTitle, null, Messages.MarketplaceWizardDialog_PromptPendingActionsMessage, 6, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                            int result = messageDialog.open();
                            switch (result) {
                                case 0: {
                                    this.finishWizard();
                                    return false;
                                }
                                case 1: {
                                    break;
                                }
                                default: {
                                    return false;
                                }
                            }
                        }
                    }
                    if (forced) {
                        wizardShell.close();
                    } else {
                        boolean closed = wizardDialog.close();
                        return closed;
                    }
                }
                return true;
            }

            private void finishWizard() {
                MarketplaceWizardDialog wizardDialog = MarketplaceWizardDialog.this;
                MarketplaceWizard wizard = wizardDialog.getWizard();
                IWizardPage currentPage = wizardDialog.getCurrentPage();
                if (currentPage == wizard.getCatalogPage()) {
                    ((MarketplacePage)currentPage).showNextPage();
                }
            }

            private Shell activate(Shell shell) {
                Shell[] childShells;
                Shell activeShell = shell.getDisplay().getActiveShell();
                if (!(activeShell == shell || (childShells = shell.getShells()).length != 0 && Arrays.asList(childShells).contains(activeShell))) {
                    shell.forceActive();
                    shell.forceFocus();
                }
                if (activeShell == null && (activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell()) == null) {
                    activeShell = shell;
                }
                return activeShell;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        };
        PlatformUI.getWorkbench().addWorkbenchListener(workbenchListener);
        newShell.addDisposeListener(e -> PlatformUI.getWorkbench().removeWorkbenchListener(workbenchListener));
        if (newShell.getParent() == null) {
            newShell.addTraverseListener(e -> {
                Shell shell;
                if (e.keyCode == 27 && (shell = (Shell)e.widget) != null && !shell.isDisposed() && shell.isVisible() && shell.isEnabled()) {
                    shell.close();
                }
            });
        }
    }

    public MarketplaceWizard getWizard() {
        return (MarketplaceWizard)super.getWizard();
    }
}

