/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.events;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

@Immutable
public class MIWatchpointTriggerEvent
extends MIStoppedEvent {
    private final String number;
    private final String exp;
    private final String oldValue;
    private final String newValue;

    protected MIWatchpointTriggerEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIFrame frame, String number, String exp, String oldValue, String newValue) {
        super(ctx, token, results, frame);
        this.number = number;
        this.exp = exp;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String getNumber() {
        return this.number;
    }

    public String getExpression() {
        return this.exp;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public static MIWatchpointTriggerEvent parse(IRunControl.IExecutionDMContext dmc, int token, MIResult[] results) {
        String number = "";
        String exp = "";
        String oldValue = "";
        String newValue = "";
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            if (var.equals("wpt") || var.equals("hw-awpt") || var.equals("hw-rwpt")) {
                if (value instanceof MITuple) {
                    var13_14 = ((MITuple)value).getMIResults();
                    var12_13 = var13_14.length;
                    var11_12 = 0;
                    while (var11_12 < var12_13) {
                        MIResult wptResult = var13_14[var11_12];
                        String wptVar = wptResult.getVariable();
                        MIValue wptValue = wptResult.getMIValue();
                        if (wptVar.equals("number")) {
                            if (wptValue instanceof MIConst) {
                                str = ((MIConst)wptValue).getString();
                                try {
                                    number = str;
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        } else if (wptVar.equals("exp") && wptValue instanceof MIConst) {
                            exp = ((MIConst)wptValue).getString();
                        }
                        ++var11_12;
                    }
                }
            } else if (var.equals("value") && value instanceof MITuple) {
                var13_14 = ((MITuple)value).getMIResults();
                var12_13 = var13_14.length;
                var11_12 = 0;
                while (var11_12 < var12_13) {
                    MIResult valueResult = var13_14[var11_12];
                    String valueVar = valueResult.getVariable();
                    MIValue valueValue = valueResult.getMIValue();
                    str = "";
                    if (valueValue instanceof MIConst) {
                        str = ((MIConst)valueValue).getString();
                    }
                    if (valueVar.equals("old")) {
                        oldValue = str;
                    } else if (valueVar.equals("new")) {
                        newValue = str;
                    } else if (valueVar.equals("value")) {
                        oldValue = newValue = str;
                    }
                    ++var11_12;
                }
            }
            ++i;
        }
        MIStoppedEvent stoppedEvent = MIStoppedEvent.parse(dmc, token, results);
        return new MIWatchpointTriggerEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), number, exp, oldValue, newValue);
    }
}

