/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.launch;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;

public abstract class JavaElementSelection {
    public final List<String> resolveTests() {
        return ImmutableList.builder().addAll((Iterable)this.getSelectedTypes().stream().map(t -> t.getFullyQualifiedName()).collect(Collectors.toList())).addAll((Iterable)this.getSelectedMethods().stream().map(m -> m.getDeclaringType().getFullyQualifiedName() + "#" + m.getElementName()).collect(Collectors.toList())).build();
    }

    public final List<IMethod> getSelectedMethods() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (IJavaElement javaElement : this.findJavaElements()) {
            Optional<IMethod> method = this.resolveMethod(javaElement);
            if (!method.isPresent()) continue;
            result.add((Object)((IMethod)method.get()));
        }
        return result.build();
    }

    private Optional<IMethod> resolveMethod(IJavaElement javaElement) {
        if (javaElement.getJavaProject() == null || javaElement.getJavaProject().getProject() == null) {
            return Optional.absent();
        }
        if (javaElement instanceof IMethod) {
            IMethod method = (IMethod)javaElement;
            return method.getDeclaringType() != null ? Optional.of((Object)method) : Optional.absent();
        }
        return Optional.absent();
    }

    public final List<IType> getSelectedTypes() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (IJavaElement javaElement : this.findJavaElements()) {
            Optional<IType> type = this.resolveType(javaElement);
            if (!type.isPresent()) continue;
            result.add((Object)((IType)type.get()));
        }
        return result.build();
    }

    private Optional<IType> resolveType(IJavaElement javaElement) {
        if (javaElement.getJavaProject() == null || javaElement.getJavaProject().getProject() == null) {
            return Optional.absent();
        }
        IType result = null;
        switch (javaElement.getElementType()) {
            case 7: {
                result = (IType)javaElement;
                break;
            }
            case 8: {
                result = ((IField)javaElement).getDeclaringType();
                break;
            }
            case 5: 
            case 6: {
                result = ((ITypeRoot)javaElement).findPrimaryType();
            }
        }
        return Optional.fromNullable(result);
    }

    public Optional<IProject> findFirstContainerProject() {
        for (IJavaElement javaElement : this.findJavaElements()) {
            IProject project;
            IJavaProject javaProject = javaElement.getJavaProject();
            if (javaProject == null || (project = javaProject.getProject()) == null) continue;
            return Optional.of((Object)project);
        }
        return Optional.absent();
    }

    protected abstract Collection<IJavaElement> findJavaElements();
}

