/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.solr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrDocument;
import org.eclipse.rdf4j.sail.lucene.SearchDocument;
import org.eclipse.rdf4j.sail.solr.SolrIndex;

public class SolrSearchDocument
implements SearchDocument {
    private final SolrDocument doc;

    public SolrSearchDocument() {
        this(new SolrDocument());
    }

    public SolrSearchDocument(SolrDocument doc) {
        this.doc = doc;
    }

    public SolrSearchDocument(String id, String resourceId, String context) {
        this();
        this.doc.put("id", (Object)id);
        this.doc.put("uri", (Object)resourceId);
        if (context != null) {
            this.doc.put("context", (Object)context);
        }
    }

    public SolrDocument getDocument() {
        return this.doc;
    }

    public String getId() {
        return (String)this.doc.get((Object)"id");
    }

    public String getResource() {
        return (String)this.doc.get((Object)"uri");
    }

    public String getContext() {
        return (String)this.doc.get((Object)"context");
    }

    public Set<String> getPropertyNames() {
        return SolrIndex.getPropertyFields(this.doc.keySet());
    }

    public void addProperty(String name) {
    }

    public void addProperty(String name, String text) {
        SolrSearchDocument.addField(name, text, (Map<String, Object>)this.doc);
        SolrSearchDocument.addField("text", text, (Map<String, Object>)this.doc);
    }

    public void addGeoProperty(String name, String text) {
        SolrSearchDocument.addField(name, text, (Map<String, Object>)this.doc);
    }

    public boolean hasProperty(String name, String value) {
        List<String> fieldValues = SolrSearchDocument.asStringList(this.doc.get((Object)name));
        if (fieldValues != null) {
            for (String fieldValue : fieldValues) {
                if (!value.equals(fieldValue)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getProperty(String name) {
        return SolrSearchDocument.asStringList(this.doc.get((Object)name));
    }

    private static void addField(String name, String value, Map<String, Object> document) {
        Object newValue;
        Object oldValue = document.get(name);
        if (oldValue != null) {
            List<String> newList = SolrSearchDocument.makeModifiable(SolrSearchDocument.asStringList(oldValue));
            newList.add(value);
            newValue = newList;
        } else {
            newValue = value;
        }
        document.put(name, newValue);
    }

    private static List<String> makeModifiable(List<String> l) {
        List<String> modList;
        if (!(l instanceof ArrayList)) {
            modList = new ArrayList<String>(l.size() + 1);
            modList.addAll(l);
        } else {
            modList = l;
        }
        return modList;
    }

    private static List<String> asStringList(Object value) {
        List<String> l = value == null ? null : (value instanceof List ? (List<String>)value : Collections.singletonList((String)value));
        return l;
    }
}

