/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.dependencies;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesLabelProvider;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.PlatformUI;

public class HistoryAction
extends Action {
    private final String fElement;
    private final DependenciesView fView;

    public HistoryAction(DependenciesView view, String element) {
        this.fView = view;
        this.fElement = element;
        String elementName = element.toString();
        this.setText(elementName);
        this.setImageDescriptor(this.getImageDescriptor(elementName));
        this.setDisabledImageDescriptor(PDEPluginImages.DESC_PLUGIN_OBJ);
        this.setDescription(NLS.bind((String)PDEUIMessages.HistoryAction_description, (Object)elementName));
        this.setToolTipText(NLS.bind((String)PDEUIMessages.HistoryAction_tooltip, (Object)elementName));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.pde.doc.user.history_action");
    }

    private ImageDescriptor getImageDescriptor(String element) {
        DependenciesLabelProvider imageProvider = new DependenciesLabelProvider(false);
        ImageImageDescriptor desc = new ImageImageDescriptor(imageProvider.getImage(element));
        imageProvider.dispose();
        return desc;
    }

    public void run() {
        this.fView.gotoHistoryEntry(this.fElement);
    }

    public class ImageImageDescriptor
    extends ImageDescriptor {
        private final Image fImage;

        public ImageImageDescriptor(Image image) {
            this.fImage = image;
        }

        public boolean equals(Object obj) {
            return obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass()) && this.fImage.equals((Object)((ImageImageDescriptor)((Object)obj)).fImage);
        }

        public ImageData getImageData() {
            return this.fImage.getImageData();
        }

        public int hashCode() {
            return this.fImage.hashCode();
        }
    }
}

