/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Observable;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.base.util.TString;
import org.osgi.service.prefs.BackingStoreException;

public class BookmarkManager
extends Observable {
    public static final int REMOVE_ALL = 1;
    public static final int ADD = 2;
    public static final int REMOVE = 3;
    public static final int CHANGE = 4;
    public static final int WORLD_CHANGED = 5;
    private ArrayList<Bookmark> bookmarks;

    public void close() {
    }

    public void addBookmark(String bookmarkURL, String title) {
        if (bookmarkURL != null && bookmarkURL.length() > 0 && !bookmarkURL.equals("about:blank")) {
            if (title == null) {
                return;
            }
            Object bookmarks = this.readBookmarks();
            if (((String)bookmarks).contains("," + BookmarkManager.encode(bookmarkURL) + "|")) {
                return;
            }
            bookmarks = (String)bookmarks + "," + BookmarkManager.encode(bookmarkURL) + "|" + BookmarkManager.encode(title);
            this.saveBookmarks((String)bookmarks);
            Bookmark bookmark = new Bookmark(title, bookmarkURL);
            if (this.bookmarks != null) {
                this.bookmarks.add(bookmark);
            }
            this.setChanged();
            this.notifyObservers(new BookmarkEvent(2, bookmark));
        }
    }

    public void removeBookmark(String bookmarkURL, String title) {
        this.removeBookmark(new Bookmark(title, bookmarkURL));
    }

    public void removeBookmark(Bookmark bookmark) {
        String bookmarkURL = bookmark.getHref();
        String title = bookmark.getLabel();
        if (bookmarkURL != null && bookmarkURL.length() > 0 && !bookmarkURL.equals("about:blank")) {
            String removeString;
            if (title == null) {
                return;
            }
            Object bookmarks = this.readBookmarks();
            int i = ((String)bookmarks).indexOf(removeString = "," + BookmarkManager.encode(bookmarkURL) + "|" + BookmarkManager.encode(title));
            if (i == -1) {
                return;
            }
            bookmarks = ((String)bookmarks).substring(0, i) + ((String)bookmarks).substring(i + removeString.length());
            this.saveBookmarks((String)bookmarks);
            if (this.bookmarks != null) {
                this.bookmarks.remove(bookmark);
            }
            this.setChanged();
            this.notifyObservers(new BookmarkEvent(3, bookmark));
        }
    }

    public void removeAllBookmarks() {
        this.saveBookmarks("");
        if (this.bookmarks != null) {
            this.bookmarks.clear();
        }
        this.setChanged();
        this.notifyObservers(new BookmarkEvent(1, null));
    }

    public IHelpResource[] getBookmarks() {
        if (this.bookmarks == null) {
            String value = this.readBookmarks();
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            this.bookmarks = new ArrayList();
            while (tokenizer.hasMoreTokens()) {
                String bookmark = tokenizer.nextToken();
                int separator = bookmark.indexOf(124);
                String label = BookmarkManager.decode(bookmark.substring(separator + 1));
                String href = separator < 0 ? "" : BookmarkManager.decode(bookmark.substring(0, separator));
                this.bookmarks.add(new Bookmark(label, href));
            }
        }
        return this.bookmarks.toArray(new IHelpResource[this.bookmarks.size()]);
    }

    private static String encode(String s) {
        s = TString.change(s, "\\", "\\escape");
        s = TString.change(s, ",", "\\comma");
        return TString.change(s, "|", "\\pipe");
    }

    private static String decode(String s) {
        s = TString.change(s, "\\pipe", "|");
        s = TString.change(s, "\\comma", ",");
        return TString.change(s, "\\escape", "\\");
    }

    private String readBookmarks() {
        return Platform.getPreferencesService().getString("org.eclipse.help.base", "bookmarks", "", null);
    }

    private void saveBookmarks(String bookmarks) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
        prefs.put("bookmarks", bookmarks);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static class Bookmark
    implements IHelpResource {
        private final String label;
        private final String href;

        public Bookmark(String label, String href) {
            this.label = label;
            this.href = href;
        }

        public String getHref() {
            return this.href;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Bookmark other = (Bookmark)obj;
            return Objects.equals(this.href, other.href) && Objects.equals(this.label, other.label);
        }

        public int hashCode() {
            return Objects.hash(this.href, this.label);
        }
    }

    public static class BookmarkEvent {
        private final int type;
        private final Bookmark bookmark;

        public BookmarkEvent(int type, Bookmark bookmark) {
            this.type = type;
            this.bookmark = bookmark;
        }

        public int getType() {
            return this.type;
        }

        public Bookmark getBookmark() {
            return this.bookmark;
        }
    }
}

