/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.CheckedIntConsumer;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.util.FixedBitSet;

final class BitSetDocIdStream
extends DocIdStream {
    private final FixedBitSet bitSet;
    private final int offset;
    private final int max;
    private int upTo;

    BitSetDocIdStream(FixedBitSet bitSet, int offset) {
        this.bitSet = bitSet;
        this.offset = offset;
        this.upTo = offset;
        this.max = (int)Math.min(Integer.MAX_VALUE, (long)offset + (long)bitSet.length());
    }

    @Override
    public boolean mayHaveRemaining() {
        return this.upTo < this.max;
    }

    @Override
    public void forEach(int upTo, CheckedIntConsumer<IOException> consumer) throws IOException {
        if (upTo > this.upTo) {
            upTo = Math.min(upTo, this.max);
            this.bitSet.forEach(this.upTo - this.offset, upTo - this.offset, this.offset, consumer);
            this.upTo = upTo;
        }
    }

    @Override
    public int count(int upTo) throws IOException {
        if (upTo > this.upTo) {
            upTo = Math.min(upTo, this.max);
            int count = this.bitSet.cardinality(this.upTo - this.offset, upTo - this.offset);
            this.upTo = upTo;
            return count;
        }
        return 0;
    }
}

