/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManagerElement;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class P2LabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private static final String EXTENSION_POINT_ID = P2UIPlugin.INSTANCE.getSymbolicName() + ".profileTypes";
    private static final Map<String, Image> profileImages = new HashMap<String, Image>();
    private IFontProvider fontProvider;
    private boolean absolutePools;

    public P2LabelProvider() {
    }

    public P2LabelProvider(IFontProvider fontProvider) {
        this.fontProvider = fontProvider;
    }

    public boolean isAbsolutePools() {
        return this.absolutePools;
    }

    public void setAbsolutePools(boolean absolutePools) {
        this.absolutePools = absolutePools;
    }

    public Image getImage(Object element) {
        if (element instanceof Agent) {
            return P2UIPlugin.INSTANCE.getSWTImage("obj16/agent");
        }
        if (element instanceof BundlePool) {
            return P2UIPlugin.INSTANCE.getSWTImage("obj16/bundlePool");
        }
        if (element instanceof Profile) {
            return P2LabelProvider.getProfileImage((Profile)element);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof BundlePool && !this.absolutePools) {
            Agent agent;
            String agentPath;
            BundlePool bundlePool = (BundlePool)element;
            String bundlePoolPath = bundlePool.getLocation().getAbsolutePath();
            if (bundlePoolPath.startsWith(agentPath = (agent = bundlePool.getAgent()).getLocation().getAbsolutePath() + File.pathSeparator)) {
                bundlePoolPath = bundlePoolPath.substring(agentPath.length());
            }
            return bundlePoolPath;
        }
        if (element instanceof Profile) {
            return ((Profile)element).getProfileId();
        }
        return element.toString();
    }

    public Color getForeground(Object element) {
        AgentManagerElement agentManagerElement;
        if (element instanceof AgentManagerElement && !(agentManagerElement = (AgentManagerElement)element).isUsed()) {
            return UIUtil.getDisplay().getSystemColor(16);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Font getFont(Object element) {
        return this.fontProvider == null ? null : this.fontProvider.getFont(element);
    }

    private static Image loadProfileImage(String profileType) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String icon;
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String name = configurationElement.getAttribute("name");
            if (ObjectUtil.equals((Object)name, (Object)profileType) && (icon = configurationElement.getAttribute("icon")) != null) {
                ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)configurationElement.getNamespaceIdentifier(), (String)icon);
                return P2UIPlugin.INSTANCE.getSWTImage(descriptor);
            }
            ++n2;
        }
        return P2UIPlugin.INSTANCE.getSWTImage("obj16/profileUnknown");
    }

    public static Image getProfileImage(Profile profile) {
        String profileType = profile.getType();
        Image image = profileImages.get(profileType);
        if (image == null) {
            image = P2LabelProvider.loadProfileImage(profileType);
            profileImages.put(profileType, image);
        }
        return image;
    }
}

