/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ctreecombo;

import org.eclipse.nebula.widgets.ctreecombo.CTreeCombo;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class CTreeComboColumn
extends Item {
    private TreeColumn realTreeColumn;
    private CTreeCombo parent;
    private int width;

    public CTreeComboColumn(CTreeCombo parent, int style) {
        super((Widget)parent, style);
        this.parent = parent;
        this.parent.columns.add(this);
        if (this.parent.tree != null && !this.parent.tree.isDisposed()) {
            this.setRealTreeColumn(new TreeColumn(parent.tree, style));
        }
    }

    public CTreeComboColumn(CTreeCombo parent, int style, int index) {
        super((Widget)parent, style, index);
        this.parent = parent;
        this.parent.columns.add(this);
        if (this.parent.tree != null && !this.parent.tree.isDisposed()) {
            this.setRealTreeColumn(new TreeColumn(parent.tree, style, index));
        }
    }

    void setRealTreeColumn(TreeColumn realTreeColumn) {
        this.realTreeColumn = realTreeColumn;
        this.realTreeColumn.setText(this.getText());
        this.realTreeColumn.setWidth(this.width);
    }

    TreeColumn getRealTreeColumn() {
        return this.realTreeColumn;
    }

    private boolean checkRealColumn() {
        return this.realTreeColumn != null && !this.realTreeColumn.isDisposed();
    }

    public int getWidth() {
        this.checkWidget();
        if (this.checkRealColumn()) {
            return this.realTreeColumn.getWidth();
        }
        return 0;
    }

    public void setWidth(int width) {
        this.checkWidget();
        this.width = width;
        this.realTreeColumn.setWidth(width);
    }

    public void setText(String string) {
        this.checkWidget();
        super.setText(string);
        this.realTreeColumn.setText(string);
    }
}

