/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap;

import org.eclipse.nebula.widgets.geomap.PointD;
import org.eclipse.nebula.widgets.geomap.internal.GeoMapPositioned;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GeoMapUtil {
    private static final int TILE_SIZE = 256;
    private static int zoomMargin = 10;

    public static PointD getLongitudeLatitude(Point position, int zoom) {
        return new PointD(GeoMapUtil.position2lon(position.x, zoom), GeoMapUtil.position2lat(position.y, zoom));
    }

    public static Point computePosition(PointD coords, int zoom) {
        int x = GeoMapUtil.lon2position(coords.x, zoom);
        int y = GeoMapUtil.lat2position(coords.y, zoom);
        return new Point(x, y);
    }

    public static double position2lon(int x, int z) {
        double xmax = 256 * (1 << z);
        return (double)x / xmax * 360.0 - 180.0;
    }

    public static double position2lat(int y, int z) {
        double ymax = 256 * (1 << z);
        return Math.toDegrees(Math.atan(Math.sinh(Math.PI - Math.PI * 2 * (double)y / ymax)));
    }

    public static int lon2position(double lon, int z) {
        double xmax = 256 * (1 << z);
        return (int)Math.floor((lon + 180.0) / 360.0 * xmax);
    }

    public static int lat2position(double lat, int z) {
        double ymax = 256 * (1 << z);
        return (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * ymax);
    }

    public static void translateMapPosition(GeoMapPositioned geoMap, int tx, int ty) {
        Point mapPosition = geoMap.getMapPosition();
        geoMap.setMapPosition(mapPosition.x + tx, mapPosition.y + ty);
    }

    public static void zoomIn(GeoMapPositioned geoMap, Point pivot) {
        if (geoMap.getZoom() >= geoMap.getMaxZoom()) {
            return;
        }
        Point mapPosition = geoMap.getMapPosition();
        int dx = pivot.x;
        int dy = pivot.y;
        geoMap.setMapPosition(mapPosition.x * 2 + dx, mapPosition.y * 2 + dy);
        geoMap.setZoom(geoMap.getZoom() + 1);
    }

    public static void zoomOut(GeoMapPositioned geoMap, Point pivot) {
        if (geoMap.getZoom() <= geoMap.getMinZoom()) {
            return;
        }
        Point mapPosition = geoMap.getMapPosition();
        int dx = pivot.x;
        int dy = pivot.y;
        geoMap.setMapPosition((mapPosition.x - dx) / 2, (mapPosition.y - dy) / 2);
        geoMap.setZoom(geoMap.getZoom() - 1);
    }

    public static void zoomTo(GeoMapPositioned geoMap, Point mapSize, Rectangle rect, int maxZoom) {
        Rectangle zoomRectangle = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        if (mapSize.x < zoomMargin || mapSize.y < zoomMargin) {
            return;
        }
        if (maxZoom < geoMap.getMinZoom()) {
            maxZoom = geoMap.getMaxZoom();
        }
        int zoom = geoMap.getZoom();
        while (zoom > geoMap.getMinZoom() && (mapSize.x < zoomRectangle.width + zoomMargin || mapSize.y < zoomRectangle.height + zoomMargin || zoom > maxZoom)) {
            --zoom;
            zoomRectangle.x /= 2;
            zoomRectangle.y /= 2;
            zoomRectangle.width /= 2;
            zoomRectangle.height /= 2;
        }
        while (mapSize.x > zoomRectangle.width * 2 + zoomMargin && mapSize.y > zoomRectangle.height * 2 + zoomMargin && zoom < maxZoom) {
            ++zoom;
            zoomRectangle.x *= 2;
            zoomRectangle.y *= 2;
            zoomRectangle.width *= 2;
            zoomRectangle.height *= 2;
        }
        geoMap.setMapPosition(zoomRectangle.x + (zoomRectangle.width - mapSize.x) / 2, zoomRectangle.y + (zoomRectangle.height - mapSize.y) / 2);
        geoMap.setZoom(zoom);
    }
}

