/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.effects.stw.transitions;

import org.eclipse.nebula.effects.stw.Transition;
import org.eclipse.nebula.effects.stw.TransitionManager;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class FadeTransition
extends Transition {
    private int _aw = 255;
    private int _halfAW = 127;
    private double _aFrom;
    private double _aTo;
    private double _alphaFrom;
    private double _alphaTo;
    private double _alphaFrom0;
    private double _alphaTo0;
    private double _vFrom0;
    private double _vTo0;
    private boolean _flag1;
    private boolean _flag2;
    private long _t1;
    private long _TFrom;
    private long _TTo;
    private long _halfTFrom;
    private long _halfTTo;
    private long _fadeOutStartT;
    private long _fadeOutMidT;
    private long _fadeOutStopT;
    private long _fadeInStartT;
    private long _fadeInMidT;
    private long _fadeInStopT;
    private double _fadeOutStart = 0.0;
    private double _fadeOutStop = 100.0;
    private double _fadeInStart = 0.0;
    private double _fadeInStop = 100.0;

    public FadeTransition(TransitionManager transitionManager) {
        this(transitionManager, 60L, 1000L);
    }

    public FadeTransition(TransitionManager transitionManager, long fps, long T) {
        super(transitionManager, fps, T);
    }

    @Override
    protected void initTransition(Image from, Image to, GC gc, double direction) {
        this._alphaFrom = this._aw;
        this._alphaTo = 0.0;
        this._fadeOutStartT = (long)(this._fadeOutStart * (double)this._T / 100.0);
        this._fadeOutStopT = (long)(this._fadeOutStop * (double)this._T / 100.0);
        this._fadeOutMidT = (long)((double)(this._fadeOutStartT + this._fadeOutStopT) / 2.0);
        this._fadeInStartT = (long)(this._fadeInStart * (double)this._T / 100.0);
        this._fadeInStopT = (long)(this._fadeInStop * (double)this._T / 100.0);
        this._fadeInMidT = (long)((double)(this._fadeInStartT + this._fadeInStopT) / 2.0);
        this._TFrom = this._fadeOutStopT - this._fadeOutStartT;
        this._TTo = this._fadeInStopT - this._fadeInStartT;
        this._halfTFrom = (long)((double)this._TFrom / 2.0);
        this._halfTTo = (long)((double)this._TTo / 2.0);
        this._aFrom = (double)(this._aw + 1) / (double)(this._halfTFrom * this._halfTFrom);
        this._aTo = (double)(this._aw + 1) / (double)(this._halfTTo * this._halfTTo);
        this._flag1 = false;
        this._flag2 = false;
    }

    @Override
    protected void stepTransition(long t, Image from, Image to, GC gc, double direction) {
        if (t >= 0L && t < this._fadeOutStartT) {
            gc.drawImage(from, 0, 0);
        } else if (t >= this._fadeOutStartT && t < this._fadeOutMidT) {
            gc.setAlpha((int)this._alphaFrom);
            gc.drawImage(from, 0, 0);
            this._t1 = t - this._fadeOutStartT;
            this._alphaFrom = (double)this._aw - Math.min(0.5 * this._aFrom * (double)this._t1 * (double)this._t1, (double)this._halfAW);
        } else if (t >= this._fadeOutMidT && t <= this._fadeOutStopT) {
            gc.setAlpha((int)this._alphaFrom);
            gc.drawImage(from, 0, 0);
            if (!this._flag1) {
                this._alphaFrom0 = (double)this._aw - this._alphaFrom;
                this._vFrom0 = this._aFrom * (double)(t - this._fadeOutStartT);
                this._aFrom *= -1.0;
                this._flag1 = true;
            }
            this._t1 = t - this._fadeOutMidT;
            this._alphaFrom = (double)this._aw - Math.min(this._alphaFrom0 + this._vFrom0 * (double)this._t1 + 0.5 * this._aFrom * (double)this._t1 * (double)this._t1, (double)this._aw);
        }
        if (t >= this._fadeInStartT && t < this._fadeInMidT) {
            gc.setAlpha((int)this._alphaTo);
            gc.drawImage(to, 0, 0);
            this._t1 = t - this._fadeInStartT;
            this._alphaTo = Math.min(0.5 * this._aTo * (double)this._t1 * (double)this._t1, (double)this._halfAW);
        } else if (t >= this._fadeInMidT && t <= this._fadeInStopT) {
            gc.setAlpha((int)this._alphaTo);
            gc.drawImage(to, 0, 0);
            if (!this._flag2) {
                this._alphaTo0 = this._alphaTo;
                this._vTo0 = this._aTo * (double)(t - this._fadeInStartT);
                this._aTo *= -1.0;
                this._flag2 = true;
            }
            this._t1 = t - this._fadeInMidT;
            this._alphaTo = Math.min(this._alphaTo0 + this._vTo0 * (double)this._t1 + 0.5 * this._aTo * (double)this._t1 * (double)this._t1, (double)this._aw);
        } else if (t > this._fadeInStopT) {
            gc.drawImage(to, 0, 0);
        }
    }

    @Override
    protected void endTransition(Image from, Image to, GC gc, double direction) {
    }

    public void setFadeOutStart(double percentage) {
        if (percentage >= 0.0 && percentage <= 100.0) {
            this._fadeOutStart = percentage;
        }
    }

    public void setFadeOutStop(double percentage) {
        if (percentage >= 0.0 && percentage <= 100.0) {
            this._fadeOutStop = percentage;
        }
    }

    public void setFadeInStart(double percentage) {
        if (percentage >= 0.0 && percentage <= 100.0) {
            this._fadeInStart = percentage;
        }
    }

    public void setFadeInStop(double percentage) {
        if (percentage >= 0.0 && percentage <= 100.0) {
            this._fadeInStop = percentage;
        }
    }
}

