/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.EscapedCharacter;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.HardLineBreak;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.SourceSpan;

public class BackslashEscapeSpan
extends SourceSpan {
    private static char[] ESCAPABLE = "!\"\\#$%&'()*+,-./:;<=>?@[]^_`{|}~".toCharArray();

    static {
        Arrays.sort(ESCAPABLE);
    }

    @Override
    public Optional<? extends Inline> createInline(Cursor cursor) {
        char c = cursor.getChar();
        if (c == '\\' && cursor.hasNext()) {
            if (cursor.getNext() == '\n') {
                return Optional.of(new HardLineBreak(cursor.getLineAtOffset(), cursor.getOffset(), 2));
            }
            if (this.isEscapable(cursor.getNext())) {
                return Optional.of(new EscapedCharacter(cursor.getLineAtOffset(), cursor.getOffset(), cursor.getNext()));
            }
        }
        return Optional.empty();
    }

    private boolean isEscapable(char c) {
        return Arrays.binarySearch(ESCAPABLE, c) >= 0;
    }
}

